/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.rrd4j.graph.DirectGif89Frame;
import org.rrd4j.graph.Gif89Frame;
import org.rrd4j.graph.GifColorTable;
import org.rrd4j.graph.IndexGif89Frame;
import org.rrd4j.graph.Put;

class GifEncoder {
    private Dimension dispDim = new Dimension(0, 0);
    private GifColorTable colorTable;
    private int bgIndex = 0;
    private int loopCount = 1;
    private String theComments;
    private Vector<Gif89Frame> vFrames = new Vector();

    GifEncoder() {
        this.colorTable = new GifColorTable();
    }

    GifEncoder(Image image) throws IOException {
        this();
        this.addFrame(image);
    }

    GifEncoder(Color[] colorArray) {
        this.colorTable = new GifColorTable(colorArray);
    }

    GifEncoder(Color[] colorArray, int n, int n2, byte[] byArray) throws IOException {
        this(colorArray);
        this.addFrame(n, n2, byArray);
    }

    int getFrameCount() {
        return this.vFrames.size();
    }

    Gif89Frame getFrameAt(int n) {
        return this.isOk(n) ? this.vFrames.elementAt(n) : null;
    }

    void addFrame(Gif89Frame gif89Frame) throws IOException {
        this.accommodateFrame(gif89Frame);
        this.vFrames.addElement(gif89Frame);
    }

    void addFrame(Image image) throws IOException {
        this.addFrame(new DirectGif89Frame(image));
    }

    void addFrame(int n, int n2, byte[] byArray) throws IOException {
        this.addFrame(new IndexGif89Frame(n, n2, byArray));
    }

    void insertFrame(int n, Gif89Frame gif89Frame) throws IOException {
        this.accommodateFrame(gif89Frame);
        this.vFrames.insertElementAt(gif89Frame, n);
    }

    void setTransparentIndex(int n) {
        this.colorTable.setTransparent(n);
    }

    void setLogicalDisplay(Dimension dimension, int n) {
        this.dispDim = new Dimension(dimension);
        this.bgIndex = n;
    }

    void setLoopCount(int n) {
        this.loopCount = n;
    }

    void setComments(String string) {
        this.theComments = string;
    }

    void setUniformDelay(int n) {
        for (int i = 0; i < this.vFrames.size(); ++i) {
            this.vFrames.elementAt(i).setDelay(n);
        }
    }

    void encode(OutputStream outputStream) throws IOException {
        int n = this.getFrameCount();
        boolean bl = n > 1;
        this.colorTable.closePixelProcessing();
        Put.ascii("GIF89a", outputStream);
        this.writeLogicalScreenDescriptor(outputStream);
        this.colorTable.encode(outputStream);
        if (bl && this.loopCount != 1) {
            this.writeNetscapeExtension(outputStream);
        }
        if (this.theComments != null && this.theComments.length() > 0) {
            this.writeCommentExtension(outputStream);
        }
        for (int i = 0; i < n; ++i) {
            this.vFrames.elementAt(i).encode(outputStream, bl, this.colorTable.getDepth(), this.colorTable.getTransparent());
        }
        outputStream.write(59);
        outputStream.flush();
    }

    private void accommodateFrame(Gif89Frame gif89Frame) throws IOException {
        this.dispDim.width = Math.max(this.dispDim.width, gif89Frame.getWidth());
        this.dispDim.height = Math.max(this.dispDim.height, gif89Frame.getHeight());
        this.colorTable.processPixels(gif89Frame);
    }

    private void writeLogicalScreenDescriptor(OutputStream outputStream) throws IOException {
        Put.leShort(this.dispDim.width, outputStream);
        Put.leShort(this.dispDim.height, outputStream);
        outputStream.write(0xF0 | this.colorTable.getDepth() - 1);
        outputStream.write(this.bgIndex);
        outputStream.write(0);
    }

    private void writeNetscapeExtension(OutputStream outputStream) throws IOException {
        outputStream.write(33);
        outputStream.write(255);
        outputStream.write(11);
        Put.ascii("NETSCAPE2.0", outputStream);
        outputStream.write(3);
        outputStream.write(1);
        Put.leShort(this.loopCount > 1 ? this.loopCount - 1 : 0, outputStream);
        outputStream.write(0);
    }

    private void writeCommentExtension(OutputStream outputStream) throws IOException {
        outputStream.write(33);
        outputStream.write(254);
        int n = this.theComments.length() % 255;
        int n2 = this.theComments.length() / 255;
        int n3 = n2 + (n > 0 ? 1 : 0);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = i < n2 ? 255 : n;
            outputStream.write(n5);
            Put.ascii(this.theComments.substring(n4, n4 + n5), outputStream);
            n4 += n5;
        }
        outputStream.write(0);
    }

    private boolean isOk(int n) {
        return n >= 0 && n < this.vFrames.size();
    }
}

