/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import org.rrd4j.core.jrrd.Constants;
import org.rrd4j.core.jrrd.RRDFile;

public class Header
implements Constants {
    static final long offset = 0L;
    long size;
    String version;
    int dsCount;
    int rraCount;
    int pdpStep;

    Header(RRDFile rRDFile) throws IOException {
        if (!rRDFile.readString(4).equals("RRD")) {
            throw new IOException("Invalid COOKIE");
        }
        this.version = rRDFile.readString(5);
        if (!this.version.equals("0001")) {
            throw new IOException("Unsupported RRD version (" + this.version + ")");
        }
        rRDFile.align();
        rRDFile.readDouble();
        this.dsCount = rRDFile.readInt();
        this.rraCount = rRDFile.readInt();
        this.pdpStep = rRDFile.readInt();
        rRDFile.align();
        rRDFile.skipBytes(80);
        this.size = rRDFile.getFilePointer() - 0L;
    }

    public String getVersion() {
        return this.version;
    }

    public int getDSCount() {
        return this.dsCount;
    }

    public int getRRACount() {
        return this.rraCount;
    }

    public int getPDPStep() {
        return this.pdpStep;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Header: OFFSET=0x00, SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", version=");
        stringBuilder.append(this.version);
        stringBuilder.append(", dsCount=");
        stringBuilder.append(this.dsCount);
        stringBuilder.append(", rraCount=");
        stringBuilder.append(this.rraCount);
        stringBuilder.append(", pdpStep=");
        stringBuilder.append(this.pdpStep);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

