/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XmlReader
extends DataImporter {
    private Element root;
    private Node[] dsNodes;
    private Node[] arcNodes;

    XmlReader(String string) throws IOException {
        this.root = Util.Xml.getRootElement(new File(string));
        this.dsNodes = Util.Xml.getChildNodes(this.root, "ds");
        this.arcNodes = Util.Xml.getChildNodes(this.root, "rra");
    }

    String getVersion() {
        return Util.Xml.getChildValue(this.root, "version");
    }

    long getLastUpdateTime() {
        return Util.Xml.getChildValueAsLong(this.root, "lastupdate");
    }

    long getStep() {
        return Util.Xml.getChildValueAsLong(this.root, "step");
    }

    int getDsCount() {
        return this.dsNodes.length;
    }

    int getArcCount() {
        return this.arcNodes.length;
    }

    String getDsName(int n) {
        return Util.Xml.getChildValue(this.dsNodes[n], "name");
    }

    String getDsType(int n) {
        return Util.Xml.getChildValue(this.dsNodes[n], "type");
    }

    long getHeartbeat(int n) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[n], "minimal_heartbeat");
    }

    double getMinValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "min");
    }

    double getMaxValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "max");
    }

    double getLastValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "last_ds");
    }

    double getAccumValue(int n) {
        return Util.Xml.getChildValueAsDouble(this.dsNodes[n], "value");
    }

    long getNanSeconds(int n) {
        return Util.Xml.getChildValueAsLong(this.dsNodes[n], "unknown_sec");
    }

    ConsolFun getConsolFun(int n) {
        return ConsolFun.valueOf(Util.Xml.getChildValue(this.arcNodes[n], "cf"));
    }

    double getXff(int n) {
        return Util.Xml.getChildValueAsDouble(this.arcNodes[n], "xff");
    }

    int getSteps(int n) {
        return Util.Xml.getChildValueAsInt(this.arcNodes[n], "pdp_per_row");
    }

    double getStateAccumValue(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "cdp_prep");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "ds");
        return Util.Xml.getChildValueAsDouble(nodeArray[n2], "value");
    }

    int getStateNanSteps(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "cdp_prep");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "ds");
        return Util.Xml.getChildValueAsInt(nodeArray[n2], "unknown_datapoints");
    }

    int getRows(int n) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "database");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "row");
        return nodeArray.length;
    }

    double[] getValues(int n, int n2) {
        Node node = Util.Xml.getFirstChildNode(this.arcNodes[n], "database");
        Node[] nodeArray = Util.Xml.getChildNodes(node, "row");
        double[] dArray = new double[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Node[] nodeArray2 = Util.Xml.getChildNodes(nodeArray[i], "v");
            Node node2 = nodeArray2[n2];
            dArray[i] = Util.parseDouble(node2.getFirstChild().getNodeValue().trim());
        }
        return dArray;
    }
}

