/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.jul.xml;

import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.jul.xml.LoggingEventReader;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.input.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JulImportCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(JulImportCallable.class);
    public static final String CLOSING_LOG4J_EVENT_TAG = "</log4j:event>";
    public static final String LOG4J_NAMESPACE = "xmlns:log4j=\"http://jakarta.apache.org/log4j/\"";
    public static final String OPENING_LOG4J_EVENT_TAG_EXCL_NS = "<log4j:event ";
    public static final String OPENING_LOG4J_EVENT_TAG_INCL_NS = "<log4j:event xmlns:log4j=\"http://jakarta.apache.org/log4j/\" ";
    private File inputFile;
    private AppendOperation<EventWrapper<LoggingEvent>> buffer;
    private LoggingEventReader instance;
    private long result;

    public JulImportCallable(File inputFile, AppendOperation<EventWrapper<LoggingEvent>> buffer) {
        this.buffer = buffer;
        this.inputFile = inputFile;
        this.instance = new LoggingEventReader();
    }

    public AppendOperation<EventWrapper<LoggingEvent>> getBuffer() {
        return this.buffer;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public Long call() throws Exception {
        if (!this.inputFile.isFile()) {
            throw new IllegalArgumentException("'" + this.inputFile.getAbsolutePath() + "' is not a file!");
        }
        if (!this.inputFile.canRead()) {
            throw new IllegalArgumentException("'" + this.inputFile.getAbsolutePath() + "' is not a readable!");
        }
        long fileSize = this.inputFile.length();
        this.setNumberOfSteps(fileSize);
        FileInputStream fis = new FileInputStream(this.inputFile);
        CountingInputStream cis = new CountingInputStream((InputStream)fis);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(new InputStreamReader((InputStream)cis, "utf-8"));
        block2: while (true) {
            try {
                while (true) {
                    LoggingEvent event = this.instance.read(reader);
                    this.setCurrentStep(cis.getByteCount());
                    if (event == null) break block2;
                    ++this.result;
                    EventWrapper wrapper = new EventWrapper();
                    wrapper.setEvent((Serializable)event);
                    SourceIdentifier sourceIdentifier = new SourceIdentifier(this.inputFile.getAbsolutePath());
                    EventIdentifier eventId = new EventIdentifier(sourceIdentifier, this.result);
                    wrapper.setEventIdentifier(eventId);
                    this.buffer.add((Object)wrapper);
                }
            }
            catch (XMLStreamException ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Exception while importing...", (Throwable)ex);
                continue;
            }
            break;
        }
        return this.result;
    }
}

