/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.DatePickerAddon;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXDatePicker
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXDatePicker.class.getName());
    public static final String uiClassID = "DatePickerUI";
    public static final String EDITOR = "editor";
    public static final String MONTH_VIEW = "monthView";
    public static final String LINK_PANEL = "linkPanel";
    public static final String COMMIT_KEY = "datePickerCommit";
    public static final String CANCEL_KEY = "datePickerCancel";
    public static final String HOME_NAVIGATE_KEY = "navigateHome";
    public static final String HOME_COMMIT_KEY = "commitHome";
    private static final DateFormat[] EMPTY_DATE_FORMATS;
    private JFormattedTextField _dateField;
    private JPanel _linkPanel;
    private MessageFormat _linkFormat;
    private Date linkDate;
    private JXMonthView _monthView;
    private boolean editable = true;
    private EventListenerMap listenerMap;
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    private Date date;
    private PropertyChangeListener monthViewListener;

    public JXDatePicker() {
        this(null, null);
    }

    public JXDatePicker(Date selected) {
        this(selected, null);
    }

    public JXDatePicker(Locale locale) {
        this(null, locale);
    }

    public JXDatePicker(Date selection, Locale locale) {
        this.init();
        if (locale != null) {
            this.setLocale(locale);
        }
        this.updateUI();
        this.setDate(selection);
    }

    public void setDate(Date date) {
        try {
            date = this.getUI().getSelectableDate(date);
        }
        catch (PropertyVetoException e) {
            return;
        }
        Date old = this.getDate();
        this.date = date;
        this.firePropertyChange("date", old, this.getDate());
    }

    public Date getDate() {
        return this.date;
    }

    private void init() {
        this.listenerMap = new EventListenerMap();
        this.initMonthView();
        this.updateLinkFormat();
        this.linkDate = this._monthView.getToday();
        this._linkPanel = new TodayPanel();
    }

    private void initMonthView() {
        this._monthView = new JXMonthView();
        this._monthView.setTraversable(true);
        this._monthView.addPropertyChangeListener(this.getMonthViewListener());
    }

    private PropertyChangeListener getMonthViewListener() {
        if (this.monthViewListener == null) {
            this.monthViewListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("timeZone".equals(evt.getPropertyName())) {
                        JXDatePicker.this.updateTimeZone((TimeZone)evt.getOldValue(), (TimeZone)evt.getNewValue());
                    }
                }
            };
        }
        return this.monthViewListener;
    }

    protected void updateTimeZone(TimeZone oldValue, TimeZone newValue) {
        this.firePropertyChange("timeZone", oldValue, newValue);
    }

    @Override
    public DatePickerUI getUI() {
        return (DatePickerUI)this.ui;
    }

    public void setUI(DatePickerUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((DatePickerUI)LookAndFeelAddons.getUI(this, DatePickerUI.class));
        SwingUtilities.updateComponentTreeUI(this.getMonthView());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setFormats(String ... formats) {
        DateFormat[] dateFormats = null;
        if (formats != null) {
            Contract.asNotNull(formats, "the array of format strings must not must not contain null elements");
            dateFormats = new DateFormat[formats.length];
            for (int counter = formats.length - 1; counter >= 0; --counter) {
                dateFormats[counter] = new SimpleDateFormat(formats[counter], this.getLocale());
            }
        }
        this.setFormats(dateFormats);
    }

    public void setFormats(DateFormat ... formats) {
        if (formats != null) {
            Contract.asNotNull(formats, "the array of formats must not contain null elements");
        }
        DateFormat[] old = this.getFormats();
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new DatePickerFormatter(formats, this.getLocale())));
        this.firePropertyChange("formats", old, this.getFormats());
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory = this._dateField.getFormatterFactory();
        if (factory != null && (formatter = factory.getFormatter(this._dateField)) instanceof DatePickerFormatter) {
            return ((DatePickerFormatter)formatter).getFormats();
        }
        return EMPTY_DATE_FORMATS;
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView monthView) {
        Contract.asNotNull(monthView, "monthView must not be null");
        JXMonthView oldMonthView = this.getMonthView();
        TimeZone oldTZ = this.getTimeZone();
        oldMonthView.removePropertyChangeListener(this.getMonthViewListener());
        this._monthView = monthView;
        this.getMonthView().addPropertyChangeListener(this.getMonthViewListener());
        this.firePropertyChange(MONTH_VIEW, oldMonthView, this.getMonthView());
        this.firePropertyChange("timeZone", oldTZ, this.getTimeZone());
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this._monthView.setTimeZone(tz);
    }

    public Date getLinkDay() {
        return this.linkDate;
    }

    public void setLinkDay(Date linkDay, String linkFormatString) {
        this.setLinkFormat(new MessageFormat(linkFormatString));
        this.setLinkDay(linkDay);
    }

    public void setLinkDay(Date linkDay) {
        Format[] formats;
        this.linkDate = linkDay;
        for (Format format : formats = this.getLinkFormat().getFormatsByArgumentIndex()) {
            if (!(format instanceof DateFormat)) continue;
            ((DateFormat)format).setTimeZone(this.getTimeZone());
        }
        this.setLinkPanel(new TodayPanel());
    }

    protected void setLinkFormat(MessageFormat _linkFormat) {
        this._linkFormat = _linkFormat;
    }

    protected MessageFormat getLinkFormat() {
        return this._linkFormat;
    }

    private void updateLinkFormat() {
        String linkFormat = UIManagerExt.getString("JXDatePicker.linkFormat", this.getLocale());
        if (linkFormat != null) {
            this.setLinkFormat(new MessageFormat(linkFormat));
        } else {
            this.setLinkFormat(new MessageFormat("{0,date, dd MMMM yyyy}"));
        }
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel linkPanel) {
        JPanel oldLinkPanel = this._linkPanel;
        this._linkPanel = linkPanel;
        this.firePropertyChange(LINK_PANEL, oldLinkPanel, this._linkPanel);
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public void setEditor(JFormattedTextField editor) {
        Contract.asNotNull(editor, "editor must not be null");
        JFormattedTextField oldEditor = this._dateField;
        this._dateField = editor;
        this.firePropertyChange(EDITOR, oldEditor, this._dateField);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation orientation) {
        super.setComponentOrientation(orientation);
        this._monthView.setComponentOrientation(orientation);
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
        this.fireActionPerformed(COMMIT_KEY);
    }

    public void cancelEdit() {
        this._dateField.setValue(this._dateField.getValue());
        this.fireActionPerformed(CANCEL_KEY);
    }

    public void setEditable(boolean value) {
        boolean oldEditable = this.isEditable();
        this.editable = value;
        this.firePropertyChange("editable", oldEditable, this.editable);
        if (this.editable != oldEditable) {
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public Font getFont() {
        return this.getEditor().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getEditor().setFont(font);
    }

    public void setLightWeightPopupEnabled(boolean aFlag) {
        boolean oldFlag = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = aFlag;
        this.firePropertyChange("lightWeightPopupEnabled", oldFlag, this.lightWeightPopupEnabled);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    @Override
    public int getBaseline(int width, int height) {
        return ((DatePickerUI)this.ui).getBaseline(width, height);
    }

    public void addActionListener(ActionListener l) {
        this.listenerMap.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerMap.remove(ActionListener.class, l);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result;
        List<EventListener> listeners = this.listenerMap.getListeners(listenerType);
        if (!listeners.isEmpty()) {
            result = (EventListener[])Array.newInstance(listenerType, listeners.size());
            result = listeners.toArray(result);
        } else {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    protected void fireActionPerformed(String actionCommand) {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (ActionListener listener : listeners) {
            if (e == null) {
                e = new ActionEvent(this, 1001, actionCommand);
            }
            listener.actionPerformed(e);
        }
    }

    static {
        LookAndFeelAddons.contribute(new DatePickerAddon());
        EMPTY_DATE_FORMATS = new DateFormat[0];
    }

    private final class TodayPanel
    extends JXPanel {
        private TodayAction todayAction;
        private JXHyperlink todayLink;

        TodayPanel() {
            super(new FlowLayout());
            this.setBackgroundPainter(new MattePainter(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE)));
            this.todayAction = new TodayAction();
            this.todayLink = new JXHyperlink(this.todayAction);
            this.todayLink.addMouseListener(this.createDoubleClickListener());
            Color textColor = new Color(16, 66, 104);
            this.todayLink.setUnclickedColor(textColor);
            this.todayLink.setClickedColor(textColor);
            this.add(this.todayLink);
        }

        private MouseListener createDoubleClickListener() {
            MouseAdapter adapter = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    ((TodayPanel)TodayPanel.this).todayAction.select = true;
                }
            };
            return adapter;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(187, 187, 187));
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(new Color(221, 221, 221));
            g.drawLine(0, 1, this.getWidth(), 1);
        }

        public void setLocale(Locale l) {
            super.setLocale(l);
            JXDatePicker.this.updateLinkFormat();
            this.todayLink.setText(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
        }

        private final class TodayAction
        extends AbstractAction {
            boolean select;

            TodayAction() {
                super(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
                Calendar cal = JXDatePicker.this._monthView.getCalendar();
                cal.setTime(JXDatePicker.this.getLinkDay());
                this.putValue("Name", JXDatePicker.this.getLinkFormat().format(new Object[]{cal.getTime()}));
            }

            public void actionPerformed(ActionEvent ae) {
                String key = this.select ? JXDatePicker.HOME_COMMIT_KEY : JXDatePicker.HOME_NAVIGATE_KEY;
                this.select = false;
                Action delegate = TodayPanel.this.getActionMap().get(key);
                if (delegate != null && delegate.isEnabled()) {
                    delegate.actionPerformed(null);
                }
            }
        }
    }
}

