/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.io.Serializable;

public class ExtendedStackTraceElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4907919529165316605L;
    public static final int UNKNOWN_SOURCE = -1;
    public static final int NATIVE_METHOD = -2;
    public static final String NATIVE_METHOD_STRING = "Native Method";
    public static final String UNKNOWN_SOURCE_STRING = "Unknown Source";
    private String className;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private String codeLocation;
    private String version;
    private boolean exact;
    private static final String AT_PREFIX = "\tat ";

    public ExtendedStackTraceElement() {
        this.lineNumber = -1;
    }

    public ExtendedStackTraceElement(StackTraceElement ste) {
        this(ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber());
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber) {
        this(className, methodName, fileName, lineNumber, null, null, false);
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber, String codeLocation, String version, boolean exact) {
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.codeLocation = codeLocation;
        this.version = version;
        this.exact = exact;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public void setCodeLocation(String codeLocation) {
        this.codeLocation = codeLocation;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedStackTraceElement that = (ExtendedStackTraceElement)o;
        if (this.exact != that.exact) {
            return false;
        }
        if (this.lineNumber != that.lineNumber) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.codeLocation != null ? !this.codeLocation.equals(that.codeLocation) : that.codeLocation != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.codeLocation != null ? this.codeLocation.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.exact ? 1 : 0);
        return result;
    }

    public StackTraceElement getStackTraceElement() {
        return new StackTraceElement(this.className, this.methodName, this.fileName, this.lineNumber);
    }

    public ExtendedStackTraceElement clone() throws CloneNotSupportedException {
        return (ExtendedStackTraceElement)super.clone();
    }

    public String toString() {
        return this.toString(false);
    }

    public String getExtendedString() {
        if (this.codeLocation != null || this.version != null) {
            StringBuilder result = new StringBuilder();
            if (this.exact) {
                result.append("[");
            } else {
                result.append("~[");
            }
            if (this.codeLocation != null) {
                result.append(this.codeLocation);
            }
            result.append(":");
            if (this.version != null) {
                result.append(this.version);
            }
            result.append("]");
            return result.toString();
        }
        return null;
    }

    public String toString(boolean extended) {
        String extendedStr;
        StringBuilder result = new StringBuilder();
        result.append(this.className).append(".").append(this.methodName);
        if (this.isNativeMethod()) {
            result.append("(Native Method)");
        }
        if (this.fileName != null) {
            result.append("(").append(this.fileName);
            if (this.lineNumber >= 0) {
                result.append(":").append(this.lineNumber);
            }
            result.append(")");
        } else {
            result.append("(Unknown Source)");
        }
        if (extended && (extendedStr = this.getExtendedString()) != null) {
            result.append(" ").append(extendedStr);
        }
        return result.toString();
    }

    public static ExtendedStackTraceElement parseStackTraceElement(String ste) {
        int idx;
        if (ste == null) {
            return null;
        }
        if (ste.startsWith(AT_PREFIX)) {
            ste = ste.substring(AT_PREFIX.length());
        }
        if ((idx = ste.lastIndexOf("(")) < 0) {
            return null;
        }
        int endIdx = ste.lastIndexOf(")");
        if (endIdx < 0) {
            return null;
        }
        String classAndMethod = ste.substring(0, idx);
        String source = ste.substring(idx + 1, endIdx);
        String remainder = ste.substring(endIdx + 1);
        idx = classAndMethod.lastIndexOf(".");
        String clazz = classAndMethod.substring(0, idx);
        String method = classAndMethod.substring(idx + 1, classAndMethod.length());
        idx = source.lastIndexOf(":");
        String file = null;
        int lineNumber = -1;
        if (idx != -1) {
            file = source.substring(0, idx);
            lineNumber = Integer.parseInt(source.substring(idx + 1, source.length()));
        } else if (source.equals(NATIVE_METHOD_STRING)) {
            lineNumber = -2;
        } else if (!source.equals(UNKNOWN_SOURCE_STRING)) {
            file = source;
        }
        int vEndIdx = remainder.lastIndexOf("]");
        if (vEndIdx >= 0) {
            int colonIdx;
            boolean exact = false;
            String versionStr = null;
            if (remainder.startsWith(" [")) {
                exact = true;
                versionStr = remainder.substring(2, vEndIdx);
            } else if (remainder.startsWith(" ~[")) {
                exact = false;
                versionStr = remainder.substring(3, vEndIdx);
            }
            if (versionStr != null && (colonIdx = versionStr.indexOf(":")) > -1) {
                String codeLocation = versionStr.substring(0, colonIdx);
                String version = versionStr.substring(colonIdx + 1);
                if ("".equals(codeLocation) || "na".equals(codeLocation)) {
                    codeLocation = null;
                }
                if ("".equals(version) || "na".equals(version)) {
                    version = null;
                }
                return new ExtendedStackTraceElement(clazz, method, file, lineNumber, codeLocation, version, exact);
            }
        }
        return new ExtendedStackTraceElement(clazz, method, file, lineNumber);
    }
}

