/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.producer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.impl.eventproducer.AbstractEventProducer;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLogbackStreamEventProducer<T extends Serializable>
extends AbstractEventProducer<T> {
    final Logger logger = LoggerFactory.getLogger(AbstractLogbackStreamEventProducer.class);
    private ObjectInputStream dataInput;

    public AbstractLogbackStreamEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<T>> eventQueue, InputStream inputStream) throws IOException {
        super(sourceIdentifier, eventQueue);
        this.dataInput = new ObjectInputStream(new BufferedInputStream(inputStream));
    }

    public void start() {
        Thread t = new Thread((Runnable)new ReceiverRunnable(), "" + this.getSourceIdentifier() + "-Receiver");
        t.setDaemon(false);
        t.start();
    }

    protected abstract T postprocessEvent(Object var1);

    public void close() {
        IOUtils.closeQuietly((InputStream)this.dataInput);
    }

    private class ReceiverRunnable
    implements Runnable {
        private ReceiverRunnable() {
        }

        public void run() {
            try {
                while (true) {
                    Object object = AbstractLogbackStreamEventProducer.this.dataInput.readObject();
                    Object event = AbstractLogbackStreamEventProducer.this.postprocessEvent(object);
                    if (object == null) {
                        if (!AbstractLogbackStreamEventProducer.this.logger.isInfoEnabled()) continue;
                        AbstractLogbackStreamEventProducer.this.logger.info("Retrieved null!");
                        continue;
                    }
                    AbstractLogbackStreamEventProducer.this.addEvent(event);
                }
            }
            catch (Throwable e) {
                if (AbstractLogbackStreamEventProducer.this.logger.isInfoEnabled()) {
                    AbstractLogbackStreamEventProducer.this.logger.info("Exception ({}: '{}') while reading events. Adding eventWrapper with empty event and stopping...", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
                AbstractLogbackStreamEventProducer.this.addEvent(null);
                return;
            }
        }
    }
}

