/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentTableColumnModel
extends DefaultTableColumnModel {
    protected List<TableColumn> allTableColumns = new ArrayList<TableColumn>();

    public PersistentTableColumnModel() {
        this.initColumns();
    }

    protected void initColumns() {
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            for (int invisibleIndex = 0; invisibleIndex < noInvisibleColumns; ++invisibleIndex) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn != visibleColumn) continue;
                ++visibleIndex;
            }
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.allTableColumns.size();
        for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
            TableColumn invisibleColumn;
            TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(columnIndex) : null;
            if (visibleColumn == (invisibleColumn = this.allTableColumns.get(columnIndex))) continue;
            super.addColumn(invisibleColumn);
            super.moveColumn(this.tableColumns.size() - 1, columnIndex);
        }
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn column) {
        this.allTableColumns.add(column);
        super.addColumn(column);
    }

    @Override
    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.remove(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    @Override
    public void moveColumn(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        TableColumn fromColumn = (TableColumn)this.tableColumns.get(oldIndex);
        TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (oldIndex != newIndex) {
            this.allTableColumns.remove(allColumnsOldIndex);
            this.allTableColumns.add(allColumnsNewIndex, fromColumn);
        }
        super.moveColumn(oldIndex, newIndex);
    }

    public int getColumnCount(boolean onlyVisible) {
        return onlyVisible ? this.tableColumns.size() : this.allTableColumns.size();
    }

    public Iterator<TableColumn> getColumns(boolean onlyVisible) {
        return onlyVisible ? this.tableColumns.iterator() : this.allTableColumns.iterator();
    }

    public int getColumnIndex(Object identifier, boolean onlyVisible) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        List<Object> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        int noColumns = columns.size();
        for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
            TableColumn column = (TableColumn)columns.get(columnIndex);
            if (!identifier.equals(column.getIdentifier())) continue;
            return columnIndex;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public List<TableColumnLayoutInfo> getColumnLayoutInfos() {
        ArrayList<TableColumnLayoutInfo> tableColumnLayoutInfos = new ArrayList<TableColumnLayoutInfo>(this.allTableColumns.size());
        for (TableColumn current : this.allTableColumns) {
            boolean visible = this.tableColumns.contains(current);
            TableColumnLayoutInfo tableColumnLayoutInfo = new TableColumnLayoutInfo(current.getIdentifier().toString(), current.getWidth(), visible);
            tableColumnLayoutInfos.add(tableColumnLayoutInfo);
        }
        return tableColumnLayoutInfos;
    }

    public static class TableColumnLayoutInfo
    implements Serializable {
        private String columnName;
        private int width;
        private boolean visible;

        public TableColumnLayoutInfo() {
        }

        public TableColumnLayoutInfo(String columnName, int width, boolean visible) {
            this.columnName = columnName;
            this.width = width;
            this.visible = visible;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public String toString() {
            return "TableColumnLayoutInfo[columnName=" + this.columnName + ", width=" + this.width + ", visible=" + this.visible + "]";
        }
    }
}

