/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class ListComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 4914401784245069859L;
    private final List store;
    private Object selectedItem;

    public ListComboBoxModel() {
        this.store = new ArrayList();
    }

    public ListComboBoxModel(List store) {
        this.store = new ArrayList(store);
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.store.size()) {
            return this.store.get(index);
        }
        return null;
    }

    public int getSize() {
        return this.store.size();
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object anObject) {
        if (this.selectedItem != null && !this.selectedItem.equals(anObject) || this.selectedItem == null && anObject != null) {
            this.selectedItem = anObject;
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public void addElement(Object anObject) {
        this.store.add(anObject);
        this.fireIntervalAdded(this, this.store.size() - 1, this.store.size() - 1);
        if (this.store.size() == 1 && this.selectedItem == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.store.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.store.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(Object anObject) {
        int index = this.store.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.store.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.store.size() - 1;
            this.store.clear();
            this.selectedItem = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedItem = null;
        }
    }

    public void replace(List list) {
        int index;
        int firstIndex = 0;
        int lastIndex = this.store.size() - 1;
        this.store.clear();
        this.store.addAll(list);
        int newLastIndex = this.store.size() - 1;
        if (lastIndex < newLastIndex) {
            this.fireContentsChanged(this, firstIndex, lastIndex);
            this.fireIntervalAdded(this, lastIndex + 1, newLastIndex);
        } else if (lastIndex > newLastIndex) {
            this.fireContentsChanged(this, firstIndex, newLastIndex);
            this.fireIntervalRemoved(this, newLastIndex + 1, lastIndex);
        } else {
            this.fireContentsChanged(this, firstIndex, newLastIndex);
        }
        if (this.selectedItem != null && (index = this.store.indexOf(this.selectedItem)) < 0) {
            this.selectedItem = null;
        }
        if (this.selectedItem == null && this.store.size() > 0) {
            this.setSelectedItem(this.store.get(0));
        }
    }

    public void replace(Object[] values) {
        if (values == null) {
            return;
        }
        this.replace(Arrays.asList(values));
    }
}

