/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.taskmanager.table;

import de.huxhorn.sulky.swing.RowBasedTableModel;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTableModel<T>
implements RowBasedTableModel<Task<T>> {
    private final Logger logger = LoggerFactory.getLogger(TaskTableModel.class);
    private final List<Task<T>> tasks;
    private final EventListenerList eventListenerList;
    private Comparator<Task<T>> taskComparator = new Comparator<Task<T>>(){

        @Override
        public int compare(Task<T> task1, Task<T> task2) {
            return (int)(task1.getId() - task2.getId());
        }
    };
    public static final int ID_INDEX = 0;
    public static final int NAME_INDEX = 1;
    public static final int PROGRESS_INDEX = 2;
    private static final Class[] COLUMN_CLASSES = new Class[]{Long.class, String.class, Integer.class};
    private static final String[] COLUMN_NAMES = new String[]{"ID", "Name", "Progress"};
    private TaskManager<T> taskManager;
    private boolean paused = true;
    private TaskListener<T> taskListener;

    public TaskTableModel(TaskManager<T> taskManager) {
        this.tasks = new ArrayList<Task<T>>();
        this.eventListenerList = new EventListenerList();
        this.taskListener = new UpdateViewTaskListener();
        this.setTaskManager(taskManager);
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < COLUMN_CLASSES.length) {
            return COLUMN_CLASSES[columnIndex];
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Task<T> task = this.getValueAt(rowIndex);
        if (task == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return task.getId();
            }
            case 1: {
                return task.getName();
            }
            case 2: {
                return task.getProgress();
            }
        }
        return null;
    }

    public void setValueAt(Object o, int rowIndex, int columnIndex) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.add(TableModelListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.remove(TableModelListener.class, l);
        }
    }

    public int getRowCount() {
        return this.tasks.size();
    }

    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < COLUMN_NAMES.length) {
            return COLUMN_NAMES[columnIndex];
        }
        return null;
    }

    public Task<T> getValueAt(int row) {
        this.logger.debug("getValueAt {}", row);
        if (row >= 0 && row < this.tasks.size()) {
            Task<T> result = this.tasks.get(row);
            this.logger.debug("getValueAt {} result={}", result);
            return result;
        }
        this.logger.debug("getValueAt {} is null!", row);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChanged(TableModelEvent event) {
        Object[] listeners;
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            listeners = this.eventListenerList.getListenerList();
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            TableModelListener listener = (TableModelListener)listeners[i + 1];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Firing TableChange at {}.", (Object)listener.getClass().getName());
            }
            try {
                listener.tableChanged(event);
                continue;
            }
            catch (Throwable ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Exception while firing change!", ex);
            }
        }
    }

    private void initTasks() {
        this.tasks.clear();
        if (this.taskManager != null) {
            Map taskMap = this.taskManager.getTasks();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("initTasks: {}", taskMap);
            }
            for (Map.Entry current : taskMap.entrySet()) {
                this.tasks.add((Task<T>)current.getValue());
                Collections.sort(this.tasks, this.taskComparator);
            }
        }
        this.fireTableChanged(new TableModelEvent((TableModel)((Object)this)));
    }

    private void clearTasks() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("clearTasks");
        }
        this.tasks.clear();
        this.fireTableChanged(new TableModelEvent((TableModel)((Object)this)));
    }

    private void addTask(Task<T> task) {
        this.tasks.add(task);
        int index = this.tasks.size() - 1;
        this.fireTableChanged(new TableModelEvent((TableModel)((Object)this), index, index, -1, 1));
    }

    private void removeTask(Task<T> task) {
        int index = this.tasks.indexOf(task);
        this.tasks.remove(index);
        this.fireTableChanged(new TableModelEvent((TableModel)((Object)this), index, index, -1, -1));
    }

    private void updateTask(Task<T> task) {
        int index = this.tasks.indexOf(task);
        this.fireTableChanged(new TableModelEvent((TableModel)((Object)this), index, index, -1, 0));
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        if (this.paused != paused) {
            if (!paused) {
                this.initTasks();
            } else {
                this.clearTasks();
            }
            this.paused = paused;
        }
    }

    public TaskManager<?> getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(TaskManager<T> taskManager) {
        if (this.taskManager != null) {
            this.taskManager.removeTaskListener(this.taskListener);
        }
        this.taskManager = taskManager;
        if (this.taskManager != null) {
            this.taskManager.addTaskListener(this.taskListener);
        }
        if (!this.paused) {
            this.initTasks();
        } else {
            this.clearTasks();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateViewTaskListener
    implements TaskListener<T> {
        private UpdateViewTaskListener() {
        }

        public void taskCreated(Task<T> task) {
            if (!TaskTableModel.this.paused) {
                TaskTableModel.this.addTask(task);
            }
        }

        public void executionFailed(Task<T> task, ExecutionException exception) {
            if (!TaskTableModel.this.paused) {
                TaskTableModel.this.removeTask(task);
            }
        }

        public void executionFinished(Task<T> task, T result) {
            if (!TaskTableModel.this.paused) {
                TaskTableModel.this.removeTask(task);
            }
        }

        public void executionCanceled(Task<T> task) {
            if (!TaskTableModel.this.paused) {
                TaskTableModel.this.removeTask(task);
            }
        }

        public void progressUpdated(Task<T> task, int progress) {
            if (!TaskTableModel.this.paused) {
                TaskTableModel.this.updateTask(task);
            }
        }
    }
}

