/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.taskmanager.table;

import de.huxhorn.lilith.swing.taskmanager.table.TaskTableColumnModel;
import de.huxhorn.lilith.swing.taskmanager.table.TaskTableModel;
import de.huxhorn.sulky.swing.Tables;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTable<T>
extends JTable {
    private final Logger logger = LoggerFactory.getLogger(TaskTable.class);
    private TaskTableModel<T> taskTableModel;

    public TaskTable(TaskManager<T> taskManager) {
        this.taskTableModel = new TaskTableModel<T>(taskManager);
        this.taskTableModel.addTableModelListener(new SelectFirstListener());
        this.setModel((TableModel)((Object)this.taskTableModel));
        this.setColumnModel(new TaskTableColumnModel());
        this.setSelectionMode(0);
        Tables.setAutoCreateRowSorter((JTable)this, (boolean)true);
    }

    public void setPaused(boolean paused) {
        this.taskTableModel.setPaused(paused);
        if (!paused) {
            this.selectFirstTask();
        }
    }

    private void selectFirstTask() {
        if (this.getSelectedRow() < 0 && this.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    public boolean isPaused() {
        return this.taskTableModel.isPaused();
    }

    public TaskTableModel<T> getTaskTableModel() {
        return this.taskTableModel;
    }

    public Task<T> getTaskAt(Point p, boolean select) {
        int row = this.rowAtPoint(p);
        if (row > -1) {
            Task<T> result = this.taskTableModel.getValueAt(row = Tables.convertRowIndexToModel((JTable)this, (int)row));
            if (result != null && select) {
                this.selectRow(row);
            }
            return result;
        }
        return null;
    }

    public void selectRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting row {}.", row);
            }
            this.getSelectionModel().setSelectionInterval(0, row);
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Task<T> task = this.getTaskAt(event.getPoint(), false);
        if (task != null) {
            Map metaData;
            StringBuilder result = new StringBuilder();
            result.append("<HTML><BODY>");
            result.append("<P>").append(task.getName()).append(" (ID=").append(task.getId()).append(")</P>");
            String description = task.getDescription();
            if (description != null) {
                result.append("<P>").append(description).append("</P>");
            }
            if ((metaData = task.getMetaData()) != null && metaData.size() > 0) {
                result.append("<TABLE border=\"1\">");
                result.append("<TR><TH>Key</TH><TH>Value</TH></TR>");
                for (Map.Entry current : metaData.entrySet()) {
                    result.append("<TR>");
                    result.append("<TD>");
                    result.append((String)current.getKey());
                    result.append("</TD>");
                    result.append("<TD>");
                    result.append((String)current.getValue());
                    result.append("</TD>");
                    result.append("</TR>");
                }
                result.append("</TABLE>");
            }
            result.append("</BODY></HTML>");
            return result.toString();
        }
        return null;
    }

    private class SelectFirstListener
    implements TableModelListener {
        private SelectFirstListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            TaskTable.this.selectFirstTask();
        }
    }
}

