/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.taskmanager;

import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.taskmanager.TaskManagerPanel;
import java.awt.GridLayout;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerInternalFrame
extends JInternalFrame {
    private final Logger logger = LoggerFactory.getLogger(TaskManagerInternalFrame.class);
    private MainFrame mainFrame;

    public TaskManagerInternalFrame(MainFrame mainFrame) {
        super("Task Manager", true, true, true, true);
        this.mainFrame = mainFrame;
        TaskManagerPanel<Long> taskManagerPanel = new TaskManagerPanel<Long>(mainFrame.getLongWorkManager());
        this.setLayout(new GridLayout(1, 1));
        this.add(taskManagerPanel);
        taskManagerPanel.setPaused(false);
        this.addInternalFrameListener(new CleanupWindowChangeListener());
    }

    class CleanupWindowChangeListener
    implements InternalFrameListener {
        CleanupWindowChangeListener() {
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameClosing {}", e.getInternalFrame());
            }
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameClosed {}", e.getInternalFrame());
            }
            TaskManagerInternalFrame.this.mainFrame.updateWindowMenus();
        }

        public void internalFrameOpened(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameOpened {}", e.getInternalFrame());
            }
        }

        public void internalFrameIconified(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameIconified {}", e.getInternalFrame());
            }
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameDeiconified {}", e.getInternalFrame());
            }
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameActivated {}", e.getInternalFrame());
            }
            TaskManagerInternalFrame.this.mainFrame.getViewActions().setViewContainer(null);
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            if (TaskManagerInternalFrame.this.logger.isDebugEnabled()) {
                TaskManagerInternalFrame.this.logger.debug("internalFrameDeactivated {}", e.getInternalFrame());
            }
        }
    }
}

