/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.EditSourceNameDialog;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.SourceNameTableModel;
import de.huxhorn.sulky.swing.Tables;
import de.huxhorn.sulky.swing.Windows;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcesPanel
extends JPanel {
    final Logger logger = LoggerFactory.getLogger(SourcesPanel.class);
    private JTable sourceNameTable;
    private SourceNameTableModel sourceNameTableModel;
    private EditSourceNameAction editSourceNameAction;
    private RemoveSourceNameAction removeSourceNameAction;
    private EditSourceNameDialog editSourceNameDialog;
    private PreferencesDialog preferencesDialog;

    public SourcesPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.editSourceNameDialog = new EditSourceNameDialog(this.preferencesDialog);
        HashMap<String, String> sourceNames = new HashMap<String, String>();
        this.sourceNameTableModel = new SourceNameTableModel(sourceNames);
        this.sourceNameTable = new JTable(this.sourceNameTableModel);
        Tables.setAutoCreateRowSorter((JTable)this.sourceNameTable, (boolean)true);
        this.sourceNameTable.addMouseListener(new SourceNameTableMouseListener());
        JScrollPane sourceNameTableScrollPane = new JScrollPane(this.sourceNameTable);
        JPanel sourceNamesPanel = new JPanel(new GridLayout(1, 1));
        sourceNamesPanel.add((Component)sourceNameTableScrollPane, "Center");
        JToolBar sourceNamesToolbar = new JToolBar();
        sourceNamesToolbar.setFloatable(false);
        ListSelectionModel sourceNameRowSelectionModel = this.sourceNameTable.getSelectionModel();
        sourceNameRowSelectionModel.setSelectionMode(0);
        sourceNameRowSelectionModel.addListSelectionListener(new SourceNameTableRowSelectionListener());
        AddSourceNameAction addSourceNameAction = new AddSourceNameAction();
        this.editSourceNameAction = new EditSourceNameAction();
        this.removeSourceNameAction = new RemoveSourceNameAction();
        JButton addSourceNameButton = new JButton(addSourceNameAction);
        JButton editSourceNameButton = new JButton(this.editSourceNameAction);
        JButton removeSourceNameButton = new JButton(this.removeSourceNameAction);
        sourceNamesToolbar.add(addSourceNameButton);
        sourceNamesToolbar.add(editSourceNameButton);
        sourceNamesToolbar.add(removeSourceNameButton);
        this.add((Component)sourceNamesToolbar, "North");
        this.add((Component)sourceNamesPanel, "Center");
    }

    public void initUI() {
        Map<String, String> sourceNames = this.preferencesDialog.getSourceNames();
        this.sourceNameTableModel.setData(sourceNames);
        this.updateSourceNames();
    }

    public void updateSourceNames() {
        int selectedRow = this.sourceNameTable.getSelectedRow();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("selectedRow={}", selectedRow);
        }
        this.editSourceNameAction.setEnabled(selectedRow != -1);
        this.removeSourceNameAction.setEnabled(selectedRow != -1);
    }

    public void editSourceName(String sourceIdentifier) {
        Map<String, String> data = this.sourceNameTableModel.getData();
        if (data.containsKey(sourceIdentifier)) {
            this.editSourceName(sourceIdentifier, false);
        } else {
            this.editSourceName(sourceIdentifier, true);
        }
    }

    public void editSourceName(String sourceIdentifier, boolean add) {
        Map<String, String> data = this.sourceNameTableModel.getData();
        String sourceName = data.get(sourceIdentifier);
        if (sourceName == null) {
            sourceName = "";
        }
        this.editSourceNameDialog.setSourceIdentifier(sourceIdentifier);
        this.editSourceNameDialog.setSourceName(sourceName);
        this.editSourceNameDialog.setAdding(add);
        Windows.showWindow((Window)this.editSourceNameDialog, (Window)this.preferencesDialog, (boolean)true);
        if (!this.editSourceNameDialog.isCanceled()) {
            String newIdentifier = this.editSourceNameDialog.getSourceIdentifier();
            newIdentifier = newIdentifier.trim();
            sourceName = this.editSourceNameDialog.getSourceName();
            sourceName = sourceName.trim();
            this.preferencesDialog.setSourceName(sourceIdentifier, newIdentifier, sourceName);
        }
    }

    private int convertSourceNameRow(int row) {
        return Tables.convertRowIndexToModel((JTable)this.sourceNameTable, (int)row);
    }

    private class SourceNameTableMouseListener
    implements MouseListener {
        private final Logger logger = LoggerFactory.getLogger(SourceNameTableMouseListener.class);

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() >= 2 && evt.getButton() == 1) {
                Point p = evt.getPoint();
                int row = SourcesPanel.this.sourceNameTable.rowAtPoint(p);
                row = SourcesPanel.this.convertSourceNameRow(row);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Source-Name-Row: {}", row);
                }
                if (row >= 0) {
                    String source = (String)SourcesPanel.this.sourceNameTableModel.getValueAt(row, 0);
                    if (source == null) {
                        source = "";
                    }
                    SourcesPanel.this.editSourceName(source, false);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("After show...");
                    }
                }
            } else if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        private void showPopup(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class RemoveSourceNameAction
    extends AbstractAction {
        public RemoveSourceNameAction() {
            super("Remove");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-remove.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Remove the selected Source Name.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (SourcesPanel.this.logger.isDebugEnabled()) {
                SourcesPanel.this.logger.debug("Remove");
            }
            if ((row = SourcesPanel.this.sourceNameTable.getSelectedRow()) >= 0) {
                row = SourcesPanel.this.convertSourceNameRow(row);
                SourcesPanel.this.sourceNameTableModel.setValueAt("", row, 0);
            }
        }
    }

    private class EditSourceNameAction
    extends AbstractAction {
        public EditSourceNameAction() {
            super("Edit");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Edit a Source Name.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (SourcesPanel.this.logger.isDebugEnabled()) {
                SourcesPanel.this.logger.debug("Edit");
            }
            if ((row = SourcesPanel.this.sourceNameTable.getSelectedRow()) >= 0) {
                row = SourcesPanel.this.convertSourceNameRow(row);
                String sourceIdentifier = (String)SourcesPanel.this.sourceNameTableModel.getValueAt(row, 0);
                SourcesPanel.this.editSourceName(sourceIdentifier, false);
            }
        }
    }

    private class AddSourceNameAction
    extends AbstractAction {
        public AddSourceNameAction() {
            super("Add");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Add a new Source Name.");
        }

        public void actionPerformed(ActionEvent e) {
            if (SourcesPanel.this.logger.isDebugEnabled()) {
                SourcesPanel.this.logger.debug("Add");
            }
            SourcesPanel.this.editSourceName("", true);
        }
    }

    private class SourceNameTableRowSelectionListener
    implements ListSelectionListener {
        private SourceNameTableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SourcesPanel.this.updateSourceNames();
        }
    }
}

