/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.linklistener;

import de.huxhorn.lilith.swing.MainFrame;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.LinkListener;

public class OpenUrlLinkListener
extends LinkListener {
    private final Logger logger = LoggerFactory.getLogger(OpenUrlLinkListener.class);
    public static final String STACK_TRACE_ELEMENT_URI_PREFIX = "ste://";
    public static final String HELP_URI_PREFIX = "help://";
    public static final String PREFS_URI_PREFIX = "prefs://";
    private MainFrame mainFrame;
    private LinkListener originalLinkListener;

    public OpenUrlLinkListener(MainFrame mainFrame, LinkListener originalLinkListener) {
        this.mainFrame = mainFrame;
        this.originalLinkListener = originalLinkListener;
    }

    public void linkClicked(BasicPanel basicPanel, String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Link clicked: {}", (Object)uri);
        }
        if (uri.startsWith(HELP_URI_PREFIX)) {
            this.mainFrame.openHelp(uri.substring(HELP_URI_PREFIX.length()));
        } else if (uri.startsWith(PREFS_URI_PREFIX)) {
            this.mainFrame.openPreferences(uri.substring(PREFS_URI_PREFIX.length()));
        } else if (uri.contains("://")) {
            try {
                this.mainFrame.openUrl(new URL(uri));
            }
            catch (MalformedURLException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't create URL for uri-string " + uri + "!", e);
                }
            }
        } else if (this.originalLinkListener != null) {
            this.originalLinkListener.linkClicked(basicPanel, uri);
        }
    }
}

