/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanObsoleteCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(CleanObsoleteCallable.class);
    private File parentDirectory;

    public CleanObsoleteCallable(File parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public Long call() throws Exception {
        Long result = 0L;
        if (this.parentDirectory.isDirectory()) {
            this.setNumberOfSteps(1L);
            result = 1L;
            FileUtils.deleteDirectory((File)this.parentDirectory);
            if (this.logger.isInfoEnabled()) {
                boolean deleted;
                boolean bl = deleted = !this.parentDirectory.exists();
                if (deleted) {
                    this.logger.info("Deleted obsolete directory '{}'.", this.parentDirectory);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Failed to delete obsolete directory '{}'!", this.parentDirectory);
                }
            }
            this.setCurrentStep(1L);
        }
        return result;
    }
}

