/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContainerFrame
extends JFrame
implements ViewWindow {
    private final Logger logger = LoggerFactory.getLogger(ViewContainerFrame.class);
    private ViewActions viewActions;
    private MainFrame mainFrame;
    private ViewContainer viewContainer;
    private JToolBar toolbar;
    private boolean showingToolbar;
    private boolean showingStatusbar;

    public ViewContainerFrame(MainFrame mainFrame, ViewContainer viewContainer) throws HeadlessException {
        this.mainFrame = mainFrame;
        this.viewContainer = viewContainer;
        this.viewActions = new ViewActions(mainFrame, viewContainer);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.add((Component)viewContainer, "Center");
        this.toolbar = this.viewActions.getToolbar();
        this.add((Component)this.toolbar, "North");
        this.setJMenuBar(this.viewActions.getMenuBar());
        this.addWindowListener(new CleanupWindowChangeListener());
    }

    public ViewActions getViewActions() {
        return this.viewActions;
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void focusWindow() {
        if ((this.getState() & 1) != 0) {
            this.setState(0);
        }
        this.toFront();
    }

    public void minimizeWindow() {
        this.setExtendedState(1);
    }

    public void closeWindow() {
        this.setVisible(false);
        this.dispose();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closed Frame...");
        }
    }

    public void setGlassPane(Component glassPane) {
        Component prev = this.getGlassPane();
        super.setGlassPane(glassPane);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Glasspane\nprev: {}\n new: {}", prev, (Object)glassPane);
        }
    }

    public void setShowingStatusbar(boolean showingStatusbar) {
        this.showingStatusbar = showingStatusbar;
        if (this.viewContainer != null) {
            this.viewContainer.setShowingStatusbar(showingStatusbar);
        }
    }

    public void setShowingToolbar(boolean showingToolbar) {
        this.showingToolbar = showingToolbar;
        this.toolbar.setVisible(showingToolbar);
    }

    public boolean isShowingToolbar() {
        return this.showingToolbar;
    }

    class CleanupWindowChangeListener
    implements WindowListener {
        CleanupWindowChangeListener() {
        }

        public void windowOpened(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowOpened: {}", e.getWindow());
            }
        }

        public void windowClosing(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowClosing: {}", e.getWindow());
            }
        }

        public void windowClosed(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowClosed: {}", e.getWindow());
            }
            ViewContainerFrame.this.viewContainer.cancelSearching();
            ViewContainerFrame.this.getContentPane().removeAll();
            ViewContainerFrame.this.viewActions.setViewContainer(null);
            ViewContainerFrame.this.mainFrame.updateWindowMenus();
        }

        public void windowIconified(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowIconified: {}", e.getWindow());
            }
        }

        public void windowDeiconified(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowDeiconified: {}", e.getWindow());
            }
        }

        public void windowActivated(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowActivated: {}", e.getWindow());
            }
        }

        public void windowDeactivated(WindowEvent e) {
            if (ViewContainerFrame.this.logger.isDebugEnabled()) {
                ViewContainerFrame.this.logger.debug("windowDeactivated: {}", e.getWindow());
            }
        }
    }
}

