/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.linklistener.OpenUrlLinkListener;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.SelectionHighlighter;

public class TipOfTheDayDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(TipOfTheDayDialog.class);
    private ArrayList<URL> tipsOfTheDay;
    private int currentTipOfTheDay;
    private ApplicationPreferences applicationPreferences;
    private XHTMLPanel helpPane;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private SelectionHighlighter.CopyAction copyAction;
    private JCheckBox showTipOfTheDayCheckbox;
    private static final int INSET = 10;
    private static final Icon INFO_ICON;

    public TipOfTheDayDialog(MainFrame owner) {
        super(owner);
        this.applicationPreferences = owner.getApplicationPreferences();
        this.setTitle("Tip of the Day");
        this.setDefaultCloseOperation(1);
        this.setModal(false);
        JPanel content = new JPanel(new GridBagLayout());
        this.setLayout(new GridLayout(1, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.top = 10;
        gbc.insets.bottom = 0;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        JLabel didYouKnowLabel = new JLabel("Did you know...?");
        Font labelFont = didYouKnowLabel.getFont();
        labelFont = labelFont.deriveFont(2.0f * labelFont.getSize2D());
        didYouKnowLabel.setFont(labelFont);
        didYouKnowLabel.setIcon(INFO_ICON);
        content.add((Component)didYouKnowLabel, gbc);
        gbc.anchor = 10;
        this.initHelpResources();
        this.helpPane = new XHTMLPanel();
        LinkListener originalLinkListener = null;
        List mouseTrackingList = this.helpPane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.helpPane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
                originalLinkListener = (LinkListener)o;
            }
        }
        this.helpPane.addMouseTrackingListener((FSMouseListener)new OpenUrlLinkListener(owner, originalLinkListener));
        SelectionHighlighter helpPaneCaret = new SelectionHighlighter();
        helpPaneCaret.install(this.helpPane);
        this.copyAction = new SelectionHighlighter.CopyAction();
        this.copyAction.install(helpPaneCaret);
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
        FSScrollPane helpScrollPane = new FSScrollPane((JPanel)this.helpPane);
        helpScrollPane.setPreferredSize(new Dimension(400, 200));
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        content.add((Component)helpScrollPane, gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 21;
        this.showTipOfTheDayCheckbox = new JCheckBox("Show Tip of the Day on startup.");
        this.showTipOfTheDayCheckbox.setSelected(this.applicationPreferences.isShowingTipOfTheDay());
        this.showTipOfTheDayCheckbox.addItemListener(new CheckboxListener());
        this.showTipOfTheDayCheckbox.setMnemonic(83);
        content.add((Component)this.showTipOfTheDayCheckbox, gbc);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridx = 0;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        gbc.insets.left = 0;
        gbc.insets.right = 10;
        buttonPanel.add((Component)new JButton(new PreviousTipAction()), gbc);
        gbc.gridx = 1;
        buttonPanel.add((Component)new JButton(new NextTipAction()), gbc);
        CloseAction closeAction = new CloseAction();
        gbc.gridx = 2;
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        buttonPanel.add((Component)new JButton(closeAction), gbc);
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        gbc.anchor = 22;
        gbc.gridx = 0;
        gbc.gridy = 3;
        content.add((Component)buttonPanel, gbc);
        KeyStrokes.registerCommand((JComponent)content, (Action)closeAction, (String)"CLOSE_ACTION");
        this.add(content);
        this.setCurrentTipOfTheDay(this.applicationPreferences.getCurrentTipOfTheDay() + 1);
    }

    private void nextTipOfTheDay() {
        this.setCurrentTipOfTheDay(this.currentTipOfTheDay + 1);
    }

    private void previousTipOfTheDay() {
        this.setCurrentTipOfTheDay(this.currentTipOfTheDay - 1);
    }

    private void setCurrentTipOfTheDay(int currentTipOfTheDay) {
        int count = this.tipsOfTheDay.size();
        if (currentTipOfTheDay < 0) {
            currentTipOfTheDay = count - 1;
        } else if (currentTipOfTheDay >= count) {
            currentTipOfTheDay = 0;
        }
        this.currentTipOfTheDay = currentTipOfTheDay;
        this.applicationPreferences.setCurrentTipOfTheDay(currentTipOfTheDay);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Current Tip of the Day: {}", currentTipOfTheDay);
        }
        this.helpPane.setDocument(this.tipsOfTheDay.get(currentTipOfTheDay).toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
    }

    private void initHelpResources() {
        URL url;
        this.tipsOfTheDay = new ArrayList();
        int i = 0;
        while ((url = TipOfTheDayDialog.class.getResource("/tips/" + i + ".xhtml")) != null) {
            this.tipsOfTheDay.add(url);
            ++i;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Tip of the Day URLs found: {}", this.tipsOfTheDay);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Found {} Tips of the Day.", this.tipsOfTheDay.size());
        }
    }

    public void copySelection() {
        this.copyAction.actionPerformed(null);
    }

    public void setShowingTipOfTheDay(boolean showingTipOfTheDay) {
        this.showTipOfTheDayCheckbox.setSelected(showingTipOfTheDay);
    }

    static {
        URL url = ViewActions.class.getResource("/tango/32x32/status/dialog-information.png");
        ImageIcon icon = url != null ? new ImageIcon(url) : null;
        INFO_ICON = icon;
    }

    private class CheckboxListener
    implements ItemListener {
        private CheckboxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == TipOfTheDayDialog.this.showTipOfTheDayCheckbox) {
                TipOfTheDayDialog.this.applicationPreferences.setShowingTipOfTheDay(TipOfTheDayDialog.this.showTipOfTheDayCheckbox.isSelected());
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -3837690263247686627L;

        private CloseAction() {
            super("Close");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (TipOfTheDayDialog.this.logger.isDebugEnabled()) {
                TipOfTheDayDialog.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayDialog.this.setVisible(false);
            Container parentContainer = TipOfTheDayDialog.this.getParent();
            if (parentContainer != null) {
                parentContainer.requestFocus();
            }
        }
    }

    private class NextTipAction
    extends AbstractAction {
        private static final long serialVersionUID = 107240711521577323L;

        private NextTipAction() {
            super("Next Tip");
            this.putValue("MnemonicKey", 78);
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayDialog.this.nextTipOfTheDay();
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        private static final long serialVersionUID = -4025074394725104369L;

        private PreviousTipAction() {
            super("Previous Tip");
            this.putValue("MnemonicKey", 80);
        }

        public void actionPerformed(ActionEvent e) {
            TipOfTheDayDialog.this.previousTipOfTheDay();
        }
    }
}

