/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.Lilith;
import de.huxhorn.lilith.LilithBuffer;
import de.huxhorn.lilith.appender.InternalLilithAppender;
import de.huxhorn.lilith.consumers.AlarmSoundAccessEventConsumer;
import de.huxhorn.lilith.consumers.AlarmSoundLoggingEventConsumer;
import de.huxhorn.lilith.consumers.FileDumpEventConsumer;
import de.huxhorn.lilith.consumers.FileSplitterEventConsumer;
import de.huxhorn.lilith.consumers.RrdLoggingEventConsumer;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.debug.DebugDialog;
import de.huxhorn.lilith.engine.AccessFileBufferFactory;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.EventSourceListener;
import de.huxhorn.lilith.engine.EventSourceProducer;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.LoggingFileBufferFactory;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.engine.impl.sourcemanager.SourceManagerImpl;
import de.huxhorn.lilith.engine.impl.sourceproducer.AccessEventProtobufServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.impl.sourceproducer.LoggingEventProtobufServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlMessageLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlStreamLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.jul.xml.JulImportCallable;
import de.huxhorn.lilith.log4j.xml.Log4jImportCallable;
import de.huxhorn.lilith.logback.producer.LogbackAccessServerSocketEventSourceProducer;
import de.huxhorn.lilith.logback.producer.LogbackLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.services.gotosrc.GoToSourceService;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.services.sender.SenderService;
import de.huxhorn.lilith.swing.AboutDialog;
import de.huxhorn.lilith.swing.AccessEventViewManager;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.CheckForUpdateDialog;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.HelpFrame;
import de.huxhorn.lilith.swing.HtmlTransferable;
import de.huxhorn.lilith.swing.LoggingEventViewManager;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.OpenPreviousDialog;
import de.huxhorn.lilith.swing.SplashScreen;
import de.huxhorn.lilith.swing.StatisticsDialog;
import de.huxhorn.lilith.swing.TipOfTheDayDialog;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewContainerFrame;
import de.huxhorn.lilith.swing.ViewContainerInternalFrame;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.callables.CleanAllInactiveCallable;
import de.huxhorn.lilith.swing.callables.CleanObsoleteCallable;
import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.lilith.swing.filefilters.DirectoryFilter;
import de.huxhorn.lilith.swing.filefilters.LilithFileFilter;
import de.huxhorn.lilith.swing.filefilters.LogFileFilter;
import de.huxhorn.lilith.swing.filefilters.RrdFileFilter;
import de.huxhorn.lilith.swing.filefilters.XmlImportFileFilter;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.taskmanager.TaskManagerInternalFrame;
import de.huxhorn.lilith.swing.transfer.MainFrameTransferHandler;
import de.huxhorn.lilith.swing.transfer.MainFrameTransferHandler16;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.formatting.SimpleXml;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.swing.MemoryStatus;
import de.huxhorn.sulky.swing.Windows;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
    private final File startupApplicationPath;
    private GoToSourceService gotoSource;
    private LogFileFactory loggingFileFactory;
    private SourceManager<LoggingEvent> loggingEventSourceManager;
    private FileBufferFactory<LoggingEvent> loggingFileBufferFactory;
    private EventSourceListener<LoggingEvent> loggingSourceListener;
    private LoggingEventViewManager loggingEventViewManager;
    private LogFileFactory accessFileFactory;
    private SourceManager<AccessEvent> accessEventSourceManager;
    private FileBufferFactory<AccessEvent> accessFileBufferFactory;
    private EventSourceListener<AccessEvent> accessSourceListener;
    private AccessEventViewManager accessEventViewManager;
    private Sounds sounds;
    private JDesktopPane desktop;
    private PreferencesDialog preferencesDialog;
    private JDialog aboutDialog;
    private JLabel statusLabel;
    private ApplicationPreferences applicationPreferences;
    private DebugDialog debugDialog;
    private RrdFileFilter rrdFileFilter;
    private StatisticsDialog statisticsDialog;
    private TaskManager<Long> longTaskManager;
    private ViewActions viewActions;
    private OpenPreviousDialog openInactiveLogsDialog;
    private HelpFrame helpFrame;
    private Application application;
    private int activeCounter;
    private List<AutostartRunnable> autostartProcesses;
    private SenderService senderService;
    private boolean enableBonjour;
    private final boolean isMac;
    private final boolean isWindows;
    private List<SavedCondition> activeConditions;
    private Map<LoggingEvent.Level, Colors> levelColors;
    private Map<HttpStatus.Type, Colors> statusColors;
    private SplashScreen splashScreen;
    private TaskManagerInternalFrame taskManagerFrame;
    private JLabel taskStatusLabel;
    private int previousNumberOfTasks;
    private ImageIcon smallProgressIcon;
    public static final String LOGS_SUBDIRECTORY = "logs";
    public static final String LOGGING_FILE_SUBDIRECTORY = "logs/logging";
    public static final String ACCESS_FILE_SUBDIRECTORY = "logs/access";
    private JFileChooser openFileChooser;
    private JFileChooser importFileChooser;
    private boolean coloringWholeRow;
    private static final double SCALE_FACTOR = 0.05;
    private JToolBar toolbar;
    private JPanel statusBar;
    private TipOfTheDayDialog tipOfTheDayDialog;
    private CheckForUpdateDialog checkForUpdateDialog;
    private FileDumpEventConsumer<LoggingEvent> loggingFileDump;
    private FileDumpEventConsumer<AccessEvent> accessFileDump;
    private RrdLoggingEventConsumer rrdLoggingEventConsumer;
    private long lastScriptRefresh = 0L;
    private long previousScriptFileTimestamp = 0L;
    private Script detailsViewScript;
    private static final int SCRIPT_REFRESH_INTERVAL = 5000;
    private static final String[] MAC_OPEN_URL_ARRAY = new String[]{"open", null};
    private static final String[] WINDOWS_OPEN_URL_ARRAY = new String[]{"cmd", "/C", "start", null};

    public String[] getAllConditionScriptFiles() {
        return this.applicationPreferences.getAllConditionScriptFiles();
    }

    public File resolveConditionScriptFile(String input) {
        return this.applicationPreferences.resolveConditionScriptFile(input);
    }

    public AccessEventViewManager getAccessEventViewManager() {
        return this.accessEventViewManager;
    }

    public LoggingEventViewManager getLoggingEventViewManager() {
        return this.loggingEventViewManager;
    }

    public PreferencesDialog getPreferencesDialog() {
        return this.preferencesDialog;
    }

    public ViewActions getViewActions() {
        return this.viewActions;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public MainFrame(ApplicationPreferences applicationPreferences, SplashScreen splashScreen, String appName, boolean enableBonjour) {
        super(appName);
        this.applicationPreferences = applicationPreferences;
        this.coloringWholeRow = this.applicationPreferences.isColoringWholeRow();
        this.splashScreen = splashScreen;
        this.setSplashStatusText("Creating main frame.");
        this.smallProgressIcon = new ImageIcon(MainFrame.class.getResource("/otherGraphics/Progress16.gif"));
        ImageIcon frameIcon = new ImageIcon(MainFrame.class.getResource("/otherGraphics/Lilith16.jpg"));
        this.setIconImage(frameIcon.getImage());
        this.application = new DefaultApplication();
        this.isMac = this.application.isMac();
        if (!this.isMac) {
            String osName = System.getProperty("os.name").toLowerCase();
            this.isWindows = osName.startsWith("windows");
        } else {
            this.isWindows = false;
        }
        this.autostartProcesses = new ArrayList<AutostartRunnable>();
        this.addWindowListener(new MainWindowListener());
        Runtime runtime = Runtime.getRuntime();
        Thread shutdownHook = new Thread(new ShutdownRunnable());
        runtime.addShutdownHook(shutdownHook);
        this.senderService = new SenderService(this);
        this.enableBonjour = enableBonjour;
        this.longTaskManager = new TaskManager();
        this.longTaskManager.setUsingEventQueue(true);
        this.longTaskManager.startUp();
        this.longTaskManager.addTaskListener((TaskListener)new MainTaskListener());
        this.startupApplicationPath = this.applicationPreferences.getStartupApplicationPath();
        this.loggingFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, LOGGING_FILE_SUBDIRECTORY));
        this.accessFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, ACCESS_FILE_SUBDIRECTORY));
        HashMap<String, String> loggingMetaData = new HashMap<String, String>();
        loggingMetaData.put("contentType", "logging");
        loggingMetaData.put("contentFormat", "protobuf");
        loggingMetaData.put("compression", "GZIP");
        this.loggingFileBufferFactory = new LoggingFileBufferFactory(this.loggingFileFactory, loggingMetaData);
        HashMap<String, String> accessMetaData = new HashMap<String, String>();
        accessMetaData.put("contentType", "access");
        accessMetaData.put("contentFormat", "protobuf");
        accessMetaData.put("compression", "GZIP");
        this.accessFileBufferFactory = new AccessFileBufferFactory(this.accessFileFactory, accessMetaData);
        this.rrdFileFilter = new RrdFileFilter();
        this.loggingEventViewManager = new LoggingEventViewManager(this);
        this.accessEventViewManager = new AccessEventViewManager(this);
        this.applicationPreferences.addPropertyChangeListener(new PreferencesChangeListener());
        this.loggingSourceListener = new LoggingEventSourceListener();
        this.accessSourceListener = new AccessEventSourceListener();
        this.desktop = new JDesktopPane();
        this.statusBar = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Starting...");
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.statusBar.add((Component)this.statusLabel, gbc);
        this.taskStatusLabel = new JLabel();
        this.taskStatusLabel.setText("");
        this.taskStatusLabel.setForeground(Color.BLUE);
        this.taskStatusLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainFrame.this.showTaskManager();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                MainFrame.this.taskStatusLabel.setForeground(Color.RED);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                MainFrame.this.taskStatusLabel.setForeground(Color.BLUE);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.statusBar.add((Component)this.taskStatusLabel, gbc);
        MemoryStatus memoryStatus = new MemoryStatus();
        memoryStatus.setBackground(Color.WHITE);
        memoryStatus.setOpaque(true);
        memoryStatus.setUsingBinaryUnits(true);
        memoryStatus.setUsingTotal(false);
        memoryStatus.setBorder((Border)new EtchedBorder(1));
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.statusBar.add((Component)memoryStatus, gbc);
        this.add((Component)this.desktop, "Center");
        this.add((Component)this.statusBar, "South");
        this.setSplashStatusText("Creating statistics dialog.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Before creation of statistics-dialog...");
        }
        this.statisticsDialog = new StatisticsDialog(this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After creation of statistics-dialog...");
        }
        this.setSplashStatusText("Creating about dialog.");
        this.aboutDialog = new AboutDialog((Frame)this, "About " + appName + "...", appName);
        this.setSplashStatusText("Creating update dialog.");
        this.checkForUpdateDialog = new CheckForUpdateDialog(this);
        this.setSplashStatusText("Creating debug dialog.");
        this.debugDialog = new DebugDialog((Frame)this, this);
        this.setSplashStatusText("Creating preferences dialog.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Before creation of preferences-dialog...");
        }
        this.preferencesDialog = new PreferencesDialog(this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("After creation of preferences-dialog...");
        }
        this.setSplashStatusText("Creating \"Open inactive\" dialog.");
        this.openInactiveLogsDialog = new OpenPreviousDialog(this);
        this.setSplashStatusText("Creating help frame.");
        this.helpFrame = new HelpFrame(this);
        this.helpFrame.setTitle("Help Topics");
        this.openFileChooser = new JFileChooser();
        this.openFileChooser.setFileFilter(new LilithFileFilter());
        this.openFileChooser.setFileHidingEnabled(false);
        this.openFileChooser.setCurrentDirectory(this.applicationPreferences.getPreviousOpenPath());
        this.importFileChooser = new JFileChooser();
        this.importFileChooser.setFileFilter(new XmlImportFileFilter());
        this.importFileChooser.setFileHidingEnabled(false);
        this.importFileChooser.setCurrentDirectory(this.applicationPreferences.getPreviousImportPath());
        this.setSplashStatusText("Creating task manager frame.");
        this.taskManagerFrame = new TaskManagerInternalFrame(this);
        this.taskManagerFrame.setTitle("Task Manager");
        this.taskManagerFrame.setDefaultCloseOperation(1);
        this.taskManagerFrame.setBounds(0, 0, 320, 240);
        this.desktop.add(this.taskManagerFrame);
        this.desktop.validate();
        try {
            new MainFrameTransferHandler16(this).attach();
        }
        catch (Throwable t) {
            new MainFrameTransferHandler(this).attach();
        }
        this.setSplashStatusText("Creating Tip of the Day dialog.");
        this.tipOfTheDayDialog = new TipOfTheDayDialog(this);
        this.setSplashStatusText("Creating actions and menus.");
        this.viewActions = new ViewActions(this, null);
        this.viewActions.getPopupMenu();
        JMenuBar menuBar = this.viewActions.getMenuBar();
        this.toolbar = this.viewActions.getToolbar();
        this.add((Component)this.toolbar, "North");
        this.setJMenuBar(menuBar);
        this.setShowingToolbar(applicationPreferences.isShowingToolbar());
        this.setShowingStatusbar(applicationPreferences.isShowingStatusbar());
    }

    public void startUp() {
        block34: {
            LoggingEventProtobufServerSocketEventSourceProducer producer;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            File[] autoFiles;
                                            this.setSplashStatusText("Executing autostart items.");
                                            File autostartDir = new File(this.startupApplicationPath, "autostart");
                                            if (autostartDir.mkdirs() && this.logger.isDebugEnabled()) {
                                                this.logger.debug("Created '{}'.", (Object)autostartDir.getAbsolutePath());
                                            }
                                            if ((autoFiles = autostartDir.listFiles(new FileFilter(){

                                                public boolean accept(File file) {
                                                    return file.isFile();
                                                }
                                            })) != null && autoFiles.length > 0) {
                                                Arrays.sort(autoFiles, new Comparator<File>(){

                                                    @Override
                                                    public int compare(File o1, File o2) {
                                                        return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                                                    }
                                                });
                                                for (File current : autoFiles) {
                                                    AutostartRunnable r = new AutostartRunnable(current);
                                                    this.autostartProcesses.add(r);
                                                    Thread t = new Thread((Runnable)r, current.getAbsolutePath());
                                                    t.setDaemon(true);
                                                    t.start();
                                                }
                                            } else if (this.logger.isInfoEnabled()) {
                                                this.logger.info("No autostart files defined in '{}'.", (Object)autostartDir.getAbsolutePath());
                                            }
                                            this.gotoSource = new GoToSourceService();
                                            this.setSplashStatusText("Creating global views.");
                                            SourceIdentifier globalSourceIdentifier = new SourceIdentifier("global", null);
                                            this.loggingFileDump = new FileDumpEventConsumer<LoggingEvent>(globalSourceIdentifier, this.loggingFileBufferFactory);
                                            this.accessFileDump = new FileDumpEventConsumer<AccessEvent>(globalSourceIdentifier, this.accessFileBufferFactory);
                                            this.setGlobalLoggingEnabled(this.applicationPreferences.isGlobalLoggingEnabled());
                                            LilithBuffer loggingEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                            LilithBuffer accessEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                            SourceManagerImpl lsm = new SourceManagerImpl(loggingEventQueue);
                                            EventSourceImpl globalLoggingEventSource = new EventSourceImpl(globalSourceIdentifier, this.loggingFileDump.getBuffer(), true);
                                            lsm.addSource((EventSource)globalLoggingEventSource);
                                            this.setSplashStatusText("Creating internal view.");
                                            EventSourceImpl lilithLoggingEventSource = new EventSourceImpl(InternalLilithAppender.getSourceIdentifier(), InternalLilithAppender.getBuffer(), false);
                                            lsm.addSource((EventSource)lilithLoggingEventSource);
                                            this.setLoggingEventSourceManager((SourceManager<LoggingEvent>)lsm);
                                            SourceManagerImpl asm = new SourceManagerImpl(accessEventQueue);
                                            EventSourceImpl globalAccessEventSource = new EventSourceImpl(globalSourceIdentifier, this.accessFileDump.getBuffer(), true);
                                            asm.addSource((EventSource)globalAccessEventSource);
                                            this.setAccessEventSourceManager((SourceManager<AccessEvent>)asm);
                                            try {
                                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)new LogbackLoggingServerSocketEventSourceProducer(4560));
                                            }
                                            catch (IOException ex) {
                                                if (!this.logger.isWarnEnabled()) break block26;
                                                this.logger.warn("Exception while creating event producer!", ex);
                                            }
                                        }
                                        this.setSplashStatusText("Starting event receivers.");
                                        try {
                                            producer = new LoggingEventProtobufServerSocketEventSourceProducer(10000, true);
                                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                        }
                                        catch (IOException ex) {
                                            if (!this.logger.isWarnEnabled()) break block27;
                                            this.logger.warn("Exception while creating event producer!", ex);
                                        }
                                    }
                                    try {
                                        producer = new LoggingEventProtobufServerSocketEventSourceProducer(10001, false);
                                        this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                    }
                                    catch (IOException ex) {
                                        if (!this.logger.isWarnEnabled()) break block28;
                                        this.logger.warn("Exception while creating event producer!", ex);
                                    }
                                }
                                try {
                                    producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10021, false);
                                    this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                }
                                catch (IOException ex) {
                                    if (!this.logger.isWarnEnabled()) break block29;
                                    this.logger.warn("Exception while creating event producer!", ex);
                                }
                            }
                            try {
                                producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10020, true);
                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                            }
                            catch (IOException ex) {
                                if (!this.logger.isWarnEnabled()) break block30;
                                this.logger.warn("Exception while creating event producer!", ex);
                            }
                        }
                        try {
                            producer = new LilithXmlStreamLoggingServerSocketEventSourceProducer(11000);
                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                        }
                        catch (IOException ex) {
                            if (!this.logger.isWarnEnabled()) break block31;
                            this.logger.warn("Exception while creating event producer!", ex);
                        }
                    }
                    try {
                        this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)new LogbackAccessServerSocketEventSourceProducer(4570));
                    }
                    catch (IOException ex) {
                        if (!this.logger.isWarnEnabled()) break block32;
                        this.logger.warn("Exception while creating event producer!", ex);
                    }
                }
                try {
                    producer = new AccessEventProtobufServerSocketEventSourceProducer(10010, true);
                    this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block33;
                    this.logger.warn("Exception while creating event producer!", ex);
                }
            }
            try {
                producer = new AccessEventProtobufServerSocketEventSourceProducer(10011, false);
                this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
            }
            catch (IOException ex) {
                if (!this.logger.isWarnEnabled()) break block34;
                this.logger.warn("Exception while creating event producer!", ex);
            }
        }
        this.setSplashStatusText("Setting up event consumers.");
        this.rrdLoggingEventConsumer = new RrdLoggingEventConsumer();
        this.rrdLoggingEventConsumer.setBasePath(new File(this.startupApplicationPath, "statistics"));
        this.setStatisticsEnabled(this.applicationPreferences.isLoggingStatisticEnabled());
        AlarmSoundLoggingEventConsumer loggingEventAlarmSound = new AlarmSoundLoggingEventConsumer();
        loggingEventAlarmSound.setSounds(this.sounds);
        FileSplitterEventConsumer<LoggingEvent> fileSplitterLoggingEventConsumer = new FileSplitterEventConsumer<LoggingEvent>(this.loggingFileBufferFactory, this.loggingEventSourceManager);
        ArrayList<Object> loggingConsumers = new ArrayList<Object>();
        loggingConsumers.add(this.rrdLoggingEventConsumer);
        loggingConsumers.add(loggingEventAlarmSound);
        loggingConsumers.add(fileSplitterLoggingEventConsumer);
        loggingConsumers.add(this.loggingFileDump);
        this.loggingEventSourceManager.setEventConsumers(loggingConsumers);
        this.loggingEventSourceManager.start();
        ArrayList<Object> accessConsumers = new ArrayList<Object>();
        FileSplitterEventConsumer<AccessEvent> fileSplitterAccessEventConsumer = new FileSplitterEventConsumer<AccessEvent>(this.accessFileBufferFactory, this.accessEventSourceManager);
        AlarmSoundAccessEventConsumer accessEventAlarmSound = new AlarmSoundAccessEventConsumer();
        accessEventAlarmSound.setSounds(this.sounds);
        accessConsumers.add(accessEventAlarmSound);
        accessConsumers.add(fileSplitterAccessEventConsumer);
        accessConsumers.add(this.accessFileDump);
        this.accessEventSourceManager.setEventConsumers(accessConsumers);
        this.accessEventSourceManager.start();
        this.viewActions.updateWindowMenu();
        this.application.setEnabledAboutMenu(true);
        this.application.setEnabledPreferencesMenu(true);
        this.application.addApplicationListener((ApplicationListener)new MyApplicationListener());
        if (this.enableBonjour) {
            this.senderService.start();
        }
        if (this.applicationPreferences.isCheckingForUpdate()) {
            this.checkForUpdate(false);
        }
        this.updateConditions();
        if (this.applicationPreferences.isShowingTipOfTheDay()) {
            this.showTipOfTheDayDialog();
        }
        this.cleanObsoleteFiles();
        this.setSplashStatusText("Finished.");
    }

    public void showTipOfTheDayDialog() {
        Windows.showWindow((Window)this.tipOfTheDayDialog, (Window)this, (boolean)true);
    }

    private void updateTaskStatus() {
        int numberOfTasks = this.longTaskManager.getNumberOfTasks();
        if (numberOfTasks != this.previousNumberOfTasks) {
            this.previousNumberOfTasks = numberOfTasks;
            String text = "";
            ImageIcon icon = null;
            if (numberOfTasks == 1) {
                text = "1 active task.";
                icon = this.smallProgressIcon;
            } else if (numberOfTasks > 1) {
                text = "" + numberOfTasks + " active tasks.";
                icon = this.smallProgressIcon;
            }
            this.taskStatusLabel.setText(text);
            this.taskStatusLabel.setIcon(icon);
        }
    }

    private void setSplashStatusText(String text) {
        if (this.splashScreen != null) {
            this.splashScreen.setStatusText(text);
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public Map<String, EventSender<LoggingEvent>> getLoggingEventSenders() {
        return this.senderService.getLoggingEventSenders();
    }

    public Map<String, EventSender<AccessEvent>> getAccessEventSenders() {
        return this.senderService.getAccessEventSenders();
    }

    public void updateWindowMenus() {
        this.viewActions.updateWindowMenu();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
        JInternalFrame selected = this.desktop.getSelectedFrame();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Selected IFrame: {}", selected);
        }
        if (selected instanceof ViewContainerInternalFrame) {
            ViewContainerInternalFrame iframe = (ViewContainerInternalFrame)selected;
            this.viewActions.setViewContainer(iframe.getViewContainer());
        } else {
            this.viewActions.setViewContainer(null);
        }
    }

    public void closeLoggingConnection(SourceIdentifier id) {
        this.loggingEventSourceManager.removeEventProducer(id);
    }

    public void closeAccessConnection(SourceIdentifier id) {
        this.accessEventSourceManager.removeEventProducer(id);
    }

    public void goToSource(StackTraceElement ste) {
        if (this.gotoSource != null) {
            this.gotoSource.goToSource(ste);
        }
    }

    public void setActiveConnectionsCounter(int activeCounter) {
        this.activeCounter = activeCounter;
        this.updateStatus();
    }

    public void copyHtml(String html) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        HtmlTransferable transferableText = new HtmlTransferable(html);
        systemClipboard.setContents(transferableText, null);
    }

    public void checkForUpdate(boolean showAlways) {
        Thread t = new Thread(new CheckForUpdateRunnable(showAlways));
        t.start();
    }

    public void showPopup(Component component, Point p) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Show popup at {}.", p);
        }
        JPopupMenu popup = this.viewActions.getPopupMenu();
        popup.show(component, p.x, p.y);
    }

    public Colors getColors(HttpStatus.Type status) {
        if (this.statusColors == null) {
            this.initStatusColors();
        }
        return this.statusColors.get(status);
    }

    public Colors getColors(LoggingEvent.Level level) {
        if (this.levelColors == null) {
            this.initLevelColors();
        }
        return this.levelColors.get(level);
    }

    public Colors getColors(EventWrapper eventWrapper) {
        if (!SwingUtilities.isEventDispatchThread() && this.logger.isErrorEnabled()) {
            this.logger.error("Not on EventDispatchThread!");
        }
        if (this.activeConditions != null) {
            for (SavedCondition current : this.activeConditions) {
                Condition condition = current.getCondition();
                if (condition == null || !condition.isTrue((Object)eventWrapper)) continue;
                return new Colors(current.getColorScheme());
            }
        }
        if (this.coloringWholeRow) {
            Serializable eventObj = eventWrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                return this.getColors(((LoggingEvent)eventObj).getLevel());
            }
            if (eventObj instanceof AccessEvent) {
                return this.getColors(HttpStatus.getType((int)((AccessEvent)eventObj).getStatusCode()));
            }
        }
        return null;
    }

    public void open() {
        int returnVal = this.openFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.open(this.openFileChooser.getSelectedFile());
        }
    }

    public void importFile() {
        int returnVal = this.importFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File importFile = this.importFileChooser.getSelectedFile();
            String fileName = importFile.getAbsolutePath();
            if (fileName.toLowerCase().endsWith(".lilith")) {
                this.open(importFile);
                return;
            }
            this.importFile(importFile);
        }
    }

    public void open(File dataFile) {
        String dialogTitle;
        String message;
        int result;
        ViewContainer<?> viewContainer;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Open file: {}", (Object)dataFile.getAbsolutePath());
        }
        if ((viewContainer = this.resolveViewContainer(dataFile)) != null) {
            this.showView(viewContainer);
            String message2 = "File '" + dataFile.getAbsolutePath() + "' is already open.";
            JOptionPane.showMessageDialog(this, message2, "File is already open...", 1);
            return;
        }
        String fileName = dataFile.getAbsolutePath();
        String indexFileName = fileName.toLowerCase().endsWith(".lilith") ? fileName.substring(0, fileName.length() - ".lilith".length()) : fileName;
        indexFileName = indexFileName + ".idx";
        long dataModified = dataFile.lastModified();
        File indexFile = new File(indexFileName);
        if (!indexFile.isFile()) {
            String message3 = "Index file does not exist!\nIndex data file right now?";
            String dialogTitle2 = "Index file?";
            int result2 = JOptionPane.showConfirmDialog(this, message3, dialogTitle2, 2, 3);
            if (0 != result2) {
                return;
            }
            String name = "Indexing Lilith file";
            String description = "Indexing '" + dataFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)((Object)new IndexingCallable(dataFile, indexFile)), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        long indexModified = indexFile.lastModified();
        if (indexModified < dataModified && 0 == (result = JOptionPane.showConfirmDialog(this, message = "The index file is older than the data file!\nReindex data file right now?", dialogTitle = "Index outdated. Reindex file?", 2, 3)) && indexFile.delete()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Deleted previous index file {}.", (Object)indexFile.getAbsolutePath());
            }
            String name = "Reindexing Lilith file";
            String description = "Reindexing '" + dataFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)((Object)new IndexingCallable(dataFile, indexFile)), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        this.createViewFor(dataFile, indexFile);
    }

    public void importFile(File importFile) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Import file: {}", (Object)importFile.getAbsolutePath());
        }
        File parentFile = importFile.getParentFile();
        String inputName = importFile.getName();
        File dataFile = new File(parentFile, inputName + ".lilith");
        File indexFile = new File(parentFile, inputName + ".idx");
        if (dataFile.isFile()) {
            ViewContainer<?> viewContainer = this.resolveViewContainer(dataFile);
            if (viewContainer != null) {
                this.showView(viewContainer);
                String message = "File '" + dataFile.getAbsolutePath() + "' is already open.";
                JOptionPane.showMessageDialog(this, message, "File is already open...", 1);
                return;
            }
            String message = "Data file does already exist!\nReimport data file right now?";
            String dialogTitle = "Reimport file?";
            int result = JOptionPane.showConfirmDialog(this, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            if (dataFile.delete() && this.logger.isInfoEnabled()) {
                this.logger.info("Deleted file '{}'.", (Object)dataFile.getAbsolutePath());
            }
        }
        if (indexFile.isFile() && indexFile.delete() && this.logger.isInfoEnabled()) {
            this.logger.info("Deleted file '{}'.", (Object)indexFile.getAbsolutePath());
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("contentFormat", "protobuf");
        metaData.put("contentType", "logging");
        metaData.put("compression", "GZIP");
        FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(dataFile, indexFile, metaData);
        ImportType type = this.resolveType(importFile);
        if (type == ImportType.LOG4J) {
            String name = "Importing Log4J XML file";
            String description = "Importing Log4J XML file '" + importFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)new Log4jImportCallable(importFile, (AppendOperation)buffer), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        if (type == ImportType.JUL) {
            String name = "Importing java.util.logging XML file";
            String description = "Importing java.util.logging XML file '" + importFile.getAbsolutePath() + "'...";
            Task task = this.longTaskManager.startTask((Callable)new JulImportCallable(importFile, (AppendOperation)buffer), name, description);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task-Name: {}", (Object)task.getName());
            }
            return;
        }
        String message = "Couldn't detect type of file '" + importFile.getAbsolutePath() + "'.\nFile is unsupported.";
        JOptionPane.showMessageDialog(this, message, "Unknown file type...", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportType resolveType(File importFile) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(importFile));
            for (int i = 0; i < 5; ++i) {
                String line = br.readLine();
                if (line == null) {
                    break;
                }
                if (line.contains("<log4j:")) {
                    ImportType importType = ImportType.LOG4J;
                    return importType;
                }
                if (!line.contains("<log>") && !line.contains("<record>")) continue;
                ImportType importType = ImportType.JUL;
                return importType;
            }
        }
        catch (IOException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while resolving type of file!", ex);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void zoomOut() {
        double scale = this.applicationPreferences.getScaleFactor() - 0.05;
        if (scale < 0.1) {
            scale = 0.1;
        }
        this.applicationPreferences.setScaleFactor(scale);
    }

    public void zoomIn() {
        double scale = this.applicationPreferences.getScaleFactor() + 0.05;
        this.applicationPreferences.setScaleFactor(scale);
    }

    public void resetZoom() {
        this.applicationPreferences.setScaleFactor(1.0);
    }

    public void troubleshooting() {
        this.preferencesDialog.showPane(PreferencesDialog.Panes.Troubleshooting);
    }

    public void openHelp(String help) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opening help: {}", (Object)help);
        }
        this.helpFrame.setHelpUrl(help);
        if (!this.helpFrame.isVisible()) {
            Windows.showWindow((Window)this.helpFrame, (Window)this, (boolean)false);
        }
        this.helpFrame.toFront();
    }

    public void openPreferences(String panelName) {
        block2: {
            try {
                PreferencesDialog.Panes pane = PreferencesDialog.Panes.valueOf(panelName);
                this.preferencesDialog.showPane(pane);
            }
            catch (IllegalArgumentException ex) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Couldn't resolve preferences pane '{}'!", (Object)panelName);
            }
        }
    }

    public ViewContainer<?> resolveViewContainer(File dataFile) {
        CodecFileBuffer cfb;
        Buffer buffer;
        EventSource es;
        EventWrapperViewPanel defaultView;
        ViewContainer view;
        Map views = this.loggingEventViewManager.getViews();
        for (Map.Entry current : views.entrySet()) {
            view = current.getValue();
            defaultView = view.getDefaultView();
            es = defaultView.getEventSource();
            if (es == null || !((buffer = es.getBuffer()) instanceof CodecFileBuffer) || !dataFile.equals((cfb = (CodecFileBuffer)buffer).getDataFile())) continue;
            return view;
        }
        views = this.accessEventViewManager.getViews();
        for (Map.Entry current : views.entrySet()) {
            view = current.getValue();
            defaultView = view.getDefaultView();
            es = defaultView.getEventSource();
            if (es == null || !((buffer = es.getBuffer()) instanceof CodecFileBuffer) || !dataFile.equals((cfb = (CodecFileBuffer)buffer).getDataFile())) continue;
            return view;
        }
        return null;
    }

    private void createViewFor(File dataFile, File indexFile) {
        block14: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Create view for dataFile '{}' and indexFile '{}'.", (Object)dataFile.getAbsolutePath(), (Object)indexFile.getAbsolutePath());
            }
            DefaultFileHeaderStrategy fileHeaderStrategy = new DefaultFileHeaderStrategy();
            try {
                FileHeader header = fileHeaderStrategy.readFileHeader(dataFile);
                if (header == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Couldn't read file header from '{}'!", (Object)dataFile.getAbsolutePath());
                    }
                    return;
                }
                if (header.getMagicValue() != 190731757) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Invalid magic value! ", (Object)Integer.toHexString(header.getMagicValue()));
                    }
                    return;
                }
                MetaData metaData = header.getMetaData();
                if (metaData == null || metaData.getData() == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Couldn't read meta data from '{}'!", (Object)dataFile.getAbsolutePath());
                    }
                    return;
                }
                Map data = metaData.getData();
                String contentType = (String)data.get("contentType");
                HashMap usedMetaData = new HashMap();
                SourceIdentifier si = new SourceIdentifier(dataFile.getAbsolutePath());
                if ("logging".equals(contentType)) {
                    FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(dataFile, indexFile, usedMetaData);
                    EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
                    ViewContainer viewContainer = this.loggingEventViewManager.retrieveViewContainer(eventSource);
                    EventWrapperViewPanel panel = viewContainer.getDefaultView();
                    panel.setState(LoggingViewState.INACTIVE);
                    this.showLoggingView((EventSource<LoggingEvent>)eventSource);
                } else if ("access".equals(contentType)) {
                    FileBuffer buffer = this.accessFileBufferFactory.createBuffer(dataFile, indexFile, usedMetaData);
                    EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
                    ViewContainer viewContainer = this.accessEventViewManager.retrieveViewContainer(eventSource);
                    EventWrapperViewPanel panel = viewContainer.getDefaultView();
                    panel.setState(LoggingViewState.INACTIVE);
                    this.showAccessView((EventSource<AccessEvent>)eventSource);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Unexpected content type {}.", (Object)contentType);
                }
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block14;
                this.logger.warn("Exception while creating view form file!", e);
            }
        }
    }

    private void initStatusColors() {
        Map<HttpStatus.Type, ColorScheme> prefValue = this.applicationPreferences.getStatusColors();
        HashMap<HttpStatus.Type, Colors> colors = new HashMap<HttpStatus.Type, Colors>();
        for (Map.Entry<HttpStatus.Type, ColorScheme> current : prefValue.entrySet()) {
            colors.put(current.getKey(), new Colors(current.getValue()));
        }
        this.statusColors = colors;
    }

    private void initLevelColors() {
        Map<LoggingEvent.Level, ColorScheme> prefValue = this.applicationPreferences.getLevelColors();
        HashMap<LoggingEvent.Level, Colors> colors = new HashMap<LoggingEvent.Level, Colors>();
        for (Map.Entry<LoggingEvent.Level, ColorScheme> current : prefValue.entrySet()) {
            colors.put(current.getKey(), new Colors(current.getValue()));
        }
        this.levelColors = colors;
    }

    private void setLoggingEventSourceManager(SourceManager<LoggingEvent> loggingEventSourceManager) {
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.removeEventSourceListener(this.loggingSourceListener);
        }
        this.loggingEventSourceManager = loggingEventSourceManager;
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.addEventSourceListener(this.loggingSourceListener);
            List sources = this.loggingEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.loggingEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<LoggingEvent> getLoggingEventSourceManager() {
        return this.loggingEventSourceManager;
    }

    private void setAccessEventSourceManager(SourceManager<AccessEvent> accessEventSourceManager) {
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.removeEventSourceListener(this.accessSourceListener);
        }
        this.accessEventSourceManager = accessEventSourceManager;
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.addEventSourceListener(this.accessSourceListener);
            List sources = this.accessEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.accessEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<AccessEvent> getAccessEventSourceManager() {
        return this.accessEventSourceManager;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public void setSounds(Sounds sounds) {
        if (sounds != null) {
            sounds.setSoundLocations(this.applicationPreferences.getSoundLocations());
            sounds.setMute(this.applicationPreferences.isMute());
        }
        this.sounds = sounds;
    }

    private ViewContainer<LoggingEvent> retrieveLoggingViewContainer(EventSource<LoggingEvent> eventSource) {
        return this.loggingEventViewManager.retrieveViewContainer(eventSource);
    }

    private ViewContainer<AccessEvent> retrieveAccessViewContainer(EventSource<AccessEvent> eventSource) {
        return this.accessEventViewManager.retrieveViewContainer(eventSource);
    }

    public ApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public SortedMap<String, SourceIdentifier> getAvailableStatistics() {
        File statisticsPath = new File(this.applicationPreferences.getStartupApplicationPath(), "statistics");
        File[] files = statisticsPath.listFiles(this.rrdFileFilter);
        TreeMap<String, SourceIdentifier> sources = new TreeMap<String, SourceIdentifier>();
        if (files != null) {
            for (File f : files) {
                String name = f.getName();
                if ((name = name.substring(0, name.length() - 4)).equalsIgnoreCase("global")) continue;
                SourceIdentifier si = new SourceIdentifier(name);
                sources.put(this.getSourceTitle(si), si);
            }
        }
        return sources;
    }

    public void showStatistics(SourceIdentifier sourceIdentifier) {
        this.statisticsDialog.setSourceIdentifier(sourceIdentifier);
        Windows.showWindow((Window)this.statisticsDialog, (Window)this, (boolean)true);
    }

    public TaskManager<Long> getLongWorkManager() {
        return this.longTaskManager;
    }

    public LogFileFactory getAccessFileFactory() {
        return this.accessFileFactory;
    }

    public LogFileFactory getLoggingFileFactory() {
        return this.loggingFileFactory;
    }

    public void showLoggingView(EventSource<LoggingEvent> eventSource) {
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer(eventSource);
        this.showView(container);
    }

    public void showAccessView(EventSource<AccessEvent> eventSource) {
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer(eventSource);
        this.showView(container);
    }

    public void showView(ViewContainer<?> container) {
        ShowViewRunnable runnable = new ShowViewRunnable(container);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void openPreviousLogging(SourceIdentifier si) {
        FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)eventSource);
        EventWrapperViewPanel<LoggingEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showLoggingView((EventSource<LoggingEvent>)eventSource);
    }

    public void openPreviousAccess(SourceIdentifier si) {
        FileBuffer buffer = this.accessFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer((EventSource<AccessEvent>)eventSource);
        EventWrapperViewPanel<AccessEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showAccessView((EventSource<AccessEvent>)eventSource);
    }

    public void updateStatus() {
        StringBuilder statusText = new StringBuilder();
        ApplicationPreferences.SourceFiltering filtering = this.applicationPreferences.getSourceFiltering();
        switch (filtering) {
            case BLACKLIST: {
                statusText.append("Blacklisting on '");
                statusText.append(this.applicationPreferences.getBlackListName());
                statusText.append("'.  ");
                break;
            }
            case WHITELIST: {
                statusText.append("Whitelisting on '");
                statusText.append(this.applicationPreferences.getWhiteListName());
                statusText.append("'.  ");
            }
        }
        if (this.activeCounter == 0) {
            statusText.append("No active connections.");
        } else if (this.activeCounter == 1) {
            statusText.append("One active connection.");
        } else if (this.activeCounter > 1) {
            statusText.append(this.activeCounter).append(" active connections.");
        }
        this.statusLabel.setText(statusText.toString());
    }

    private void initDetailsViewScript() {
        long current = System.currentTimeMillis();
        if (this.detailsViewScript != null && current - this.lastScriptRefresh < 5000L) {
            return;
        }
        this.lastScriptRefresh = current;
        File detailsViewRoot = this.getApplicationPreferences().getDetailsViewRoot();
        File scriptFile = new File(detailsViewRoot, "detailsView.groovy");
        long scriptFileTimestamp = scriptFile.lastModified();
        if (this.detailsViewScript == null || this.previousScriptFileTimestamp != scriptFileTimestamp) {
            if (!scriptFile.isFile() && this.logger.isWarnEnabled()) {
                this.logger.warn("Scriptfile '{}' is not a file!", (Object)scriptFile.getAbsolutePath());
            }
            GroovyClassLoader gcl = new GroovyClassLoader();
            gcl.setShouldRecompile(Boolean.valueOf(true));
            try {
                Class clazz = gcl.parseClass(scriptFile);
                Object instance = clazz.newInstance();
                if (instance instanceof Script) {
                    this.detailsViewScript = (Script)instance;
                    this.previousScriptFileTimestamp = scriptFileTimestamp;
                }
            }
            catch (Throwable e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while instanciating groovy condition '" + scriptFile.getAbsolutePath() + "'!", e);
                }
                this.detailsViewScript = null;
            }
        }
    }

    public String createMessage(EventWrapper wrapper) {
        String message;
        block8: {
            this.initDetailsViewScript();
            message = "<html><body>detailsView Script returned null!</body></html>";
            if (this.detailsViewScript == null) {
                message = "<html><body>detailsView Script is broken!</body></html>";
            } else {
                try {
                    Binding binding = new Binding();
                    binding.setVariable("eventWrapper", (Object)wrapper);
                    binding.setVariable("logger", (Object)this.logger);
                    binding.setVariable("completeCallStack", (Object)this.applicationPreferences.isShowingFullCallstack());
                    binding.setVariable("showStackTrace", (Object)this.applicationPreferences.isShowingStackTrace());
                    this.detailsViewScript.setBinding(binding);
                    Object result = this.detailsViewScript.run();
                    if (result instanceof String) {
                        message = (String)result;
                    } else if (result != null) {
                        message = result.toString();
                    }
                }
                catch (Throwable t) {
                    message = "<html><body>Exception while executing detailsView Script!</body></html>";
                    if (!this.logger.isWarnEnabled()) break block8;
                    this.logger.warn("Exception while executing detailsView Script!", t);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message:\n{}", (Object)message);
        }
        message = SimpleXml.replaceNonValidXMLCharacters((String)message, (char)' ');
        return message;
    }

    public SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> getSortedLoggingViews() {
        EventSourceComparator loggingComparator = new EventSourceComparator();
        TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> sortedLoggingViews = new TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>>(loggingComparator);
        if (this.loggingEventViewManager != null) {
            sortedLoggingViews.putAll(this.loggingEventViewManager.getViews());
        }
        return sortedLoggingViews;
    }

    public SortedMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> getSortedAccessViews() {
        EventSourceComparator accessComparator = new EventSourceComparator();
        TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> sortedAccessViews = new TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>>(accessComparator);
        if (this.accessEventViewManager != null) {
            sortedAccessViews.putAll(this.accessEventViewManager.getViews());
        }
        return sortedAccessViews;
    }

    public void closeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.closeAllViews(beside);
        this.accessEventViewManager.closeAllViews(beside);
    }

    public void minimizeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.minimizeAllViews(beside);
        this.accessEventViewManager.minimizeAllViews(beside);
    }

    public void removeInactiveViews(boolean onlyClosed, boolean clean) {
        EventWrapperViewPanel panel;
        List removed = this.loggingEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
        removed = this.accessEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
    }

    public void openInactiveLogs() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Open inactive log...");
        }
        Windows.showWindow((Window)this.openInactiveLogsDialog, (Window)this, (boolean)true);
    }

    public void showDebugDialog() {
        Windows.showWindow((Window)this.debugDialog, (Window)this, (boolean)true);
    }

    public void showPreferencesDialog() {
        Windows.showWindow((Window)this.preferencesDialog, (Window)this, (boolean)true);
    }

    public void showHelp() {
        this.openHelp("index.xhtml");
    }

    public void showAboutDialog() {
        Windows.showWindow((Window)this.aboutDialog, (Window)this, (boolean)true);
        if (this.applicationPreferences.isMute() || this.sounds != null) {
            // empty if block
        }
    }

    public void cleanAllInactiveLogs() {
        this.loggingEventViewManager.removeInactiveViews(false);
        this.accessEventViewManager.removeInactiveViews(false);
        this.longTaskManager.startTask((Callable)((Object)new CleanAllInactiveCallable(this)), "Clean all inactive...");
        this.updateWindowMenus();
    }

    public String getPrimarySourceTitle(String primary) {
        if (primary == null) {
            return null;
        }
        Map<String, String> sourceNames = this.applicationPreferences.getSourceNames();
        String resolvedName = sourceNames.get(primary);
        if (resolvedName != null && !resolvedName.equals(primary)) {
            if (this.applicationPreferences.isShowingIdentifier()) {
                return resolvedName + " [" + primary + "]";
            }
            return resolvedName;
        }
        return primary;
    }

    public String getPrimarySourceTitle(SourceIdentifier identifier) {
        return this.getPrimarySourceTitle(identifier.getIdentifier());
    }

    public String getSourceTitle(SourceIdentifier identifier) {
        String primary = this.getPrimarySourceTitle(identifier);
        String secondary = identifier.getSecondaryIdentifier();
        if (secondary == null) {
            return primary;
        }
        return primary + " - " + secondary;
    }

    public String getLoggingSourceTitle(SourceIdentifier identifier) {
        return this.getSourceTitle(identifier) + " (Logging)";
    }

    public String getAccessSourceTitle(SourceIdentifier identifier) {
        return this.getSourceTitle(identifier) + " (Access)";
    }

    String resolveSourceTitle(ViewContainer container) {
        EventSource eventSource = container.getDefaultView().getEventSource();
        SourceIdentifier si = eventSource.getSourceIdentifier();
        Class clazz = container.getWrappedClass();
        String title = clazz == LoggingEvent.class ? this.getLoggingSourceTitle(si) : this.getAccessSourceTitle(si);
        return title;
    }

    public void openUrl(URL url) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opening URL {}. ", url);
        }
        Runtime runtime = Runtime.getRuntime();
        String[] cmdArray = this.getOpenUrlCommandArray(url);
        if (cmdArray != null) {
            try {
                Process process = runtime.exec(cmdArray);
                ProcessConsumerRunnable consumer = new ProcessConsumerRunnable(process);
                Thread t = new Thread((Runnable)consumer, "Open URL: " + url);
                t.setDaemon(true);
                t.start();
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while trying to open URL " + url + "!", e);
                }
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Can't open url {} because no command is defined for the current system.", url);
        }
    }

    private String[] getOpenUrlCommandArray(URL url) {
        String[] result = null;
        if (this.isWindows) {
            result = new String[WINDOWS_OPEN_URL_ARRAY.length];
            System.arraycopy(WINDOWS_OPEN_URL_ARRAY, 0, result, 0, WINDOWS_OPEN_URL_ARRAY.length);
        } else if (this.isMac) {
            result = new String[MAC_OPEN_URL_ARRAY.length];
            System.arraycopy(MAC_OPEN_URL_ARRAY, 0, result, 0, MAC_OPEN_URL_ARRAY.length);
        }
        if (result != null) {
            String urlStr = url.toString();
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != null) continue;
                result[i] = urlStr;
            }
        }
        return result;
    }

    void showFrame(ViewContainer container) {
        String title = this.resolveSourceTitle(container);
        ViewContainerFrame frame = new ViewContainerFrame(this, container);
        frame.setShowingToolbar(this.applicationPreferences.isShowingToolbar());
        frame.setShowingStatusbar(this.applicationPreferences.isShowingStatusbar());
        frame.setTitle(title);
        frame.setSize(800, 600);
        Windows.showWindow((Window)frame, null, (boolean)false);
        this.executeScrollToBottom(frame);
    }

    void showInternalFrame(ViewContainer container) {
        String title = this.resolveSourceTitle(container);
        ViewContainerInternalFrame frame = new ViewContainerInternalFrame(this, container);
        frame.setShowingStatusbar(this.applicationPreferences.isShowingStatusbar());
        frame.setTitle(title);
        int count = this.desktop.getComponentCount();
        int titleBarHeight = this.resolveInternalTitlebarHeight();
        frame.setBounds(titleBarHeight * (count % 10), titleBarHeight * (count % 10), 640, 480);
        this.desktop.add(frame);
        this.viewActions.setViewContainer(container);
        frame.setVisible(true);
        this.executeScrollToBottom(frame);
    }

    public void showTaskManager() {
        if (this.taskManagerFrame.isClosed()) {
            this.desktop.add(this.taskManagerFrame);
            this.desktop.validate();
        }
        if (this.taskManagerFrame.isIcon()) {
            try {
                this.taskManagerFrame.setIcon(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        if (!this.taskManagerFrame.isVisible()) {
            this.taskManagerFrame.setVisible(true);
        }
        this.taskManagerFrame.moveToFront();
        try {
            this.taskManagerFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void executeScrollToBottom(ViewWindow window) {
        if (window != null) {
            ScrollToBottomRunnable runnable = new ScrollToBottomRunnable(window);
            SwingUtilities.invokeLater(runnable);
        }
    }

    private int resolveInternalTitlebarHeight() {
        int result = 24;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Height of titlebar: {}", result);
        }
        return result;
    }

    private void showApplicationPathChangedDialog() {
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("showApplicationPathChangedDialog()");
        }
        Object[] options = new Object[]{"Exit", "Cancel"};
        ImageIcon icon = null;
        URL url = MainFrame.class.getResource("/tango/32x32/status/dialog-warning.png");
        if (url != null) {
            icon = new ImageIcon(url);
        }
        if ((result = JOptionPane.showOptionDialog(this, "You have changed the application path.\nYou need to restart for this change to take effect.\n\nExit now?", "Exit now?", -1, 2, icon, options, options[0])) == 0) {
            this.exit();
        }
    }

    private void showLookAndFeelChangedDialog() {
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("showLookAndFeelChangedDialog()");
        }
        Object[] options = new Object[]{"Exit", "Cancel"};
        ImageIcon icon = null;
        URL url = MainFrame.class.getResource("/tango/32x32/status/dialog-warning.png");
        if (url != null) {
            icon = new ImageIcon(url);
        }
        if ((result = JOptionPane.showOptionDialog(this, "You have changed the look & feel.\nYou need to restart for this change to take effect.\n\nExit now?", "Exit now?", -1, 2, icon, options, options[0])) == 0) {
            this.exit();
        }
    }

    public void exit() {
        String dialogTitle;
        String message;
        int result;
        if (this.applicationPreferences.isAskingBeforeQuit() && 0 != (result = JOptionPane.showConfirmDialog(this, message = "Are you really 100% sure that you want to quit?\nPlease do yourself a favour and think about it before you answer...\nExit now?", dialogTitle = "Exit now?", 2, 3))) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Exiting...");
        }
        if (this.senderService != null) {
            this.senderService.stop();
        }
        if (this.applicationPreferences.isCleaningLogsOnExit()) {
            this.deleteInactiveLogs();
        }
        this.applicationPreferences.setPreviousImportPath(this.importFileChooser.getCurrentDirectory());
        this.applicationPreferences.setPreviousOpenPath(this.openFileChooser.getCurrentDirectory());
        this.applicationPreferences.flush();
        this.longTaskManager.shutDown();
        System.exit(0);
    }

    private void setGlobalLoggingEnabled(boolean globalLoggingEnabled) {
        this.loggingFileDump.setEnabled(globalLoggingEnabled);
        this.accessFileDump.setEnabled(globalLoggingEnabled);
    }

    private void setStatisticsEnabled(boolean statisticsEnabled) {
        this.rrdLoggingEventConsumer.setEnabled(statisticsEnabled);
    }

    private void setCheckingForUpdate(boolean checkingForUpdate) {
        this.preferencesDialog.setCheckingForUpdate(checkingForUpdate);
        this.checkForUpdateDialog.setCheckingForUpdate(checkingForUpdate);
    }

    private void setShowingStatusbar(boolean showingStatusbar) {
        this.statusBar.setVisible(showingStatusbar);
        SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> views = this.getSortedLoggingViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingStatusbar(current.getValue(), showingStatusbar);
        }
        views = this.getSortedAccessViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingStatusbar(current.getValue(), showingStatusbar);
        }
    }

    private void setShowingTipOfTheDay(boolean showingTipOfTheDay) {
        this.preferencesDialog.setShowingTipOfTheDay(showingTipOfTheDay);
        this.tipOfTheDayDialog.setShowingTipOfTheDay(showingTipOfTheDay);
    }

    private void setShowingToolbar(boolean showingToolbar) {
        this.toolbar.setVisible(showingToolbar);
        SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> views = this.getSortedLoggingViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingToolbar(current.getValue(), showingToolbar);
        }
        views = this.getSortedAccessViews();
        for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> current : views.entrySet()) {
            this.setShowingToolbar(current.getValue(), showingToolbar);
        }
    }

    private void setShowingToolbar(ViewContainer container, boolean showingToolbar) {
        ViewWindow viewWindow = container.resolveViewWindow();
        if (viewWindow instanceof ViewContainerFrame) {
            ViewContainerFrame viewContainerFrame = (ViewContainerFrame)viewWindow;
            viewContainerFrame.setShowingToolbar(showingToolbar);
        }
    }

    private void setShowingStatusbar(ViewContainer container, boolean showingStatusbar) {
        ViewWindow viewWindow = container.resolveViewWindow();
        if (viewWindow != null) {
            viewWindow.setShowingStatusbar(showingStatusbar);
        }
    }

    private void updatePreviousSearchStrings() {
        ViewContainer value;
        List<String> previousSearchStrings = this.applicationPreferences.getPreviousSearchStrings();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            value = current.getValue();
            value.setPreviousSearchStrings(previousSearchStrings);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            value = current.getValue();
            value.setPreviousSearchStrings(previousSearchStrings);
        }
    }

    private void updateConditions() {
        ViewContainer value;
        List<SavedCondition> conditions = this.applicationPreferences.getConditions();
        ArrayList<SavedCondition> active = new ArrayList<SavedCondition>();
        if (conditions != null) {
            for (SavedCondition current : conditions) {
                if (!current.isActive()) continue;
                active.add(current);
            }
        }
        this.activeConditions = active;
        this.updateAllViews();
        List<String> conditionNames = this.applicationPreferences.getConditionNames();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            value = current.getValue();
            value.setConditionNames(conditionNames);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            value = current.getValue();
            value.setConditionNames(conditionNames);
        }
    }

    private void updateViewScale(double scale) {
        ViewContainer value;
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            value = current.getValue();
            value.updateViewScale(scale);
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            value = current.getValue();
            value.updateViewScale(scale);
        }
    }

    private void updateLoggingViews() {
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            value.updateViews();
        }
    }

    private void updateAccessViews() {
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            value.updateViews();
        }
    }

    private void updateAllViews() {
        this.updateLoggingViews();
        this.updateAccessViews();
    }

    public void cleanObsoleteFiles() {
        File obsoleteDir = new File(this.startupApplicationPath, "sources");
        if (obsoleteDir.isDirectory()) {
            this.longTaskManager.startTask((Callable)((Object)new CleanObsoleteCallable(obsoleteDir)), "Clean obsolete files", "Deletes the directory '" + obsoleteDir.getAbsolutePath() + "' recursively.");
        }
    }

    public void deleteInactiveLogs() {
        this.deleteInactiveLogs(this.loggingFileFactory);
        this.deleteInactiveLogs(this.accessFileFactory);
    }

    protected void deleteInactiveLogs(LogFileFactory fileFactory) {
        List<SourceIdentifier> inactives = this.collectInactiveLogs(fileFactory);
        for (SourceIdentifier si : inactives) {
            File dataFile = fileFactory.getDataFile(si);
            File indexFile = fileFactory.getIndexFile(si);
            if (dataFile.delete() && this.logger.isInfoEnabled()) {
                this.logger.info("Deleted {}", dataFile);
            }
            if (!indexFile.delete() || !this.logger.isInfoEnabled()) continue;
            this.logger.info("Deleted {}", indexFile);
        }
    }

    public List<SourceIdentifier> collectInactiveLogs(LogFileFactory fileFactory) {
        ArrayList<SourceIdentifier> result = new ArrayList<SourceIdentifier>();
        File logsRoot = fileFactory.getBaseDir();
        File[] sources = logsRoot.listFiles(new DirectoryFilter());
        if (sources != null) {
            for (File f : sources) {
                this.collectInactiveLogs(fileFactory, f, result);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Inactive logs: {}", result);
            }
        }
        return result;
    }

    private void collectInactiveLogs(LogFileFactory fileFactory, File sourceDir, List<SourceIdentifier> inactiveLogs) {
        String primary = sourceDir.getName();
        File[] logs = sourceDir.listFiles(new LogFileFilter(fileFactory));
        String extension = fileFactory.getDataFileExtension();
        for (File f : logs) {
            String abs = f.getAbsolutePath();
            File active = new File((abs = abs.substring(0, abs.length() - extension.length())) + ".active");
            if (active.isFile()) continue;
            String secondary = f.getName();
            secondary = secondary.substring(0, secondary.length() - extension.length());
            inactiveLogs.add(new SourceIdentifier(primary, secondary));
        }
    }

    public void copyText(String text) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferableText = new StringSelection(text);
        systemClipboard.setContents(transferableText, null);
    }

    private void showUpdateDialog(String message, String changes) {
        this.checkForUpdateDialog.setMessage(message);
        this.checkForUpdateDialog.setChanges(changes);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Check for update: message='{}', changes='{}'", (Object)message, (Object)changes);
        }
        Windows.showWindow((Window)this.checkForUpdateDialog, (Window)this, (boolean)true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MainTaskListener
    implements TaskListener<Long> {
        private final Logger logger = LoggerFactory.getLogger(MainTaskListener.class);

        private MainTaskListener() {
        }

        public void taskCreated(Task<Long> longTask) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Task " + longTask.getName() + " created.");
            }
            MainFrame.this.updateTaskStatus();
        }

        public void executionFailed(Task<Long> longTask, ExecutionException exception) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Execution of task " + longTask.getName() + " failed!", exception);
            }
            MainFrame.this.updateTaskStatus();
        }

        public void executionFinished(Task<Long> longTask, Long result) {
            JulImportCallable iCallable;
            AppendOperation buffer;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Execution of task " + longTask.getName() + " finished!");
            }
            MainFrame.this.updateTaskStatus();
            Callable callable = longTask.getCallable();
            if (callable instanceof IndexingCallable) {
                IndexingCallable iCallable2 = (IndexingCallable)((Object)callable);
                File dataFile = iCallable2.getDataFile();
                File indexFile = iCallable2.getIndexFile();
                MainFrame.this.createViewFor(dataFile, indexFile);
                return;
            }
            if (callable instanceof Log4jImportCallable) {
                Log4jImportCallable iCallable3 = (Log4jImportCallable)callable;
                AppendOperation buffer2 = iCallable3.getBuffer();
                if (buffer2 instanceof CodecFileBuffer) {
                    CodecFileBuffer cfb = (CodecFileBuffer)buffer2;
                    File dataFile = cfb.getDataFile();
                    File indexFile = cfb.getIndexFile();
                    cfb.dispose();
                    MainFrame.this.createViewFor(dataFile, indexFile);
                }
                return;
            }
            if (callable instanceof JulImportCallable && (buffer = (iCallable = (JulImportCallable)callable).getBuffer()) instanceof CodecFileBuffer) {
                CodecFileBuffer cfb = (CodecFileBuffer)buffer;
                File dataFile = cfb.getDataFile();
                File indexFile = cfb.getIndexFile();
                cfb.dispose();
                MainFrame.this.createViewFor(dataFile, indexFile);
            }
        }

        public void executionCanceled(Task<Long> longTask) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Execution of task " + longTask.getName() + " canceled!");
            }
            MainFrame.this.updateTaskStatus();
        }

        public void progressUpdated(Task<Long> longTask, int progress) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Progress of task " + longTask.getName() + " updated to " + progress + ".");
            }
            MainFrame.this.updateTaskStatus();
        }
    }

    private class ShowUpdateDialog
    implements Runnable {
        private String message;
        private String changes;

        public ShowUpdateDialog(String message, String changes) {
            this.message = message;
            this.changes = changes;
        }

        public void run() {
            MainFrame.this.showUpdateDialog(this.message, this.changes);
        }
    }

    private class CheckForUpdateRunnable
    implements Runnable {
        private boolean showAlways;

        public CheckForUpdateRunnable(boolean showAlways) {
            this.showAlways = showAlways;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String retrieveCurrentVersion() {
            String url = "http://lilith.huxhorn.de/current-version.txt";
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod("http://lilith.huxhorn.de/current-version.txt");
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            String currentVersion = null;
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != HttpStatus.OK.getCode()) {
                    System.err.println("Method failed: " + method.getStatusLine());
                } else {
                    byte[] responseBody = method.getResponseBody();
                    String charSet = method.getResponseCharSet();
                    currentVersion = new String(responseBody, charSet).trim();
                }
            }
            catch (Throwable e) {
                if (MainFrame.this.logger.isInfoEnabled()) {
                    MainFrame.this.logger.info("Exception while checking current version!", e);
                }
            }
            finally {
                method.releaseConnection();
            }
            return currentVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String retrieveChanges(String currentVersion) {
            String url = "http://lilith.huxhorn.de/releases/" + currentVersion + ".xhtml";
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            String changes = null;
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != HttpStatus.OK.getCode()) {
                    System.err.println("Method failed: " + method.getStatusLine());
                } else {
                    byte[] responseBody = method.getResponseBody();
                    String charSet = method.getResponseCharSet();
                    changes = new String(responseBody, charSet).trim();
                }
            }
            catch (Throwable e) {
                if (MainFrame.this.logger.isInfoEnabled()) {
                    MainFrame.this.logger.info("Exception while checking current version!", e);
                }
            }
            finally {
                method.releaseConnection();
            }
            return changes;
        }

        public void run() {
            String message;
            String currentVersion = this.retrieveCurrentVersion();
            String changes = null;
            boolean newVersion = false;
            if (currentVersion == null) {
                message = "Couldn't retrieve current version!";
            } else if (!currentVersion.equals(Lilith.APP_VERSION)) {
                message = "New version is available: " + currentVersion;
                newVersion = true;
                changes = this.retrieveChanges(currentVersion);
            } else {
                message = null;
                if (this.showAlways) {
                    changes = this.retrieveChanges(currentVersion);
                }
            }
            if (MainFrame.this.logger.isDebugEnabled()) {
                MainFrame.this.logger.debug("Message: {}, newVersion: {}", (Object)message, (Object)newVersion);
            }
            if (newVersion || this.showAlways) {
                SwingUtilities.invokeLater(new ShowUpdateDialog(message, changes));
            }
        }
    }

    public static class ProcessConsumerRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private Process process;

        public ProcessConsumerRunnable(Process process) {
            this.process = process;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block3: {
                try {
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Execution finished with exitCode {}.", exitCode);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug("Execution of openUrl process was interrupted.", e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println("openUrl: " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (ProcessConsumerRunnable.this.logger.isDebugEnabled()) {
                    ProcessConsumerRunnable.this.logger.debug("{}", (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!ProcessConsumerRunnable.this.logger.isDebugEnabled()) break block3;
                        ProcessConsumerRunnable.this.logger.debug("Exception while reading from openUrl process.", e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    public static class AutostartRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private File file;
        private Process process;

        public AutostartRunnable(File file) {
            this.file = file;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block6: {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Starting '{}'.", (Object)this.file.getAbsolutePath());
                    }
                    this.process = Runtime.getRuntime().exec(this.file.getAbsolutePath());
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Execution of '{}' finished with exitCode {}.", (Object)this.file.getAbsolutePath(), (Object)exitCode);
                    }
                }
                catch (IOException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception while executing '" + this.file.getAbsolutePath() + "'!", e);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Execution of '" + this.file.getAbsolutePath() + "' was interrupted.", e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println(AutostartRunnable.this.file.getAbsolutePath() + ": " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (AutostartRunnable.this.logger.isInfoEnabled()) {
                    AutostartRunnable.this.logger.info("{}: {}", (Object)AutostartRunnable.this.file.getAbsolutePath(), (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!AutostartRunnable.this.logger.isDebugEnabled()) break block3;
                        AutostartRunnable.this.logger.debug("Exception while reading from process '" + AutostartRunnable.this.file.getAbsolutePath() + "'.", e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    private class ShutdownRunnable
    implements Runnable {
        private ShutdownRunnable() {
        }

        public void run() {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Executing shutdown hook...");
            }
            if (MainFrame.this.gotoSource != null) {
                MainFrame.this.gotoSource.stop();
                MainFrame.this.gotoSource = null;
            }
            for (AutostartRunnable current : MainFrame.this.autostartProcesses) {
                current.destroyProcess();
            }
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Finished executing shutdown hook...");
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            MainFrame.this.exit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventSourceComparator<T extends Serializable>
    implements Comparator<EventSource<T>> {
        @Override
        public int compare(EventSource<T> o1, EventSource<T> o2) {
            int compare;
            SourceIdentifier si2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            SourceIdentifier si1 = o1.getSourceIdentifier();
            if (si1 == (si2 = o2.getSourceIdentifier())) {
                return 0;
            }
            if (si1 == null) {
                return -1;
            }
            if (si2 == null) {
                return 1;
            }
            String primary1 = MainFrame.this.getPrimarySourceTitle(si1);
            String primary2 = MainFrame.this.getPrimarySourceTitle(si2);
            if (primary1 != null && primary2 != null && (compare = primary1.compareTo(primary2)) != 0) {
                return compare;
            }
            return o1.compareTo(o2);
        }
    }

    private class PreferencesChangeListener
    implements PropertyChangeListener {
        private PreferencesChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName;
            block27: {
                propName = evt.getPropertyName();
                if ("soundLocations".equals(propName)) {
                    if (MainFrame.this.sounds != null) {
                        MainFrame.this.sounds.setSoundLocations((Map)evt.getNewValue());
                    }
                    return;
                }
                if ("sourceNames".equals(propName) || "showingIdentifier".equals(propName)) {
                    this.updateSourceTitles();
                    return;
                }
                if ("sourceFiltering".equals(propName)) {
                    MainFrame.this.updateStatus();
                    return;
                }
                if ("mute".equals(propName)) {
                    if (MainFrame.this.sounds != null) {
                        MainFrame.this.sounds.setMute(((Boolean)evt.getNewValue()).booleanValue());
                    }
                    return;
                }
                if (!"applicationPath".equals(propName)) break block27;
                File newPath = (File)evt.getNewValue();
                File oldPath = MainFrame.this.applicationPreferences.getStartupApplicationPath();
                if (oldPath != null) {
                    File previousApplicationPathFile = new File(newPath, ".previous.application.path");
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(previousApplicationPathFile);
                        writer.append(oldPath.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        block26: {
                            try {
                                if (!MainFrame.this.logger.isWarnEnabled()) break block26;
                                MainFrame.this.logger.warn("Exception while writing previous application path to file '" + previousApplicationPathFile.getAbsolutePath() + "'!", ex);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(writer);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Writer)writer);
                    }
                    IOUtils.closeQuietly((Writer)writer);
                }
                MainFrame.this.showApplicationPathChangedDialog();
                return;
            }
            if ("lookAndFeel".equals(propName)) {
                MainFrame.this.showLookAndFeelChangedDialog();
                return;
            }
            if ("conditions".equals(propName)) {
                MainFrame.this.updateConditions();
                return;
            }
            if ("previousSearchStrings".equals(propName)) {
                MainFrame.this.updatePreviousSearchStrings();
                return;
            }
            if ("levelColors".equals(propName)) {
                MainFrame.this.levelColors = null;
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("statusColors".equals(propName)) {
                MainFrame.this.statusColors = null;
                MainFrame.this.updateAccessViews();
                return;
            }
            if ("showingFullCallstack".equals(propName)) {
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("showingStackTrace".equals(propName)) {
                MainFrame.this.updateLoggingViews();
                return;
            }
            if ("scaleFactor".equals(propName)) {
                MainFrame.this.updateViewScale(MainFrame.this.applicationPreferences.getScaleFactor());
                return;
            }
            if ("showingToolbar".equals(propName)) {
                MainFrame.this.setShowingToolbar(MainFrame.this.applicationPreferences.isShowingToolbar());
                return;
            }
            if ("showingStatusbar".equals(propName)) {
                MainFrame.this.setShowingStatusbar(MainFrame.this.applicationPreferences.isShowingStatusbar());
                return;
            }
            if ("showingTipOfTheDay".equals(propName)) {
                MainFrame.this.setShowingTipOfTheDay(MainFrame.this.applicationPreferences.isShowingTipOfTheDay());
                return;
            }
            if ("checkingForUpdate".equals(propName)) {
                MainFrame.this.setCheckingForUpdate(MainFrame.this.applicationPreferences.isCheckingForUpdate());
                return;
            }
            if ("globalLoggingEnabled".equals(propName)) {
                MainFrame.this.setGlobalLoggingEnabled(MainFrame.this.applicationPreferences.isGlobalLoggingEnabled());
                return;
            }
            if ("loggingStatisticEnabled".equals(propName)) {
                MainFrame.this.setStatisticsEnabled(MainFrame.this.applicationPreferences.isLoggingStatisticEnabled());
                return;
            }
            if ("coloringWholeRow".equals(propName)) {
                MainFrame.this.coloringWholeRow = MainFrame.this.applicationPreferences.isColoringWholeRow();
                MainFrame.this.updateLoggingViews();
            }
        }

        private void updateSourceTitles() {
            MainFrame.this.updateWindowMenus();
            Map loggingViews = MainFrame.this.loggingEventViewManager.getViews();
            for (Map.Entry current : loggingViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
            Map accessViews = MainFrame.this.accessEventViewManager.getViews();
            for (Map.Entry current : accessViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowViewRunnable
    implements Runnable {
        private ViewContainer<?> container;

        public ShowViewRunnable(ViewContainer<?> container) {
            this.container = container;
        }

        @Override
        public void run() {
            boolean isNew = false;
            boolean isInternal = false;
            if (this.container.getParent() == null) {
                isNew = true;
                if (!MainFrame.this.applicationPreferences.isUsingInternalFrames()) {
                    MainFrame.this.showFrame(this.container);
                } else {
                    MainFrame.this.showInternalFrame(this.container);
                }
            }
            MainFrame.this.updateWindowMenus();
            ViewWindow window = this.container.resolveViewWindow();
            if (window instanceof ViewContainerInternalFrame) {
                isInternal = true;
            }
            if (isNew) {
                if (MainFrame.this.applicationPreferences.isAutoFocusingWindow()) {
                    window.focusWindow();
                    if (isInternal) {
                        if ((MainFrame.this.getState() & 1) != 0) {
                            MainFrame.this.setState(0);
                        }
                        MainFrame.this.toFront();
                    }
                }
            } else {
                window.focusWindow();
                if (isInternal) {
                    MainFrame.this.toFront();
                }
            }
        }
    }

    private static class ScrollToBottomRunnable
    implements Runnable {
        private ViewWindow window;

        private ScrollToBottomRunnable(ViewWindow window) {
            this.window = window;
        }

        public void run() {
            ViewContainer viewContainer = this.window.getViewContainer();
            if (viewContainer != null) {
                viewContainer.scrollToEvent();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessEventSourceListener
    implements EventSourceListener<AccessEvent> {
        AccessEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceRemovedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceRemovedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.accessEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.accessEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceAddedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceAddedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showAccessView(this.eventSource);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingEventSourceListener
    implements EventSourceListener<LoggingEvent> {
        LoggingEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceRemovedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceRemovedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.loggingEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.loggingEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceAddedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceAddedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showLoggingView(this.eventSource);
                }
            }
        }
    }

    public class MyApplicationListener
    implements ApplicationListener {
        public void handleAbout(ApplicationEvent event) {
            MainFrame.this.viewActions.getAboutAction().actionPerformed(null);
            event.setHandled(true);
        }

        public void handleOpenApplication(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isDebugEnabled()) {
                MainFrame.this.logger.debug("Open Application: {}", applicationEvent);
            }
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isDebugEnabled()) {
                MainFrame.this.logger.debug("Open File: {}", applicationEvent);
            }
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            MainFrame.this.viewActions.getPreferencesAction().actionPerformed(null);
        }

        public void handlePrintFile(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isDebugEnabled()) {
                MainFrame.this.logger.debug("Print: {}", applicationEvent);
            }
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            MainFrame.this.exit();
        }

        public void handleReopenApplication(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isDebugEnabled()) {
                MainFrame.this.logger.debug("Reopen Application: {}", applicationEvent);
            }
            MainFrame.this.setVisible(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportType {
        LOG4J,
        JUL;

    }
}

