/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.linklistener.OpenUrlLinkListener;
import de.huxhorn.lilith.swing.xhtml.EnhancedXHTMLPanel;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.SelectionHighlighter;

public class HelpFrame
extends JFrame {
    private final Logger logger = LoggerFactory.getLogger(HelpFrame.class);
    private EnhancedXHTMLPanel helpPane;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private MainFrame mainFrame;
    private SelectionHighlighter.CopyAction copyAction;
    private JPopupMenu popup;

    public HelpFrame(MainFrame mainFrame) throws HeadlessException {
        this.mainFrame = mainFrame;
        this.setDefaultCloseOperation(1);
        this.initUI();
    }

    private void initUI() {
        this.helpPane = new EnhancedXHTMLPanel();
        URL baseUrl = HelpFrame.class.getResource("/help");
        String baseUrlString = baseUrl.toString() + "/";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Help Base-URL: {}", (Object)baseUrlString);
        }
        this.helpPane.getSharedContext().setBaseURL(baseUrlString);
        LinkListener originalLinkListener = null;
        List mouseTrackingList = this.helpPane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.helpPane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
                originalLinkListener = (LinkListener)o;
            }
        }
        this.helpPane.addMouseTrackingListener((FSMouseListener)new OpenUrlLinkListener(this.mainFrame, originalLinkListener));
        SelectionHighlighter helpPaneCaret = new SelectionHighlighter();
        helpPaneCaret.install((XHTMLPanel)this.helpPane);
        this.copyAction = new SelectionHighlighter.CopyAction();
        this.copyAction.install(helpPaneCaret);
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
        FSScrollPane helpScrollPane = new FSScrollPane((JPanel)((Object)this.helpPane));
        this.setContentPane((Container)helpScrollPane);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        this.setSize(maxBounds.width / 2, maxBounds.height / 2);
        URL url = HelpFrame.class.getResource("/tango/16x16/apps/help-browser.png");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            this.setIconImage(icon.getImage());
        }
        CopySelectionAction copySelectionAction = new CopySelectionAction();
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(copySelectionAction);
        menuBar.add(editMenu);
        this.setJMenuBar(menuBar);
        this.popup = new JPopupMenu();
        this.popup.add(copySelectionAction);
        this.helpPane.addMouseListener(new PopupMouseListener());
    }

    private void showPopup(MouseEvent evt) {
        Point p = evt.getPoint();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Show popup at {}.", p);
        }
        this.popup.show((Component)((Object)this.helpPane), p.x, p.y);
    }

    public void copySelection() {
        this.copyAction.actionPerformed(null);
    }

    public void setHelpUrl(String helpUrl) {
        this.helpPane.setDocumentRelative(helpUrl);
        this.helpPane.relayout();
        int hashIndex = helpUrl.indexOf(35);
        if (hashIndex > -1) {
            helpUrl = helpUrl.substring(hashIndex);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Jumping to anchor: '{}'", (Object)helpUrl);
            }
            this.helpPane.setDocumentRelative(helpUrl);
        }
    }

    private class CopySelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -551520865313383753L;

        public CopySelectionAction() {
            super("Copy selection");
            this.putValue("ShortDescription", "Copies the selection to the clipboard.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command C");
            if (HelpFrame.this.logger.isDebugEnabled()) {
                HelpFrame.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            HelpFrame.this.copySelection();
        }
    }

    private class PopupMouseListener
    implements MouseListener {
        private PopupMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                HelpFrame.this.showPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                HelpFrame.this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                HelpFrame.this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

