/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.conditions.CallLocationCondition;
import de.huxhorn.lilith.conditions.EventContainsCondition;
import de.huxhorn.lilith.conditions.GroovyCondition;
import de.huxhorn.lilith.conditions.LevelCondition;
import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.LoggerEqualsCondition;
import de.huxhorn.lilith.conditions.LoggerStartsWithCondition;
import de.huxhorn.lilith.conditions.MessageContainsCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.Not;
import de.huxhorn.sulky.swing.KeyStrokes;
import de.huxhorn.sulky.swing.ListComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindPanel<T extends Serializable>
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(FindPanel.class);
    private static final String GROOVY_IDENTIFIER = "#groovy#";
    private static final String SAVED_CONDITION_IDENTIFIER = "#condition#";
    private static final Color ERROR_COLOR = new Color(0x990000);
    private static final Color NO_ERROR_COLOR = Color.BLACK;
    private static final String EVENT_CONTAINS_CONDITION = "event.contains";
    private static final String MESSAGE_CONTAINS_CONDITION = "message.contains";
    private static final String LOGGER_STARTS_WITH_CONDITION = "logger.startsWith";
    private static final String LOGGER_EQUALS_CONDITION = "logger.equals";
    private static final String LEVEL_CONDITION = "Level>=";
    private static final String CALL_LOCATION_CONDITION = "CallLocation";
    private static final String NAMED_CONDITION = "Named";
    private static final String[] DEFAULT_CONDITIONS = new String[]{"event.contains", "message.contains", "logger.startsWith", "logger.equals", "Level>=", "CallLocation", "Named"};
    public static final String CONDITION_PROPERTY = "condition";
    private MainFrame mainFrame;
    private EventWrapperViewPanel<T> eventWrapperViewPanel;
    private FindNextAction findNextAction;
    private FindPreviousAction findPrevAction;
    private CloseFindAction closeFindAction;
    private JButton closeFindButton;
    private JToggleButton findNotButton;
    private JComboBox findTypeCombo;
    private JComboBox findTextCombo;
    private JButton findPrevButton;
    private JButton findNextButton;
    private Condition condition;
    private ListComboBoxModel findComboModel;
    private static final String[] LEVEL_VALUES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR"};
    private ApplicationPreferences applicationPreferences;
    private List<String> previousSearchStrings;
    private List<String> conditionNames;

    public FindPanel(EventWrapperViewPanel<T> eventWrapperViewPanel) {
        this.eventWrapperViewPanel = eventWrapperViewPanel;
        this.mainFrame = this.eventWrapperViewPanel.getMainFrame();
        this.applicationPreferences = this.mainFrame.getApplicationPreferences();
        this.previousSearchStrings = this.applicationPreferences.getPreviousSearchStrings();
        this.conditionNames = this.applicationPreferences.getConditionNames();
        this.initUi();
    }

    private void initUi() {
        this.closeFindAction = new CloseFindAction();
        this.closeFindButton = new JButton(this.closeFindAction);
        this.closeFindButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.closeFindButton, gbc);
        gbc.gridx = 1;
        this.add((Component)new JLabel(" Find: "), gbc);
        FindTypeSelectionActionListener findTypeModifiedListener = new FindTypeSelectionActionListener();
        this.findTypeCombo = new JComboBox();
        AutoCompleteDecorator.decorate((JComboBox)this.findTypeCombo);
        this.findTypeCombo.addActionListener(findTypeModifiedListener);
        this.findNotButton = new JToggleButton("!");
        this.findNotButton.addActionListener(findTypeModifiedListener);
        this.findNotButton.setToolTipText("Not - inverts condition");
        this.findNotButton.setMargin(new Insets(0, 0, 0, 0));
        this.findTextCombo = new JComboBox();
        this.findTextCombo.setEditable(true);
        this.findComboModel = new ListComboBoxModel();
        this.findTextCombo.setModel(this.findComboModel);
        AutoCompleteDecorator.decorate((JComboBox)this.findTextCombo);
        gbc.gridx = 2;
        gbc.fill = 3;
        this.add((Component)this.findNotButton, gbc);
        gbc.gridx = 3;
        gbc.fill = 3;
        this.add((Component)this.findTypeCombo, gbc);
        gbc.gridx = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.findTextCombo, gbc);
        this.findPrevAction = new FindPreviousAction();
        this.findPrevButton = new JButton(this.findPrevAction);
        this.findPrevButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)this.findPrevButton, gbc);
        this.findNextAction = new FindNextAction();
        this.findNextButton = new JButton(this.findNextAction);
        this.findNextButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 6;
        this.add((Component)this.findNextButton, gbc);
        FindTextFieldListener findTextFieldListener = new FindTextFieldListener();
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent instanceof JTextField) {
            ((JTextField)findEditorComponent).addActionListener(findTextFieldListener);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("findEditorComponent ({}) is not instanceof JTextField!", (Object)findEditorComponent.getClass().getName());
        }
        if (findEditorComponent != null) {
            findEditorComponent.getDocument().addDocumentListener(findTextFieldListener);
            findEditorComponent.setForeground(NO_ERROR_COLOR);
        }
        ReplaceFilterAction replaceFilterAction = new ReplaceFilterAction();
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findNextAction, (String)"FIND_NEXT_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findPrevAction, (String)"FIND_PREV_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.closeFindAction, (String)"CLOSE_FIND_ACTION");
        KeyStrokes.registerCommand((JComponent)this.findTextCombo, (Action)replaceFilterAction, (String)"REPLACE_FILTER_ACTION");
        MyFocusTraversalPolicy focusTraversalPolicy = new MyFocusTraversalPolicy();
        this.setFocusTraversalPolicy(focusTraversalPolicy);
        this.setFocusCycleRoot(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusable(true);
    }

    private void setCondition(Condition condition) {
        Condition oldValue;
        block2: {
            oldValue = this.getCondition();
            try {
                this.condition = condition != null ? condition.clone() : null;
            }
            catch (CloneNotSupportedException e) {
                this.condition = null;
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Condition " + condition + " does not support cloning!", e);
            }
        }
        Condition newValue = this.getCondition();
        this.findPrevAction.setEnabled(this.condition != null);
        this.findNextAction.setEnabled(this.condition != null);
        this.firePropertyChange(CONDITION_PROPERTY, oldValue, newValue);
    }

    public Condition getCondition() {
        if (this.condition == null) {
            return null;
        }
        try {
            return this.condition.clone();
        }
        catch (CloneNotSupportedException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Condition " + this.condition + " does not support cloning!", e);
            }
            return null;
        }
    }

    private void updateCondition() {
        this.setCondition(this.createCondition());
    }

    private Condition createCondition() {
        LilithCondition condition;
        String text = null;
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent != null) {
            text = findEditorComponent.getText();
        }
        String errorMessage = null;
        if (text == null) {
            text = "";
        }
        if (text.startsWith(GROOVY_IDENTIFIER)) {
            File resolvedScriptFile;
            String scriptName = text.substring(GROOVY_IDENTIFIER.length());
            int idx = scriptName.indexOf(35);
            if (idx > -1) {
                text = idx + 1 < scriptName.length() ? scriptName.substring(idx + 1) : "";
                scriptName = scriptName.substring(0, idx);
            } else {
                text = "";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GroovyCondition with scriptName '{}' and searchString '{}'", (Object)scriptName, (Object)text);
            }
            if ((resolvedScriptFile = this.mainFrame.resolveConditionScriptFile(scriptName)) != null) {
                condition = new GroovyCondition(resolvedScriptFile.getAbsolutePath(), text);
            } else {
                errorMessage = "Couldn't find groovy script '" + scriptName + "'.";
                condition = null;
            }
        } else if (text.startsWith(SAVED_CONDITION_IDENTIFIER)) {
            String conditionName = text.substring(SAVED_CONDITION_IDENTIFIER.length());
            SavedCondition savedCondition = this.applicationPreferences.resolveSavedCondition(conditionName);
            if (savedCondition != null) {
                condition = savedCondition.getCondition();
            } else {
                errorMessage = "Couldn't find condition named '" + conditionName + "'.";
                condition = null;
            }
        } else {
            String selectedType = (String)this.findTypeCombo.getSelectedItem();
            if (EVENT_CONTAINS_CONDITION.equals(selectedType)) {
                condition = new EventContainsCondition(text);
            } else if (MESSAGE_CONTAINS_CONDITION.equals(selectedType)) {
                condition = new MessageContainsCondition(text);
            } else if (LOGGER_STARTS_WITH_CONDITION.equals(selectedType)) {
                condition = new LoggerStartsWithCondition(text);
            } else if (LOGGER_EQUALS_CONDITION.equals(selectedType)) {
                condition = new LoggerEqualsCondition(text);
            } else if (LEVEL_CONDITION.equals(selectedType)) {
                boolean found = false;
                for (String current : LEVEL_VALUES) {
                    if (!current.equalsIgnoreCase(text)) continue;
                    text = current;
                    found = true;
                }
                if (found) {
                    condition = new LevelCondition(text);
                } else {
                    condition = null;
                    errorMessage = "Unknown level value '" + text + "'!";
                }
            } else if (CALL_LOCATION_CONDITION.equals(selectedType)) {
                condition = new CallLocationCondition(text);
            } else if (NAMED_CONDITION.equals(selectedType)) {
                SavedCondition savedCondition = this.applicationPreferences.resolveSavedCondition(text);
                if (savedCondition != null) {
                    condition = savedCondition.getCondition();
                } else {
                    errorMessage = "Couldn't find condition named '" + text + "'.";
                    condition = null;
                }
            } else if (selectedType != null) {
                File resolvedScriptFile = this.mainFrame.resolveConditionScriptFile(selectedType);
                if (resolvedScriptFile != null) {
                    condition = new GroovyCondition(resolvedScriptFile.getAbsolutePath(), text);
                } else {
                    errorMessage = "Couldn't find condition '" + selectedType + "'!";
                    condition = null;
                }
            } else {
                condition = null;
            }
        }
        if (findEditorComponent != null) {
            if (errorMessage != null) {
                findEditorComponent.setForeground(ERROR_COLOR);
                findEditorComponent.setToolTipText(errorMessage);
            } else {
                findEditorComponent.setForeground(NO_ERROR_COLOR);
                findEditorComponent.setToolTipText(null);
            }
        }
        if (condition != null && this.findNotButton.isSelected()) {
            condition = new Not((Condition)condition);
        }
        return condition;
    }

    public void resetFind() {
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent != null) {
            findEditorComponent.setText("");
        }
    }

    public void updateUi() {
        this.initTypeCombo();
        Condition condition = this.eventWrapperViewPanel.getFilterCondition();
        boolean not = false;
        if (condition instanceof Not) {
            Not notCondition = (Not)condition;
            not = true;
            condition = notCondition.getCondition();
        }
        if (condition != null) {
            GroovyCondition groovyCondition;
            String scriptFileName;
            String conditionName = null;
            if (condition instanceof EventContainsCondition) {
                conditionName = EVENT_CONTAINS_CONDITION;
            } else if (condition instanceof MessageContainsCondition) {
                conditionName = MESSAGE_CONTAINS_CONDITION;
            } else if (condition instanceof LoggerStartsWithCondition) {
                conditionName = LOGGER_STARTS_WITH_CONDITION;
            } else if (condition instanceof LoggerEqualsCondition) {
                conditionName = LOGGER_EQUALS_CONDITION;
            } else if (condition instanceof LevelCondition) {
                conditionName = LEVEL_CONDITION;
            } else if (condition instanceof GroovyCondition && (scriptFileName = (groovyCondition = (GroovyCondition)condition).getScriptFileName()) != null) {
                File scriptFile = new File(scriptFileName);
                conditionName = scriptFile.getName();
            }
            if (conditionName != null) {
                this.findTypeCombo.setSelectedItem(conditionName);
            }
        }
        this.findNotButton.setSelected(not);
        this.updateFindCombo();
    }

    private void initTypeCombo() {
        Vector<String> itemsVector = new Vector<String>();
        itemsVector.addAll(Arrays.asList(DEFAULT_CONDITIONS));
        String[] groovyConditions = this.mainFrame.getAllConditionScriptFiles();
        if (groovyConditions != null) {
            itemsVector.addAll(Arrays.asList(groovyConditions));
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(itemsVector);
        this.findTypeCombo.setModel(model);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Visible: {}", visible);
        }
    }

    private JTextComponent getFindEditorComponent() {
        Component findComponent = this.findTextCombo.getEditor().getEditorComponent();
        if (findComponent instanceof JTextComponent) {
            return (JTextComponent)findComponent;
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("findComponent ({}) is not instanceof JTextComponent!", (Object)findComponent.getClass().getName());
        }
        return null;
    }

    public void requestComboFocus() {
        this.findTextCombo.requestFocusInWindow();
        this.findTextCombo.getEditor().selectAll();
    }

    public void enableFindComponents(boolean enabled, Condition condition) {
        this.closeFindAction.setEnabled(enabled);
        this.findTextCombo.setEnabled(enabled);
        if (condition != null) {
            this.findPrevAction.setEnabled(enabled);
            this.findNextAction.setEnabled(enabled);
        } else {
            this.findPrevAction.setEnabled(false);
            this.findNextAction.setEnabled(false);
        }
    }

    private void updateFindCombo() {
        String selectedType = (String)this.findTypeCombo.getSelectedItem();
        if (LEVEL_CONDITION.equals(selectedType)) {
            this.findComboModel.replace((Object[])LEVEL_VALUES);
        } else if (NAMED_CONDITION.equals(selectedType)) {
            this.findComboModel.replace(this.conditionNames);
        } else {
            String prev = (String)this.findTextCombo.getSelectedItem();
            this.findComboModel.replace(this.previousSearchStrings);
            this.findTextCombo.setSelectedItem(prev);
        }
    }

    public void setPreviousSearchStrings(List<String> previousSearchStrings) {
        this.previousSearchStrings = new ArrayList<String>(previousSearchStrings);
        this.previousSearchStrings.add(0, "");
        this.updateFindCombo();
    }

    public void setConditionNames(List<String> conditionNames) {
        this.conditionNames = conditionNames;
        this.updateFindCombo();
    }

    private class FindTypeSelectionActionListener
    implements ActionListener {
        private FindTypeSelectionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.updateFindCombo();
            FindPanel.this.updateCondition();
        }
    }

    private class ReplaceFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 3876315232050114189L;

        public ReplaceFilterAction() {
            this.putValue("ShortDescription", "Replace filter.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"shift ENTER");
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container;
            if (FindPanel.this.logger.isInfoEnabled()) {
                FindPanel.this.logger.info("Replace filter.");
            }
            if ((container = FindPanel.this.eventWrapperViewPanel.resolveContainer()) != null) {
                container.replaceFilteredView(FindPanel.this.eventWrapperViewPanel);
            }
        }
    }

    private class CloseFindAction
    extends AbstractAction {
        private static final long serialVersionUID = -7757686292973276423L;

        public CloseFindAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/emblems/emblem-unreadable.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Close");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container = FindPanel.this.eventWrapperViewPanel.resolveContainer();
            if (container != null) {
                ProgressGlassPane progressPanel = container.getProgressPanel();
                progressPanel.getFindCancelAction().cancelSearch();
                FindPanel.this.setVisible(false);
            }
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = -8192948220602398223L;

        public FindPreviousAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-up.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find previous.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command G");
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.eventWrapperViewPanel.findPrevious();
        }
    }

    private class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = -6469494975854597398L;

        public FindNextAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-down.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find next.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift G");
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.eventWrapperViewPanel.findNext();
        }
    }

    private class FindTextFieldListener
    implements ActionListener,
    DocumentListener {
        private FindTextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedType;
            JTextComponent findEditorComponent;
            FindPanel.this.updateCondition();
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("modifiers: " + e.getModifiers());
            }
            if ((findEditorComponent = FindPanel.this.getFindEditorComponent()) != null) {
                findEditorComponent.selectAll();
            }
            if (!FindPanel.LEVEL_CONDITION.equals(selectedType = (String)FindPanel.this.findTypeCombo.getSelectedItem()) && !FindPanel.NAMED_CONDITION.equals(selectedType) && FindPanel.this.condition instanceof SearchStringCondition) {
                FindPanel.this.mainFrame.getApplicationPreferences().addPreviousSearchString(((SearchStringCondition)FindPanel.this.condition).getSearchString());
            }
            FindPanel.this.eventWrapperViewPanel.createFilteredView();
        }

        public void insertUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }

        public void removeUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }

        public void changedUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }
    }

    class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final Logger logger = LoggerFactory.getLogger(MyFocusTraversalPolicy.class);

        MyFocusTraversalPolicy() {
        }

        private Component resolveComponent(Component component) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container == FindPanel.this.findTypeCombo) {
                    return FindPanel.this.findTypeCombo;
                }
                if (container != FindPanel.this.findTextCombo) continue;
                return FindPanel.this.findTextCombo;
            }
            return null;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(FindPanel.this.closeFindButton)) {
                return FindPanel.this.findNotButton;
            }
            if (aComponent.equals(FindPanel.this.findNotButton)) {
                return FindPanel.this.findTypeCombo;
            }
            if (aComponent.equals(FindPanel.this.findTypeCombo)) {
                return FindPanel.this.findTextCombo;
            }
            if (aComponent.equals(FindPanel.this.findTextCombo)) {
                return FindPanel.this.findPrevButton;
            }
            if (aComponent.equals(FindPanel.this.findPrevButton)) {
                return FindPanel.this.findNextButton;
            }
            if (aComponent.equals(FindPanel.this.findNextButton)) {
                return FindPanel.this.closeFindButton;
            }
            Component c = this.resolveComponent(aComponent);
            if (FindPanel.this.findTypeCombo.equals(c)) {
                return FindPanel.this.findTextCombo;
            }
            if (FindPanel.this.findTextCombo.equals(c)) {
                return FindPanel.this.findPrevButton;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Moving focus forward was not explicitly handled.\ncontainer={}\ncomponent={}", aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(FindPanel.this.closeFindButton)) {
                return FindPanel.this.findNextButton;
            }
            if (aComponent.equals(FindPanel.this.findNotButton)) {
                return FindPanel.this.closeFindButton;
            }
            if (aComponent.equals(FindPanel.this.findTypeCombo)) {
                return FindPanel.this.findNotButton;
            }
            if (aComponent.equals(FindPanel.this.findTextCombo)) {
                return FindPanel.this.findTypeCombo;
            }
            if (aComponent.equals(FindPanel.this.findPrevButton)) {
                return FindPanel.this.findTextCombo;
            }
            if (aComponent.equals(FindPanel.this.findNextButton)) {
                return FindPanel.this.findPrevButton;
            }
            Component c = this.resolveComponent(aComponent);
            if (FindPanel.this.findTypeCombo.equals(c)) {
                return FindPanel.this.findNotButton;
            }
            if (FindPanel.this.findTextCombo.equals(c)) {
                return FindPanel.this.findTypeCombo;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Moving focus backward was not explicitly handled.\ncontainer={}\ncomponent={}", aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getFirstComponent(Container aContainer) {
            return FindPanel.this.closeFindButton;
        }

        public Component getLastComponent(Container aContainer) {
            return FindPanel.this.findNextButton;
        }

        public Component getDefaultComponent(Container aContainer) {
            return FindPanel.this.findTextCombo;
        }
    }
}

