/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.conditions.Condition;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboPaneViewContainer<T extends Serializable>
extends ViewContainer<T> {
    private final Logger logger = LoggerFactory.getLogger(ComboPaneViewContainer.class);
    private SourceChangeListener sourceChangeListener;
    private boolean disposed = false;
    private EventWrapper<T> selectedEvent;
    private JPanel contentPane;
    private DefaultComboBoxModel comboBoxModel;
    private int comboCounter;
    private CardLayout cardLayout;
    private CloseAction closeAction;
    private JPanel comboBoxPane = new JPanel(new GridBagLayout());

    public ComboPaneViewContainer(MainFrame mainFrame, EventSource<T> eventSource) {
        super(mainFrame, eventSource);
        GridBagConstraints gbc = new GridBagConstraints();
        this.comboBoxModel = new DefaultComboBoxModel();
        JComboBox cb = new JComboBox(this.comboBoxModel);
        cb.setRenderer(new MyComboBoxRenderer());
        cb.setEditable(false);
        cb.addItemListener(new ComboItemListener());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.closeAction = new CloseAction();
        JButton closeButton = new JButton(this.closeAction);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        this.comboBoxPane.add((Component)closeButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.comboBoxPane.add(cb, gbc);
        this.cardLayout = new CardLayout();
        this.contentPane = new JPanel(this.cardLayout);
        this.setLayout(new BorderLayout());
        this.add((Component)this.comboBoxPane, "North");
        this.add((Component)this.contentPane, "Center");
        this.sourceChangeListener = new SourceChangeListener();
        this.addView(this.getDefaultView());
    }

    @Override
    public void addView(EventWrapperViewPanel<T> view) {
        EventSource<T> source = view.getEventSource();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Adding view for {}", source);
        }
        ViewHolder holder = new ViewHolder(view);
        Condition filter = source.getFilter();
        if (filter == null) {
            this.comboBoxModel.insertElementAt(holder, 0);
        } else {
            this.comboBoxModel.addElement(holder);
        }
        this.comboBoxModel.setSelectedItem(holder);
        this.contentPane.add(holder.getView(), holder.getId());
        this.cardLayout.show(this.contentPane, holder.getId());
        view.addPropertyChangeListener(this.sourceChangeListener);
        view.requestFocusInWindow();
        this.selectedViewChanged();
    }

    @Override
    public void updateViews() {
        if (this.comboBoxPane.isVisible()) {
            this.comboBoxPane.repaint();
        }
        this.contentPane.repaint();
    }

    @Override
    public void updateViewScale(double scale) {
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            ViewHolder holder = (ViewHolder)this.comboBoxModel.getElementAt(i);
            EventWrapperViewPanel current = holder.getView();
            current.setScaleFactor(scale);
        }
    }

    @Override
    public void removeView(EventWrapperViewPanel<T> view, boolean dispose) {
        ViewHolder found = null;
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            ViewHolder holder = (ViewHolder)this.comboBoxModel.getElementAt(i);
            EventWrapperViewPanel current = holder.getView();
            if (current != view) continue;
            found = holder;
            break;
        }
        if (found != null) {
            this.comboBoxModel.removeElement(found);
            this.contentPane.remove(found.getView());
            view.removePropertyChangeListener(this.sourceChangeListener);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removed view {}.", view);
            }
            if (dispose) {
                view.dispose();
                Buffer buffer = view.getEventSource().getBuffer();
                Dispose.dispose((Object)buffer);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Disposed view {}.", view);
                }
            }
            this.selectedViewChanged();
        }
    }

    @Override
    public void showDefaultView() {
        ViewHolder holder;
        if (this.comboBoxModel.getSize() > 0 && (holder = (ViewHolder)this.comboBoxModel.getElementAt(0)) != null) {
            this.comboBoxModel.setSelectedItem(holder);
            this.cardLayout.show(this.contentPane, holder.getId());
            this.selectedViewChanged();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addNotify - parent: {}", this.getParent());
        }
    }

    @Override
    public void scrollToEvent() {
        EventWrapperViewPanel<T> selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.scrollToEvent();
            this.setSelectedEvent(selectedView.getSelectedEvent());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeNotify");
        }
    }

    private void selectedViewChanged() {
        EventWrapperViewPanel<T> selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.scrollToEvent();
            this.setSelectedEvent(selectedView.getSelectedEvent());
        } else {
            this.setSelectedEvent(null);
        }
        int count = this.comboBoxModel.getSize();
        if (count > 1) {
            this.comboBoxPane.setVisible(true);
        } else {
            this.comboBoxPane.setVisible(false);
        }
        this.fireChange();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposed = true;
        ArrayList<ViewHolder> removedPanes = new ArrayList<ViewHolder>();
        for (int i = 0; i < this.comboBoxModel.getSize(); ++i) {
            removedPanes.add((ViewHolder)this.comboBoxModel.getElementAt(i));
        }
        for (ViewHolder current : removedPanes) {
            this.removeView(current.getView(), true);
        }
        this.fireChange();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setSelectedEvent(EventWrapper<T> selectedEvent) {
        EventWrapper<T> oldValue = this.selectedEvent;
        EventWrapper<T> newValue = this.selectedEvent = selectedEvent;
        this.firePropertyChange("selectedEvent", oldValue, newValue);
    }

    @Override
    public EventWrapper<T> getSelectedEvent() {
        return this.selectedEvent;
    }

    @Override
    public EventWrapperViewPanel<T> getViewAt(int index) {
        if (index >= 0 && index < this.comboBoxModel.getSize()) {
            return ((ViewHolder)this.comboBoxModel.getElementAt(index)).getView();
        }
        return null;
    }

    @Override
    public EventWrapperViewPanel<T> getSelectedView() {
        ViewHolder holder = (ViewHolder)this.comboBoxModel.getSelectedItem();
        if (holder != null) {
            return holder.getView();
        }
        return null;
    }

    @Override
    public void setViewIndex(int index) {
        ViewHolder holder = (ViewHolder)this.comboBoxModel.getElementAt(index);
        this.comboBoxModel.setSelectedItem(holder);
        this.selectedViewChanged();
    }

    @Override
    public int getViewIndex() {
        return this.comboBoxModel.getIndexOf(this.comboBoxModel.getSelectedItem());
    }

    @Override
    public int getViewCount() {
        return this.comboBoxModel.getSize();
    }

    @Override
    public void closeCurrentFilter() {
        ViewHolder holder = (ViewHolder)this.comboBoxModel.getSelectedItem();
        int index = this.comboBoxModel.getIndexOf(holder);
        if (holder != null && index > 0) {
            EventWrapperViewPanel lvp = holder.getView();
            this.removeView(lvp, true);
            this.selectedViewChanged();
        }
    }

    @Override
    public void closeOtherFilters() {
        ViewHolder holder = (ViewHolder)this.comboBoxModel.getSelectedItem();
        int index = this.comboBoxModel.getIndexOf(holder);
        int tabCount = this.comboBoxModel.getSize();
        ArrayList<ViewHolder> removedPanes = new ArrayList<ViewHolder>();
        for (int i = 1; i < tabCount; ++i) {
            if (i == index) continue;
            removedPanes.add((ViewHolder)this.comboBoxModel.getElementAt(i));
        }
        for (ViewHolder current : removedPanes) {
            this.removeView(current.getView(), true);
        }
        this.selectedViewChanged();
    }

    @Override
    public void closeAllFilters() {
        ArrayList<ViewHolder> removedPanes = new ArrayList<ViewHolder>();
        for (int i = 1; i < this.comboBoxModel.getSize(); ++i) {
            removedPanes.add((ViewHolder)this.comboBoxModel.getElementAt(i));
        }
        for (ViewHolder current : removedPanes) {
            this.removeView(current.getView(), true);
        }
        this.selectedViewChanged();
    }

    @Override
    public void setShowingStatusbar(boolean showingStatusbar) {
        int tabCount = this.comboBoxModel.getSize();
        for (int i = 0; i < tabCount; ++i) {
            ViewHolder current = (ViewHolder)this.comboBoxModel.getElementAt(i);
            current.getView().setShowingStatusBar(showingStatusbar);
        }
    }

    private class MyComboBoxRenderer
    implements ListCellRenderer {
        private JLabel label = new JLabel();

        public MyComboBoxRenderer() {
            this.label.setOpaque(true);
            this.label.setHorizontalAlignment(2);
            this.label.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ViewHolder holder;
            EventWrapperViewPanel view;
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            String title = null;
            String toolTip = null;
            if (value != null && value.getClass() == ViewHolder.class && (view = (holder = (ViewHolder)value).getView()) != null) {
                EventSource source = view.getEventSource();
                Condition filter = source.getFilter();
                if (filter == null) {
                    toolTip = title = "Unfiltered";
                } else {
                    SavedCondition savedCondition = ComboPaneViewContainer.this.getMainFrame().getApplicationPreferences().resolveSavedCondition(filter);
                    if (savedCondition != null) {
                        title = savedCondition.getName();
                        toolTip = filter.toString();
                    } else {
                        String text;
                        title = text = filter.toString();
                        toolTip = text;
                    }
                }
            }
            this.label.setText(title);
            this.label.setToolTipText(toolTip);
            return this.label;
        }
    }

    private class SourceChangeListener
    implements PropertyChangeListener {
        private SourceChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("eventSource".equals(propName)) {
                if (ComboPaneViewContainer.this.logger.isDebugEnabled()) {
                    ComboPaneViewContainer.this.logger.debug("EventSource changed: {}", evt.getNewValue());
                }
                EventWrapperViewPanel lvp = (EventWrapperViewPanel)evt.getSource();
                ComboPaneViewContainer.this.removeView(lvp, false);
                ComboPaneViewContainer.this.addView(lvp);
            } else if ("selectedEvent".equals(propName)) {
                if (ComboPaneViewContainer.this.getSelectedView() == evt.getSource()) {
                    if (ComboPaneViewContainer.this.logger.isDebugEnabled()) {
                        ComboPaneViewContainer.this.logger.debug("EventSource changed: {}", evt.getNewValue());
                    }
                    ComboPaneViewContainer.this.setSelectedEvent((EventWrapper)evt.getNewValue());
                }
            } else {
                if (ComboPaneViewContainer.this.logger.isDebugEnabled()) {
                    ComboPaneViewContainer.this.logger.debug("Other change: {}", (Object)propName);
                }
                ComboPaneViewContainer.this.fireChange();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ViewHolder {
        private final EventWrapperViewPanel<T> view;
        private final String id;

        private ViewHolder(EventWrapperViewPanel<T> view) {
            this.view = view;
            ComboPaneViewContainer.this.comboCounter++;
            this.id = "" + ComboPaneViewContainer.this.comboCounter;
        }

        public EventWrapperViewPanel<T> getView() {
            return this.view;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewHolder that = (ViewHolder)o;
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            return !(this.view != null ? !this.view.equals(that.view) : that.view != null);
        }

        public int hashCode() {
            int result = this.view != null ? this.view.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ViewHolder[id=" + this.id + ", view=" + this.view + "]";
        }
    }

    private class ComboItemListener
    implements ItemListener {
        private ComboItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ViewHolder holder = (ViewHolder)ComboPaneViewContainer.this.comboBoxModel.getSelectedItem();
            if (holder != null) {
                ComboPaneViewContainer.this.cardLayout.show(ComboPaneViewContainer.this.contentPane, holder.getId());
                if (ComboPaneViewContainer.this.getViewIndex() > 0) {
                    ComboPaneViewContainer.this.closeAction.setEnabled(true);
                } else {
                    ComboPaneViewContainer.this.closeAction.setEnabled(false);
                }
                ComboPaneViewContainer.this.selectedViewChanged();
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 7687142682378711767L;

        private CloseAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/emblems/emblem-unreadable.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Close filtered view.");
        }

        public void actionPerformed(ActionEvent e) {
            ComboPaneViewContainer.this.closeCurrentFilter();
        }
    }
}

