/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.elementprocessors;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.sulky.buffers.ElementProcessor;
import de.huxhorn.sulky.buffers.ResetOperation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventLoggerNameProcessor
implements ElementProcessor<EventWrapper<LoggingEvent>>,
ResetOperation {
    private Set<String> loggerNames = new HashSet<String>();

    public void processElement(EventWrapper<LoggingEvent> element) {
        if (element == null) {
            return;
        }
        LoggingEvent event = (LoggingEvent)element.getEvent();
        if (event == null) {
            return;
        }
        String name = event.getLogger();
        if (name == null) {
            return;
        }
        if (!this.loggerNames.contains(name)) {
            this.loggerNames.add(name);
            this.changed();
        }
    }

    public void processElements(List<EventWrapper<LoggingEvent>> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        boolean changed = false;
        for (EventWrapper<LoggingEvent> element : elements) {
            String name;
            LoggingEvent event;
            if (element == null || (event = (LoggingEvent)element.getEvent()) == null || (name = event.getLogger()) == null || this.loggerNames.contains(name)) continue;
            this.loggerNames.add(name);
            changed = true;
        }
        if (changed) {
            this.changed();
        }
    }

    public void reset() {
        this.loggerNames.clear();
        this.changed();
    }

    private void changed() {
    }
}

