/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.sulky.conditions.Condition;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = 907179107764473874L;
    private final Logger logger = LoggerFactory.getLogger(GroovyCondition.class);
    private String scriptFileName;
    private String searchString;
    private transient Object instance;
    private transient String scriptName;

    public GroovyCondition() {
        this(null);
    }

    public GroovyCondition(String scriptFileName) {
        this.setScriptFileName(scriptFileName);
    }

    public GroovyCondition(String scriptFileName, String searchString) {
        this.setScriptFileName(scriptFileName);
        this.setSearchString(searchString);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScriptFileName(String scriptFileName) {
        block4: {
            this.instance = null;
            this.scriptName = null;
            this.scriptFileName = scriptFileName;
            if (scriptFileName != null) {
                File scriptFile = new File(scriptFileName);
                if (!scriptFile.isFile() && this.logger.isWarnEnabled()) {
                    this.logger.warn("Scriptfile '{}' is not a file!", (Object)scriptFile.getAbsolutePath());
                }
                GroovyClassLoader gcl = new GroovyClassLoader();
                gcl.setShouldRecompile(Boolean.valueOf(true));
                try {
                    Class clazz = gcl.parseClass(scriptFile);
                    this.instance = clazz.newInstance();
                    this.scriptName = scriptFile.getName();
                }
                catch (Throwable e) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Exception while instanciating groovy condition '" + scriptFile.getAbsolutePath() + "'!", e);
                }
            }
        }
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isTrue(Object o) {
        try {
            if (this.instance instanceof Condition) {
                Condition condition = (Condition)this.instance;
                return condition.isTrue(o);
            }
            if (this.instance instanceof Script) {
                Script script = (Script)this.instance;
                Binding binding = new Binding();
                binding.setVariable("input", o);
                if (this.searchString != null) {
                    binding.setVariable("searchString", (Object)this.searchString);
                }
                binding.setVariable("logger", (Object)this.logger);
                script.setBinding(binding);
                Object result = script.run();
                return result != null && !result.equals(Boolean.FALSE);
            }
            return false;
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while executing '" + this.scriptFileName + "'!", t);
            }
            return false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setScriptFileName(this.scriptFileName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroovyCondition)) {
            return false;
        }
        GroovyCondition that = (GroovyCondition)o;
        if (this.scriptFileName != null ? !this.scriptFileName.equals(that.scriptFileName) : that.scriptFileName != null) {
            return false;
        }
        return !(this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null);
    }

    public int hashCode() {
        int result = this.scriptFileName != null ? this.scriptFileName.hashCode() : 0;
        result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        if (this.searchString != null) {
            result.append("(");
            result.append(this.searchString);
            result.append(")");
        }
        return result.toString();
    }

    public GroovyCondition clone() throws CloneNotSupportedException {
        GroovyCondition result = (GroovyCondition)super.clone();
        result.setScriptFileName(result.scriptFileName);
        return result;
    }

    public String getDescription() {
        return this.scriptName;
    }
}

