/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventContainsCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -8094852331877521764L;
    private String searchString;

    public EventContainsCondition() {
        this(null);
    }

    public EventContainsCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    private boolean checkString(String input) {
        if (this.searchString == null) {
            return false;
        }
        return input != null && input.contains(this.searchString);
    }

    public boolean isTrue(Object value) {
        if (this.searchString == null) {
            return false;
        }
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            if (this.searchString.length() == 0) {
                return true;
            }
            if (eventObj instanceof LoggingEvent) {
                Map mdcMap;
                String level;
                LoggingEvent event = (LoggingEvent)eventObj;
                String message = null;
                Message messageObj = event.getMessage();
                if (messageObj != null) {
                    message = messageObj.getMessage();
                }
                if (message != null && this.checkString(message)) {
                    return true;
                }
                LoggerContext context = event.getLoggerContext();
                if (context != null) {
                    if (this.checkString(context.getName())) {
                        return true;
                    }
                    Map props = context.getProperties();
                    if (props != null) {
                        for (Map.Entry current : props.entrySet()) {
                            if (this.checkString((String)current.getKey())) {
                                return true;
                            }
                            if (!this.checkString((String)current.getValue())) continue;
                            return true;
                        }
                    }
                }
                if (this.checkString(level = "" + event.getLevel())) {
                    return true;
                }
                String loggerName = event.getLogger();
                if (this.checkString(loggerName)) {
                    return true;
                }
                ThreadInfo threadInfo = event.getThreadInfo();
                if (threadInfo != null) {
                    String threadName = threadInfo.getName();
                    if (this.checkString(threadName)) {
                        return true;
                    }
                    Long threadId = threadInfo.getId();
                    if (threadId != null && this.checkString("" + threadId)) {
                        return true;
                    }
                }
                if (this.checkMap(mdcMap = event.getMdc())) {
                    return true;
                }
                Marker marker = event.getMarker();
                if (marker != null && this.checkMarker(marker, null)) {
                    return true;
                }
            } else if (eventObj instanceof AccessEvent) {
                AccessEvent event = (AccessEvent)eventObj;
                String message = event.getRequestURL();
                if (this.checkString(message)) {
                    return true;
                }
                LoggerContext context = event.getLoggerContext();
                if (context != null) {
                    if (this.checkString(context.getName())) {
                        return true;
                    }
                    Map props = context.getProperties();
                    if (props != null) {
                        for (Map.Entry current : props.entrySet()) {
                            if (this.checkString((String)current.getKey())) {
                                return true;
                            }
                            if (!this.checkString((String)current.getValue())) continue;
                            return true;
                        }
                    }
                }
                if (this.checkString(message = "" + event.getStatusCode())) {
                    return true;
                }
                Map propertyMap = event.getRequestHeaders();
                if (this.checkMap(propertyMap)) {
                    return true;
                }
                propertyMap = event.getResponseHeaders();
                if (this.checkMap(propertyMap)) {
                    return true;
                }
                propertyMap = event.getRequestParameters();
                if (this.checkArrayMap(propertyMap)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkMarker(Marker marker, List<String> processedMarkers) {
        if (marker != null) {
            if (processedMarkers == null) {
                processedMarkers = new ArrayList<String>();
            }
            if (this.checkString(marker.getName())) {
                return true;
            }
            if (!processedMarkers.contains(marker.getName())) {
                processedMarkers.add(marker.getName());
                if (marker.hasReferences()) {
                    Map children = marker.getReferences();
                    for (Map.Entry current : children.entrySet()) {
                        Marker child = (Marker)current.getValue();
                        if (!this.checkMarker(child, processedMarkers)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean checkMap(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (this.checkString(entry.getKey())) {
                    return true;
                }
                if (!this.checkString(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkArrayMap(Map<String, String[]> map) {
        if (map != null) {
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String[] array;
                if (this.checkString(entry.getKey())) {
                    return true;
                }
                for (String s : array = entry.getValue()) {
                    if (!this.checkString(s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSearchString(this.searchString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventContainsCondition that = (EventContainsCondition)o;
        return !(this.searchString == null ? that.searchString != null : !this.searchString.equals(that.searchString));
    }

    public int hashCode() {
        int result = this.searchString != null ? this.searchString.hashCode() : 0;
        return result;
    }

    public EventContainsCondition clone() throws CloneNotSupportedException {
        return (EventContainsCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public String getDescription() {
        return "event.contains";
    }
}

