/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.access.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.protobuf.generated.AccessProto;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEventProtobufDecoder
implements Decoder<AccessEvent> {
    private boolean compressing;

    public AccessEventProtobufDecoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public AccessEvent decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        AccessProto.AccessEvent parsedEvent = null;
        if (!this.compressing) {
            try {
                parsedEvent = AccessProto.AccessEvent.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException e) {}
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                GZIPInputStream gis = new GZIPInputStream(in);
                parsedEvent = AccessProto.AccessEvent.parseFrom(gis);
                gis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return AccessEventProtobufDecoder.convert(parsedEvent);
    }

    public static AccessEvent convert(AccessProto.AccessEvent parsedEvent) {
        if (parsedEvent == null) {
            return null;
        }
        AccessEvent result = new AccessEvent();
        if (parsedEvent.hasMethod()) {
            result.setMethod(parsedEvent.getMethod());
        }
        if (parsedEvent.hasProtocol()) {
            result.setProtocol(parsedEvent.getProtocol());
        }
        if (parsedEvent.hasRemoteAddress()) {
            result.setRemoteAddress(parsedEvent.getRemoteAddress());
        }
        if (parsedEvent.hasRemoteHost()) {
            result.setRemoteHost(parsedEvent.getRemoteHost());
        }
        if (parsedEvent.hasRemoteUser()) {
            result.setRemoteUser(parsedEvent.getRemoteUser());
        }
        if (parsedEvent.hasRequestUri()) {
            result.setRequestURI(parsedEvent.getRequestUri());
        }
        if (parsedEvent.hasRequestUrl()) {
            result.setRequestURL(parsedEvent.getRequestUrl());
        }
        if (parsedEvent.hasServerName()) {
            result.setServerName(parsedEvent.getServerName());
        }
        if (parsedEvent.hasTimeStamp()) {
            result.setTimeStamp(Long.valueOf(parsedEvent.getTimeStamp()));
        }
        if (parsedEvent.hasLocalPort()) {
            result.setLocalPort(parsedEvent.getLocalPort());
        }
        if (parsedEvent.hasStatusCode()) {
            result.setStatusCode(parsedEvent.getStatusCode());
        }
        if (parsedEvent.hasRequestHeaders()) {
            result.setRequestHeaders(AccessEventProtobufDecoder.convertStringMap(parsedEvent.getRequestHeaders()));
        }
        if (parsedEvent.hasResponseHeaders()) {
            result.setResponseHeaders(AccessEventProtobufDecoder.convertStringMap(parsedEvent.getResponseHeaders()));
        }
        if (parsedEvent.hasRequestParameters()) {
            result.setRequestParameters(AccessEventProtobufDecoder.convertStringArrayMap(parsedEvent.getRequestParameters()));
        }
        if (parsedEvent.hasLoggerContext()) {
            result.setLoggerContext(AccessEventProtobufDecoder.convert(parsedEvent.getLoggerContext()));
        }
        return result;
    }

    public static LoggerContext convert(AccessProto.LoggerContext loggerContext) {
        if (loggerContext == null) {
            return null;
        }
        LoggerContext result = new LoggerContext();
        if (loggerContext.hasName()) {
            result.setName(loggerContext.getName());
        }
        if (loggerContext.hasBirthTime()) {
            result.setBirthTime(Long.valueOf(loggerContext.getBirthTime()));
        }
        if (loggerContext.hasProperties()) {
            result.setProperties(AccessEventProtobufDecoder.convertStringMap(loggerContext.getProperties()));
        }
        return result;
    }

    public static Map<String, String> convertStringMap(AccessProto.StringMap data) {
        if (data == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List<AccessProto.StringMapEntry> entries = data.getEntryList();
        for (AccessProto.StringMapEntry current : entries) {
            String key = null;
            String value = null;
            if (current.hasKey()) {
                key = current.getKey();
            }
            if (current.hasValue()) {
                value = current.getValue();
            }
            if (key == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, String[]> convertStringArrayMap(AccessProto.StringArrayMap data) {
        if (data == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        List<AccessProto.StringArrayMapEntry> entries = data.getEntryList();
        for (AccessProto.StringArrayMapEntry current : entries) {
            int count;
            String key = null;
            String[] values = null;
            if (current.hasKey()) {
                key = current.getKey();
            }
            if ((count = current.getValueCount()) > 0) {
                ArrayList<String> valueList = new ArrayList<String>(count);
                for (AccessProto.StringArrayValue curVal : current.getValueList()) {
                    if (curVal.hasValue()) {
                        valueList.add(curVal.getValue());
                        continue;
                    }
                    valueList.add(null);
                }
                values = valueList.toArray(new String[count]);
            }
            if (key == null) continue;
            result.put(key, values);
        }
        return result;
    }
}

