/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.xml.eventproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.xml.LoggingEventReader;
import de.huxhorn.lilith.data.logging.xml.LoggingEventSchemaConstants;
import de.huxhorn.lilith.engine.impl.eventproducer.AbstractEventProducer;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LilithXmlStreamLoggingEventProducer
extends AbstractEventProducer<LoggingEvent>
implements LoggingEventSchemaConstants {
    private final Logger logger = LoggerFactory.getLogger(LilithXmlStreamLoggingEventProducer.class);
    private LoggingEventReader loggingEventReader = new LoggingEventReader();
    private BufferedInputStream inputStream;

    public LilithXmlStreamLoggingEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<LoggingEvent>> eventQueue, InputStream inputStream) throws XMLStreamException, UnsupportedEncodingException {
        super(sourceIdentifier, eventQueue);
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public void start() {
        Thread t = new Thread((Runnable)new ReceiverRunnable(), "" + this.getSourceIdentifier() + "-Receiver");
        t.setDaemon(true);
        t.start();
    }

    public void close() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    private class ReceiverRunnable
    implements Runnable {
        private ReceiverRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try {
                ArrayList<Byte> bytes = new ArrayList<Byte>();
                while (true) {
                    block12: {
                        block13: {
                            byte current;
                            block11: {
                                int readByte;
                                if ((readByte = LilithXmlStreamLoggingEventProducer.this.inputStream.read()) == -1) {
                                    if (!LilithXmlStreamLoggingEventProducer.this.logger.isInfoEnabled()) return;
                                    LilithXmlStreamLoggingEventProducer.this.logger.info("Read -1!!");
                                    return;
                                }
                                current = (byte)readByte;
                                if (current != 0) break block11;
                                if (bytes.size() <= 0) break block12;
                                break block13;
                            }
                            bytes.add(current);
                            continue;
                        }
                        byte[] ba = new byte[bytes.size()];
                        for (int i = 0; i < bytes.size(); ++i) {
                            ba[i] = (Byte)bytes.get(i);
                        }
                        bytes.clear();
                        String str = new String(ba, "UTF-8");
                        if (LilithXmlStreamLoggingEventProducer.this.logger.isDebugEnabled()) {
                            LilithXmlStreamLoggingEventProducer.this.logger.debug("Read: {}", (Object)str);
                        }
                        StringReader strr = new StringReader(str);
                        XMLStreamReader reader = inputFactory.createXMLStreamReader(strr);
                        LoggingEvent event = LilithXmlStreamLoggingEventProducer.this.loggingEventReader.read(reader);
                        LilithXmlStreamLoggingEventProducer.this.addEvent((Serializable)event);
                        continue;
                    }
                    if (!LilithXmlStreamLoggingEventProducer.this.logger.isDebugEnabled()) continue;
                    LilithXmlStreamLoggingEventProducer.this.logger.debug("bytes.size()==0!!");
                    continue;
                    break;
                }
            }
            catch (Throwable e) {
                if (LilithXmlStreamLoggingEventProducer.this.logger.isInfoEnabled()) {
                    LilithXmlStreamLoggingEventProducer.this.logger.info("Exception ({}: '{}') while reading events. Adding eventWrapper with empty event and stopping...", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
                LilithXmlStreamLoggingEventProducer.this.addEvent(null);
                return;
            }
            finally {
                LilithXmlStreamLoggingEventProducer.this.close();
            }
        }
    }
}

