/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.ConnectionListener;
import it.sauronsoftware.junique.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class Connection
implements Runnable {
    private Object synchLock = new Object();
    private String id;
    private ConnectionListener listener;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean running = false;
    private Thread thread;

    public Connection(String string, Socket socket, ConnectionListener connectionListener) {
        this.id = string;
        this.socket = socket;
        this.listener = connectionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.running) {
                throw new IllegalStateException("JUnique/Server/" + this.id + "/Connection already started");
            }
            this.running = true;
            this.thread = new Thread((Runnable)this, "JUnique/Server/" + this.id + "/Connection");
            this.thread.setDaemon(true);
            this.thread.start();
            while (true) {
                try {
                    this.synchLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (!this.running) {
                throw new IllegalStateException("JUnique/Server/" + this.id + "/Connection not started");
            }
            this.running = false;
            this.thread.interrupt();
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Thread.currentThread() != this.thread) {
                while (true) {
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.synchLock;
        synchronized (object) {
            this.synchLock.notify();
        }
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.stop();
        }
        while (!Thread.interrupted()) {
            try {
                object = Message.read(this.inputStream);
                String string = this.listener.messageReceived(this, (String)object);
                if (string == null) {
                    string = "";
                }
                Message.write(string, this.outputStream);
            }
            catch (IOException iOException) {
                this.stop();
            }
        }
        this.listener.connectionClosed(this);
    }
}

