/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.xhtml;

import java.awt.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.simple.XHTMLPanel;

public class EnhancedXHTMLPanel
extends XHTMLPanel {
    private final Logger logger = LoggerFactory.getLogger(EnhancedXHTMLPanel.class);

    public void setDocumentRelative(String filename) {
        String url = this.getSharedContext().getUac().resolveURI(filename);
        if (this.isAnchorInCurrentDocument(filename)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("isAnchor");
            }
            String id = this.getAnchorId(filename);
            Box box = this.getSharedContext().getBoxById(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Box: {}", box);
            }
            if (box != null) {
                Point pt;
                if (box.getStyle().isInline()) {
                    pt = new Point(box.getAbsX(), box.getAbsY());
                } else {
                    RectPropertySet margin = box.getMargin((CssContext)this.getLayoutContext());
                    pt = new Point(box.getAbsX() + (int)margin.left(), box.getAbsY() + (int)margin.top());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Point: {}", pt);
                }
                this.scrollTo(pt);
                return;
            }
        }
        Document dom = this.loadDocument(url);
        this.setDocument(dom, url);
    }

    private boolean isAnchorInCurrentDocument(String str) {
        return str.charAt(0) == '#';
    }

    private String getAnchorId(String url) {
        return url.substring(1, url.length());
    }
}

