/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.tooltips;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTable;

public class ContextTooltipGenerator
implements TooltipGenerator {
    private SimpleDateFormat fullFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");

    public String createTooltipText(JTable table, int row) {
        String tooltip = null;
        Object value = table.getValueAt(row, 0);
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            LoggerContext context = null;
            if (eventObj instanceof LoggingEvent) {
                context = ((LoggingEvent)eventObj).getLoggerContext();
            } else if (eventObj instanceof AccessEvent) {
                context = ((AccessEvent)eventObj).getLoggerContext();
            }
            if (context != null) {
                Map props;
                StringBuilder msg = new StringBuilder();
                msg.append("<html><h4>Name</h4>").append(context.getName());
                Long timestamp = context.getBirthTime();
                if (timestamp != null) {
                    msg.append("<h4>Birthtime</h4>");
                    msg.append(this.fullFormat.format(new Date(timestamp)));
                }
                if ((props = context.getProperties()) != null && props.size() > 0) {
                    msg.append("<h4>Properties</h4>");
                    TreeMap sortedProps = new TreeMap(props);
                    msg.append("<table>");
                    msg.append("<tr>");
                    msg.append("<th>Key</th><th>Value</th>");
                    msg.append("</tr>");
                    for (Map.Entry current : sortedProps.entrySet()) {
                        msg.append("<tr>");
                        msg.append("<td>").append((String)current.getKey()).append("</td>");
                        msg.append("<td>").append((String)current.getValue()).append("</td>");
                        msg.append("</tr>");
                    }
                    msg.append("</table>");
                }
                msg.append("</html>");
                tooltip = msg.toString();
            }
        }
        return tooltip;
    }
}

