/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.model;

import de.huxhorn.lilith.swing.table.model.RowBasedTableModel;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.CircularBuffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.Reset;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferTableModel<T>
implements RowBasedTableModel<T>,
DisposeOperation {
    private final Logger logger = LoggerFactory.getLogger(BufferTableModel.class);
    private Buffer<T> buffer;
    private CircularBuffer<T> circularBuffer;
    private final EventListenerList eventListenerList = new EventListenerList();
    private boolean disposed = false;
    private boolean paused;
    private int pauseRowCount;
    private int lastRowCount = 0;

    public BufferTableModel(Buffer<T> buffer) {
        this.setBuffer(buffer);
        Thread t = new Thread((Runnable)new TableChangeDetectionRunnable(), "TableChangeDetection");
        t.setDaemon(true);
        t.setPriority(4);
        t.start();
        this.setPaused(false);
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized void setPaused(boolean paused) {
        if (paused) {
            this.pauseRowCount = this.getRowCount();
        }
        this.paused = paused;
        this.notifyAll();
    }

    public Buffer<T> getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer<T> buffer) {
        this.buffer = buffer;
        this.circularBuffer = buffer instanceof CircularBuffer ? (CircularBuffer)buffer : null;
        this.setLastRowCount(0);
        this.pauseRowCount = 0;
    }

    public boolean clear() {
        boolean reset = Reset.reset(this.buffer);
        if (reset) {
            this.setLastRowCount(0);
            this.fireTableChange();
            return true;
        }
        return false;
    }

    @Override
    public synchronized int getRowCount() {
        return this.lastRowCount;
    }

    private synchronized void setLastRowCount(int lastRowCount) {
        this.lastRowCount = lastRowCount;
    }

    public synchronized void dispose() {
        this.disposed = true;
        Dispose.dispose(this.buffer);
        this.notifyAll();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private int internalRowCount() {
        if (this.isPaused()) {
            return this.pauseRowCount;
        }
        if (this.circularBuffer != null) {
            return this.circularBuffer.getAvailableElements();
        }
        long rows = this.buffer.getSize();
        if (rows > Integer.MAX_VALUE) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Swing can only handle 2147483647 rows instead of " + rows + "!");
            }
            rows = Integer.MAX_VALUE;
        }
        return (int)rows;
    }

    @Override
    public T getValueAt(int row) {
        if (this.circularBuffer != null) {
            return (T)this.circularBuffer.getRelative(row);
        }
        return (T)this.buffer.get((long)row);
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract Class<?> getColumnClass(int var1);

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T value = this.getValueAt(rowIndex);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("value: {}", value);
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void fireTableChange() {
        TableModelEvent event = new TableModelEvent(this);
        this.fireTableChange(event);
    }

    private void fireTableChange(int prevValue, int currentValue) {
        TableModelEvent event = new TableModelEvent(this, prevValue, currentValue, -1, 1);
        this.fireTableChange(event);
    }

    private void fireTableChange(TableModelEvent evt) {
        FireTableChangeRunnable r = new FireTableChangeRunnable(evt);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.add(TableModelListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.remove(TableModelListener.class, l);
        }
    }

    class TableChangeDetectionRunnable
    implements Runnable {
        private static final int UPDATE_INTERVAL = 500;

        TableChangeDetectionRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (BufferTableModel.this.isDisposed()) {
                    if (BufferTableModel.this.logger.isDebugEnabled()) {
                        BufferTableModel.this.logger.debug("Stopping TableChangeDetectionRunnable...");
                    }
                    return;
                }
                if (!BufferTableModel.this.isPaused()) {
                    int currentValue = BufferTableModel.this.internalRowCount();
                    if (currentValue > -1) {
                        int prevValue = BufferTableModel.this.getRowCount();
                        if (prevValue != 0 && currentValue > prevValue) {
                            int lastRow = currentValue - 1;
                            BufferTableModel.this.setLastRowCount(currentValue);
                            BufferTableModel.this.fireTableChange(prevValue, lastRow);
                        } else if (currentValue != prevValue) {
                            BufferTableModel.this.setLastRowCount(currentValue);
                            BufferTableModel.this.fireTableChange();
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        if (BufferTableModel.this.logger.isDebugEnabled()) {
                            BufferTableModel.this.logger.debug("Interrupted...", e);
                        }
                        return;
                    }
                }
                BufferTableModel bufferTableModel = BufferTableModel.this;
                synchronized (bufferTableModel) {
                    while (BufferTableModel.this.isPaused()) {
                        try {
                            BufferTableModel.this.wait();
                        }
                        catch (InterruptedException e) {
                            if (BufferTableModel.this.logger.isDebugEnabled()) {
                                BufferTableModel.this.logger.debug("Interrupted...", e);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private class FireTableChangeRunnable
    implements Runnable {
        private TableModelEvent event;

        public FireTableChangeRunnable(TableModelEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] listeners;
            EventListenerList eventListenerList = BufferTableModel.this.eventListenerList;
            synchronized (eventListenerList) {
                listeners = BufferTableModel.this.eventListenerList.getListenerList();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                TableModelListener listener = (TableModelListener)listeners[i + 1];
                if (BufferTableModel.this.logger.isDebugEnabled()) {
                    BufferTableModel.this.logger.debug("Firing TableChange at {}.", (Object)listener.getClass().getName());
                }
                try {
                    listener.tableChanged(this.event);
                    continue;
                }
                catch (Throwable ex) {
                    if (!BufferTableModel.this.logger.isWarnEnabled()) continue;
                    BufferTableModel.this.logger.warn("Exception while firing change!", ex);
                }
            }
        }
    }
}

