/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences.table;

import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.lilith.swing.table.renderer.ConditionalBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class ColorSchemePreviewRenderer
implements TableCellRenderer {
    private static final ColorScheme DEFAULT_SCHEME = new ColorScheme();
    private ConditionalBorder border;
    protected JLabel renderer = new JLabel();

    public ColorSchemePreviewRenderer() {
        Font font = this.renderer.getFont();
        font = font.deriveFont(0);
        this.renderer.setFont(font);
        this.renderer.setOpaque(true);
        this.renderer.setText("X");
        this.border = new ConditionalBorder(Color.WHITE, 3, 3);
        this.renderer.setBorder(this.border);
    }

    public abstract ColorScheme resolveColorScheme(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    public abstract void updateText(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int preferredHeight;
        int rowHeight;
        ColorScheme scheme = this.resolveColorScheme(table, value, isSelected, hasFocus, row, column);
        if (scheme == null) {
            scheme = DEFAULT_SCHEME;
        }
        this.border.setBorderColor(scheme.getBorderColor());
        this.renderer.setForeground(scheme.getTextColor());
        this.renderer.setBackground(scheme.getBackgroundColor());
        this.renderer.setBorder(null);
        this.renderer.setBorder(this.border);
        this.updateText(table, value, isSelected, hasFocus, row, column);
        if (table != null && (rowHeight = table.getRowHeight()) < (preferredHeight = this.renderer.getPreferredSize().height)) {
            table.setRowHeight(preferredHeight);
        }
        return this.renderer;
    }
}

