/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewManager;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Reset;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TroubleshootingPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(TroubleshootingPanel.class);
    private PreferencesDialog preferencesDialog;

    public TroubleshootingPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.createUI();
    }

    private void createUI() {
        this.add(new JButton(new InitDetailsViewAction()));
        this.add(new JButton(new InitExampleScriptsAction()));
        this.add(new JButton(new DeleteAllLogsAction()));
        this.add(new JButton(new CopySystemPropertiesAction()));
        this.add(new JButton(new CopyThreadsAction()));
        this.add(new JButton(new GarbageCollectionAction()));
    }

    public static void reset(ViewContainer<?> container) {
        if (container == null) {
            return;
        }
        EventSource<?> eventSource = container.getEventSource();
        if (eventSource == null) {
            return;
        }
        Buffer buffer = eventSource.getBuffer();
        Reset.reset((Object)buffer);
    }

    public class GarbageCollectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -4636919088257143096L;

        public GarbageCollectionAction() {
            super("Execute GC");
            this.putValue("ShortDescription", "Execute garbage collection.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadHolder
    implements Comparable<ThreadHolder> {
        private final Thread thread;
        private final StackTraceElement[] stackTraceElements;

        private ThreadHolder(Thread thread, StackTraceElement[] stackTraceElements) {
            this.thread = thread;
            this.stackTraceElements = stackTraceElements;
        }

        public Thread getThread() {
            return this.thread;
        }

        public StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadHolder that = (ThreadHolder)o;
            return !(this.thread != null ? !this.thread.equals(that.thread) : that.thread != null);
        }

        public int hashCode() {
            return this.thread != null ? this.thread.hashCode() : 0;
        }

        @Override
        public int compareTo(ThreadHolder o) {
            String otherName;
            if (this.thread == o.thread) {
                return 0;
            }
            if (this.thread == null) {
                return -1;
            }
            if (o.thread == null) {
                return 1;
            }
            String name = this.thread.getName();
            if (name == (otherName = o.thread.getName())) {
                return 0;
            }
            if (name == null) {
                return -1;
            }
            if (otherName == null) {
                return 1;
            }
            return name.compareTo(otherName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadGroupComparator
    implements Comparator<ThreadGroup> {
        private ThreadGroupComparator() {
        }

        @Override
        public int compare(ThreadGroup o1, ThreadGroup o2) {
            String otherName;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String name = o1.getName();
            if (name == (otherName = o2.getName())) {
                return 0;
            }
            if (name == null) {
                return -1;
            }
            if (otherName == null) {
                return 1;
            }
            return name.compareTo(otherName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CopyThreadsAction
    extends AbstractAction {
        private static final long serialVersionUID = -2375370123070284280L;

        public CopyThreadsAction() {
            super("Copy threads");
            this.putValue("ShortDescription", "Copy the stacktraces of all threads to the clipboard.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            StringBuilder builder = new StringBuilder();
            Hashtable<ThreadGroup, List<ThreadHolder>> threadGroupMapping = new Hashtable<ThreadGroup, List<ThreadHolder>>();
            ArrayList<ThreadHolder> nullList = new ArrayList<ThreadHolder>();
            for (Map.Entry<Thread, StackTraceElement[]> current : allStackTraces.entrySet()) {
                Thread key = current.getKey();
                StackTraceElement[] stackTraceElementArray = current.getValue();
                ThreadHolder holder = new ThreadHolder(key, stackTraceElementArray);
                ThreadGroup group = key.getThreadGroup();
                if (group == null) {
                    nullList.add(holder);
                    continue;
                }
                ArrayList<ThreadHolder> list = (ArrayList<ThreadHolder>)threadGroupMapping.get(group);
                if (list == null) {
                    list = new ArrayList<ThreadHolder>();
                    threadGroupMapping.put(group, list);
                }
                list.add(holder);
            }
            ThreadGroup rootGroup = null;
            Hashtable<ThreadGroup, List<ThreadGroup>> threadGroups = new Hashtable<ThreadGroup, List<ThreadGroup>>();
            for (Map.Entry entry : threadGroupMapping.entrySet()) {
                ThreadGroup key = (ThreadGroup)entry.getKey();
                ThreadGroup root = this.addGroup(key, threadGroups);
                if (rootGroup == null) {
                    rootGroup = root;
                    continue;
                }
                if (rootGroup == root || !TroubleshootingPanel.this.logger.isErrorEnabled()) continue;
                TroubleshootingPanel.this.logger.error("root={}, rootGroup={}", root, (Object)rootGroup);
            }
            if (rootGroup == null) {
                if (TroubleshootingPanel.this.logger.isErrorEnabled()) {
                    TroubleshootingPanel.this.logger.error("Couldn't resolve root ThreadGroup!");
                }
                return;
            }
            this.appendGroup(0, builder, rootGroup, threadGroups, threadGroupMapping);
            if (nullList.size() > 0) {
                builder.append("no group:\n");
                for (ThreadHolder threadHolder : nullList) {
                    this.appendThread(1, builder, threadHolder);
                }
            }
            TroubleshootingPanel.this.preferencesDialog.getMainFrame().copyText(builder.toString());
        }

        private void appendGroup(int indent, StringBuilder builder, ThreadGroup group, Map<ThreadGroup, List<ThreadGroup>> threadGroups, Map<ThreadGroup, List<ThreadHolder>> threadGroupMapping) {
            List<ThreadHolder> threads;
            String indentStr = this.createIndent(indent);
            builder.append(indentStr).append("ThreadGroup[name='").append(group.getName()).append("', daemon=").append(group.isDaemon()).append(", destroyed=").append(group.isDestroyed()).append(", maxPriority=").append(group.getMaxPriority()).append("]\n");
            List<ThreadGroup> groups = threadGroups.get(group);
            if (groups != null && groups.size() > 0) {
                builder.append(indentStr).append("groups = {\n");
                Collections.sort(groups, new ThreadGroupComparator());
                for (ThreadGroup current : groups) {
                    this.appendGroup(indent + 1, builder, current, threadGroups, threadGroupMapping);
                }
                builder.append(indentStr).append("}\n");
            }
            if ((threads = threadGroupMapping.get(group)) != null && threads.size() > 0) {
                builder.append(indentStr).append("threads = {\n");
                Collections.sort(threads);
                for (ThreadHolder current : threads) {
                    this.appendThread(indent + 1, builder, current);
                }
                builder.append(indentStr).append("}\n");
            }
        }

        private void appendThread(int indent, StringBuilder builder, ThreadHolder threadHolder) {
            String indentStr = this.createIndent(indent);
            Thread t = threadHolder.getThread();
            StackTraceElement[] ste = threadHolder.getStackTraceElements();
            builder.append(indentStr).append("Thread[name=").append(t.getName()).append(", id=").append(t.getId()).append(", priority=").append(t.getPriority()).append(", state=").append((Object)t.getState()).append(", daemon=").append(t.isDaemon()).append(", alive=").append(t.isAlive()).append(", interrupted=").append(t.isInterrupted()).append("]\n");
            this.appendStackTraceElements(indent + 1, builder, ste);
        }

        private void appendStackTraceElements(int indent, StringBuilder builder, StackTraceElement[] stackTraceElements) {
            String indentStr = this.createIndent(indent);
            for (StackTraceElement current : stackTraceElements) {
                builder.append(indentStr).append("at ").append(current).append("\n");
            }
        }

        private String createIndent(int indent) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                result.append("\t");
            }
            return result.toString();
        }

        private ThreadGroup addGroup(ThreadGroup group, Map<ThreadGroup, List<ThreadGroup>> threadGroups) {
            ThreadGroup parentGroup = group.getParent();
            if (parentGroup == null) {
                return group;
            }
            List<ThreadGroup> list = threadGroups.get(parentGroup);
            if (list == null) {
                list = new ArrayList<ThreadGroup>();
                threadGroups.put(parentGroup, list);
            }
            if (!list.contains(group)) {
                list.add(group);
            }
            return this.addGroup(parentGroup, threadGroups);
        }
    }

    public class CopySystemPropertiesAction
    extends AbstractAction {
        private static final long serialVersionUID = -2375370123070284280L;

        public CopySystemPropertiesAction() {
            super("Copy properties");
            this.putValue("ShortDescription", "Copy system properties to the clipboard.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties props = System.getProperties();
            TreeMap<String, String> sortedProps = new TreeMap<String, String>();
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String current = (String)keys.nextElement();
                String value = props.getProperty(current);
                if ("line.separator".equals(current)) {
                    value = value.replace("\n", "\\n");
                    value = value.replace("\r", "\\r");
                }
                sortedProps.put(current, value);
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry current : sortedProps.entrySet()) {
                builder.append((String)current.getKey()).append("=").append((String)current.getValue()).append("\n");
            }
            TroubleshootingPanel.this.preferencesDialog.getMainFrame().copyText(builder.toString());
        }
    }

    public class DeleteAllLogsAction
    extends AbstractAction {
        private static final long serialVersionUID = 5218712842261152334L;

        public DeleteAllLogsAction() {
            super("Delete *all* logs.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Delete all log files?";
            String message = "This deletes *all* log files, even the Lilith logs and the global logs!\nDelete all log files right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            MainFrame mainFrame = TroubleshootingPanel.this.preferencesDialog.getMainFrame();
            ViewManager levm = mainFrame.getLoggingEventViewManager();
            Map views = levm.getViews();
            for (Map.Entry current : views.entrySet()) {
                TroubleshootingPanel.reset(current.getValue());
            }
            levm = mainFrame.getAccessEventViewManager();
            views = levm.getViews();
            for (Map.Entry current : views.entrySet()) {
                TroubleshootingPanel.reset(current.getValue());
            }
            mainFrame.cleanAllInactiveLogs();
        }
    }

    public class InitExampleScriptsAction
    extends AbstractAction {
        private static final long serialVersionUID = -4197531497673863904L;

        public InitExampleScriptsAction() {
            super("Reinitialize example groovy conditions.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Reinitialize example groovy conditions?";
            String message = "This overwrites all example groovy conditions. Other conditions are not changed!\nReinitialize example groovy conditions right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            ApplicationPreferences prefs = TroubleshootingPanel.this.preferencesDialog.getApplicationPreferences();
            prefs.installExampleConditions();
        }
    }

    public class InitDetailsViewAction
    extends AbstractAction {
        private static final long serialVersionUID = 8374235720899930441L;

        public InitDetailsViewAction() {
            super("Reinitialize details view files.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Reinitialize details view files?";
            String message = "This resets all details view related files, all manual changes will be lost!\nReinitialize details view right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            ApplicationPreferences prefs = TroubleshootingPanel.this.preferencesDialog.getApplicationPreferences();
            prefs.initDetailsViewRoot(true);
        }
    }
}

