/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFilteringPanel
extends JPanel {
    final Logger logger = LoggerFactory.getLogger(SourceFilteringPanel.class);
    private BlacklistAction blacklistAction;
    private WhitelistAction whitelistAction;
    private PreferencesDialog preferencesDialog;
    private JComboBox blackListNames;
    private JComboBox whiteListNames;
    private DefaultComboBoxModel blackListNamesModel;
    private DefaultComboBoxModel whiteListNamesModel;
    private JRadioButton disabledButton;
    private JRadioButton blacklistButton;
    private JRadioButton whitelistButton;
    private ListItemListener listItemListener;

    public SourceFilteringPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.createUI();
    }

    private void createUI() {
        DisabledAction disabledAction = new DisabledAction();
        this.blacklistAction = new BlacklistAction();
        this.whitelistAction = new WhitelistAction();
        this.disabledButton = new JRadioButton(disabledAction);
        this.blacklistButton = new JRadioButton(this.blacklistAction);
        this.whitelistButton = new JRadioButton(this.whitelistAction);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.disabledButton);
        buttonGroup.add(this.blacklistButton);
        buttonGroup.add(this.whitelistButton);
        this.blackListNamesModel = new DefaultComboBoxModel();
        this.whiteListNamesModel = new DefaultComboBoxModel();
        this.blackListNames = new JComboBox(this.blackListNamesModel);
        this.whiteListNames = new JComboBox(this.whiteListNamesModel);
        this.listItemListener = new ListItemListener();
        this.blackListNames.addItemListener(this.listItemListener);
        this.whiteListNames.addItemListener(this.listItemListener);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.disabledButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.blacklistButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.blackListNames, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.whitelistButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        this.add((Component)this.whiteListNames, gbc);
    }

    public void initUI() {
        String fallbackSourceListName;
        this.listItemListener.setInitializing(true);
        List<String> sourceListNames = this.preferencesDialog.getSourceListNames();
        boolean hasSourceLists = false;
        if (sourceListNames.size() > 0) {
            Collections.sort(sourceListNames);
            fallbackSourceListName = sourceListNames.get(0);
            hasSourceLists = true;
        } else {
            fallbackSourceListName = "";
        }
        this.blacklistAction.setEnabled(hasSourceLists);
        this.whitelistAction.setEnabled(hasSourceLists);
        this.blackListNames.setEnabled(hasSourceLists);
        this.whiteListNames.setEnabled(hasSourceLists);
        this.blackListNamesModel.removeAllElements();
        this.whiteListNamesModel.removeAllElements();
        ApplicationPreferences.SourceFiltering filtering = this.preferencesDialog.getSourceFiltering();
        String blackListName = this.preferencesDialog.getBlackListName();
        String whiteListName = this.preferencesDialog.getWhiteListName();
        if (!sourceListNames.contains(blackListName)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Resetting blackListName '{}' to '{}'.", (Object)blackListName, (Object)fallbackSourceListName);
            }
            blackListName = fallbackSourceListName;
            this.preferencesDialog.setBlackListName(blackListName);
            if (filtering == ApplicationPreferences.SourceFiltering.BLACKLIST) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Resetting filtering '{}'.", (Object)filtering);
                }
                filtering = ApplicationPreferences.SourceFiltering.NONE;
                this.preferencesDialog.setSourceFiltering(filtering);
            }
        }
        if (!sourceListNames.contains(whiteListName)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Resetting whiteListName '{}' to '{}'.", (Object)whiteListName, (Object)fallbackSourceListName);
            }
            whiteListName = fallbackSourceListName;
            this.preferencesDialog.setWhiteListName(whiteListName);
            if (filtering == ApplicationPreferences.SourceFiltering.WHITELIST) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Resetting filtering '{}'.", (Object)filtering);
                }
                filtering = ApplicationPreferences.SourceFiltering.NONE;
                this.preferencesDialog.setSourceFiltering(filtering);
            }
        }
        if (hasSourceLists) {
            for (String s : sourceListNames) {
                this.blackListNamesModel.addElement(s);
                this.whiteListNamesModel.addElement(s);
            }
            this.blackListNamesModel.setSelectedItem(blackListName);
            this.whiteListNamesModel.setSelectedItem(whiteListName);
        }
        switch (filtering) {
            case BLACKLIST: {
                this.blacklistButton.setSelected(true);
                break;
            }
            case WHITELIST: {
                this.whitelistButton.setSelected(true);
                break;
            }
            default: {
                this.disabledButton.setSelected(true);
            }
        }
        this.listItemListener.setInitializing(false);
    }

    private class ListItemListener
    implements ItemListener {
        private boolean initializing = false;

        private ListItemListener() {
        }

        public boolean isInitializing() {
            return this.initializing;
        }

        public void setInitializing(boolean initializing) {
            this.initializing = initializing;
        }

        public void itemStateChanged(ItemEvent e) {
            if (!this.initializing && e.getStateChange() == 1) {
                String item = (String)e.getItem();
                if (e.getSource() == SourceFilteringPanel.this.whiteListNames) {
                    if (SourceFilteringPanel.this.logger.isInfoEnabled()) {
                        SourceFilteringPanel.this.logger.info("WhiteList Selected: {}", (Object)item);
                    }
                    SourceFilteringPanel.this.preferencesDialog.setWhiteListName(item);
                } else if (e.getSource() == SourceFilteringPanel.this.blackListNames) {
                    if (SourceFilteringPanel.this.logger.isInfoEnabled()) {
                        SourceFilteringPanel.this.logger.info("BlackList Selected: {}", (Object)item);
                    }
                    SourceFilteringPanel.this.preferencesDialog.setBlackListName(item);
                }
            }
        }
    }

    private class WhitelistAction
    extends AbstractAction {
        private static final long serialVersionUID = -3403085106091507255L;

        public WhitelistAction() {
            super("Whitelist on...");
            this.putValue("ShortDescription", "Whitelist on the selected source list.");
        }

        public void actionPerformed(ActionEvent e) {
            if (SourceFilteringPanel.this.logger.isInfoEnabled()) {
                SourceFilteringPanel.this.logger.info("Whitelist");
            }
            SourceFilteringPanel.this.preferencesDialog.setSourceFiltering(ApplicationPreferences.SourceFiltering.WHITELIST);
        }
    }

    private class BlacklistAction
    extends AbstractAction {
        private static final long serialVersionUID = -1181737422196108645L;

        public BlacklistAction() {
            super("Blacklist on...");
            this.putValue("ShortDescription", "Blacklist on the selected source list.");
        }

        public void actionPerformed(ActionEvent e) {
            if (SourceFilteringPanel.this.logger.isInfoEnabled()) {
                SourceFilteringPanel.this.logger.info("Blacklist");
            }
            SourceFilteringPanel.this.preferencesDialog.setSourceFiltering(ApplicationPreferences.SourceFiltering.BLACKLIST);
        }
    }

    private class DisabledAction
    extends AbstractAction {
        private static final long serialVersionUID = -4154256012969198212L;

        public DisabledAction() {
            super("None");
            this.putValue("ShortDescription", "No source filtering.");
        }

        public void actionPerformed(ActionEvent e) {
            if (SourceFilteringPanel.this.logger.isInfoEnabled()) {
                SourceFilteringPanel.this.logger.info("Disabled");
            }
            SourceFilteringPanel.this.preferencesDialog.setSourceFiltering(ApplicationPreferences.SourceFiltering.NONE);
        }
    }
}

