/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.conditions.Condition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabbedPaneViewContainer<T extends Serializable>
extends ViewContainer<T> {
    private final Logger logger = LoggerFactory.getLogger(TabbedPaneViewContainer.class);
    private JTabbedPane pane = new JTabbedPane(1);
    private SourceChangeListener sourceChangeListener;
    private boolean disposed = false;
    private EventWrapper<T> selectedEvent;
    private boolean showingStatusbar;

    public TabbedPaneViewContainer(MainFrame mainFrame, EventSource<T> eventSource) {
        super(mainFrame, eventSource);
        this.pane.setTabLayoutPolicy(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        this.pane.addChangeListener(new TabChangeListener());
        this.sourceChangeListener = new SourceChangeListener();
        this.addView(this.getDefaultView());
    }

    @Override
    public void addView(EventWrapperViewPanel<T> view) {
        Condition filter;
        EventSource<T> source = view.getEventSource();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Adding view for {}", source);
        }
        if ((filter = source.getFilter()) == null) {
            this.pane.insertTab("Unfiltered", null, view, null, 0);
        } else {
            String toolTip;
            String title;
            SavedCondition savedCondition = this.getMainFrame().getApplicationPreferences().resolveSavedCondition(filter);
            if (savedCondition != null) {
                title = savedCondition.getName();
                toolTip = filter.toString();
            } else {
                String text;
                title = text = filter.toString();
                toolTip = text;
            }
            this.pane.insertTab(title, null, view, toolTip, this.pane.getTabCount());
        }
        this.pane.setSelectedComponent(view);
        view.addPropertyChangeListener(this.sourceChangeListener);
        view.requestFocusInWindow();
        this.fireChange();
    }

    @Override
    public void updateViews() {
        for (int i = 0; i < this.pane.getTabCount(); ++i) {
            EventWrapperViewPanel current = (EventWrapperViewPanel)this.pane.getComponentAt(i);
            EventSource source = current.getEventSource();
            current.updateView();
            Condition condition = source.getFilter();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Condition: {}", condition);
            }
            if (condition != null) {
                String toolTip;
                String title;
                SavedCondition savedCondition = this.getMainFrame().getApplicationPreferences().resolveSavedCondition(condition);
                if (savedCondition != null) {
                    title = savedCondition.getName();
                    toolTip = condition.toString();
                } else {
                    String text;
                    title = text = condition.toString();
                    toolTip = text;
                }
                this.pane.setTitleAt(i, title);
                this.pane.setToolTipTextAt(i, toolTip);
            }
            this.pane.repaint();
        }
    }

    @Override
    public void updateViewScale(double scale) {
        for (int i = 0; i < this.pane.getTabCount(); ++i) {
            EventWrapperViewPanel current = (EventWrapperViewPanel)this.pane.getComponentAt(i);
            current.setScaleFactor(scale);
        }
    }

    @Override
    public void removeView(EventWrapperViewPanel<T> view, boolean dispose) {
        this.pane.remove(view);
        view.removePropertyChangeListener(this.sourceChangeListener);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removed view {}.", view);
        }
        if (dispose) {
            view.dispose();
            Buffer buffer = view.getEventSource().getBuffer();
            Dispose.dispose((Object)buffer);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Disposed view {}.", view);
            }
        }
        this.fireChange();
    }

    @Override
    public void showDefaultView() {
        this.pane.setSelectedIndex(0);
        this.fireChange();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addNotify - parent: {}", this.getParent());
        }
    }

    @Override
    public void scrollToEvent() {
        EventWrapperViewPanel<T> selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.scrollToEvent();
            this.setSelectedEvent(selectedView.getSelectedEvent());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeNotify");
        }
    }

    private void selectedViewChanged() {
        EventWrapperViewPanel<T> selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.scrollToEvent();
            this.setSelectedEvent(selectedView.getSelectedEvent());
        } else {
            this.setSelectedEvent(null);
        }
        this.fireChange();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposed = true;
        int tabCount = this.pane.getTabCount();
        ArrayList<Component> removedPanes = new ArrayList<Component>(tabCount - 1);
        for (int i = 0; i < tabCount; ++i) {
            removedPanes.add(this.pane.getComponentAt(i));
        }
        for (Component comp : removedPanes) {
            if (!(comp instanceof EventWrapperViewPanel)) continue;
            EventWrapperViewPanel lvp = (EventWrapperViewPanel)comp;
            this.removeView(lvp, true);
        }
        this.fireChange();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setSelectedEvent(EventWrapper<T> selectedEvent) {
        EventWrapper<T> oldValue = this.selectedEvent;
        EventWrapper<T> newValue = this.selectedEvent = selectedEvent;
        this.firePropertyChange("selectedEvent", oldValue, newValue);
    }

    @Override
    public EventWrapper<T> getSelectedEvent() {
        return this.selectedEvent;
    }

    @Override
    public EventWrapperViewPanel<T> getViewAt(int index) {
        if (index >= 0 && index < this.pane.getTabCount()) {
            return (EventWrapperViewPanel)this.pane.getComponentAt(index);
        }
        return null;
    }

    @Override
    public EventWrapperViewPanel<T> getSelectedView() {
        return (EventWrapperViewPanel)this.pane.getSelectedComponent();
    }

    @Override
    public void setViewIndex(int index) {
        this.pane.setSelectedIndex(index);
        this.fireChange();
    }

    @Override
    public int getViewIndex() {
        return this.pane.getSelectedIndex();
    }

    @Override
    public int getViewCount() {
        return this.pane.getTabCount();
    }

    @Override
    public void closeCurrentFilter() {
        int tabIndex = this.pane.getSelectedIndex();
        Component comp = this.pane.getComponentAt(tabIndex);
        if (comp != null && comp instanceof EventWrapperViewPanel) {
            EventWrapperViewPanel lvp = (EventWrapperViewPanel)comp;
            this.removeView(lvp, true);
        }
        this.fireChange();
    }

    @Override
    public void closeOtherFilters() {
        int tabIndex = this.pane.getSelectedIndex();
        int tabCount = this.pane.getTabCount();
        ArrayList<Component> removedPanes = new ArrayList<Component>(tabCount - 1);
        for (int i = 1; i < tabCount; ++i) {
            if (i == tabIndex) continue;
            removedPanes.add(this.pane.getComponentAt(i));
        }
        for (Component comp : removedPanes) {
            if (!(comp instanceof EventWrapperViewPanel)) continue;
            EventWrapperViewPanel lvp = (EventWrapperViewPanel)comp;
            this.removeView(lvp, true);
        }
        this.fireChange();
    }

    @Override
    public void closeAllFilters() {
        int tabCount = this.pane.getTabCount();
        ArrayList<Component> removedPanes = new ArrayList<Component>(tabCount - 1);
        for (int i = 1; i < tabCount; ++i) {
            removedPanes.add(this.pane.getComponentAt(i));
        }
        for (Component comp : removedPanes) {
            if (!(comp instanceof EventWrapperViewPanel)) continue;
            EventWrapperViewPanel lvp = (EventWrapperViewPanel)comp;
            this.removeView(lvp, true);
        }
        this.fireChange();
    }

    @Override
    public void setShowingStatusbar(boolean showingStatusbar) {
        this.showingStatusbar = showingStatusbar;
        int tabCount = this.pane.getTabCount();
        ArrayList<Component> panes = new ArrayList<Component>(tabCount);
        for (int i = 0; i < tabCount; ++i) {
            panes.add(this.pane.getComponentAt(i));
        }
        for (Component comp : panes) {
            if (!(comp instanceof EventWrapperViewPanel)) continue;
            EventWrapperViewPanel lvp = (EventWrapperViewPanel)comp;
            lvp.setShowingStatusBar(showingStatusbar);
        }
    }

    private class SourceChangeListener
    implements PropertyChangeListener {
        private SourceChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("eventSource".equals(propName)) {
                if (TabbedPaneViewContainer.this.logger.isDebugEnabled()) {
                    TabbedPaneViewContainer.this.logger.debug("EventSource changed: {}", evt.getNewValue());
                }
                EventWrapperViewPanel lvp = (EventWrapperViewPanel)evt.getSource();
                TabbedPaneViewContainer.this.removeView(lvp, false);
                TabbedPaneViewContainer.this.addView(lvp);
            } else if ("selectedEvent".equals(propName)) {
                if (TabbedPaneViewContainer.this.getSelectedView() == evt.getSource()) {
                    if (TabbedPaneViewContainer.this.logger.isDebugEnabled()) {
                        TabbedPaneViewContainer.this.logger.debug("EventSource changed: {}", evt.getNewValue());
                    }
                    TabbedPaneViewContainer.this.setSelectedEvent((EventWrapper)evt.getNewValue());
                }
            } else {
                if (TabbedPaneViewContainer.this.logger.isDebugEnabled()) {
                    TabbedPaneViewContainer.this.logger.debug("Other change: {}", (Object)propName);
                }
                TabbedPaneViewContainer.this.fireChange();
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int selected = TabbedPaneViewContainer.this.pane.getSelectedIndex();
            if (TabbedPaneViewContainer.this.logger.isDebugEnabled()) {
                TabbedPaneViewContainer.this.logger.debug("Selected tab: {}", selected);
            }
            TabbedPaneViewContainer.this.selectedViewChanged();
            TabbedPaneViewContainer.this.fireChange();
        }
    }
}

