/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.statistics.StatisticsPanel;
import de.huxhorn.sulky.swing.Windows;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(StatisticsDialog.class);
    private StatisticsPanel statisticsPanel;
    private MainFrame mainFrame;

    public StatisticsDialog(MainFrame owner) {
        super(owner);
        this.mainFrame = owner;
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.setResizable(false);
        URL url = StatisticsDialog.class.getResource("/tango/16x16/apps/utilities-system-monitor.png");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            Windows.setIconImage((Window)this, (Image)icon.getImage());
        }
        this.statisticsPanel = new StatisticsPanel(owner);
        this.statisticsPanel.addPropertyChangeListener(new SourceChangeListener());
        this.setContentPane(this.statisticsPanel);
    }

    public void setSourceIdentifier(SourceIdentifier sourceIdentifier) {
        this.statisticsPanel.setSourceIdentifier(sourceIdentifier);
    }

    public SourceIdentifier getSourceIdentifier() {
        return this.statisticsPanel.getSourceIdentifier();
    }

    private class SourceChangeListener
    implements PropertyChangeListener {
        private SourceChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            if ("sourceIdentifier".equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof SourceIdentifier) {
                SourceIdentifier sourceIdentifier = (SourceIdentifier)newValue;
                StatisticsDialog.this.setTitle("Statistics for '" + StatisticsDialog.this.mainFrame.getPrimarySourceTitle(sourceIdentifier) + "'...");
            }
        }
    }
}

