/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.buffers.FilteringBuffer;
import de.huxhorn.lilith.buffers.SoftReferenceCachingBuffer;
import de.huxhorn.lilith.conditions.CallLocationCondition;
import de.huxhorn.lilith.conditions.EventContainsCondition;
import de.huxhorn.lilith.conditions.GroovyCondition;
import de.huxhorn.lilith.conditions.LevelCondition;
import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.LoggerEqualsCondition;
import de.huxhorn.lilith.conditions.LoggerStartsWithCondition;
import de.huxhorn.lilith.conditions.MessageContainsCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.callables.CallableMetaData;
import de.huxhorn.lilith.swing.callables.FindNextCallable;
import de.huxhorn.lilith.swing.callables.FindPreviousCallable;
import de.huxhorn.lilith.swing.linklistener.StackTraceElementLinkListener;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.table.EventWrapperViewTable;
import de.huxhorn.lilith.swing.table.model.EventWrapperTableModel;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.conditions.And;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.Not;
import de.huxhorn.sulky.formatting.HumanReadable;
import de.huxhorn.sulky.swing.KeyStrokes;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;
import org.xhtmlrenderer.swing.SelectionHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventWrapperViewPanel<T extends Serializable>
extends JPanel
implements DisposeOperation {
    public static final String STATE_PROPERTY = "state";
    public static final String FILTER_CONDITION_PROPERTY = "filterCondition";
    public static final String EVENT_SOURCE_PROPERTY = "eventSource";
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String PAUSED_PROPERTY = "paused";
    public static final String SELECTED_EVENT_PROPERTY = "selectedEvent";
    private static final String GROOVY_IDENTIFIER = "#groovy#";
    private static final String SAVED_CONDITION_IDENTIFIER = "#condition#";
    private static final Color ERROR_COLOR = new Color(0xFFAAAA);
    private final Logger logger = LoggerFactory.getLogger(EventWrapperViewPanel.class);
    private EventSource<T> eventSource;
    private LoggingViewState state;
    private MainFrame mainFrame;
    private boolean showingFilters;
    private Condition filterCondition;
    private TaskManager<Long> taskManager;
    private EventWrapperViewTable<T> table;
    private EventWrapperTableModel<T> tableModel;
    private FindNextAction findNextAction;
    private FindPreviousAction findPrevAction;
    private CloseFindAction closeFindAction;
    private JButton findPrevButton;
    private JButton findNextButton;
    private JToolBar findPanel;
    private JToggleButton findNotButton;
    private JComboBox findTypeCombo;
    private JTextField findTextField;
    private JLabel statusLabel;
    private JScrollBar verticalLogScrollbar;
    private StatusTableModelListener tableModelListener;
    private FocusTraversalPolicy focusTraversalPolicy;
    private MatteBorder focusedBorder;
    private MatteBorder unfocusedBorder;
    private DecimalFormat eventCountFormat = new DecimalFormat("#,###");
    private FindResultListener findResultListener;
    private ScalableXHTMLPanel messagePane;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private EventWrapper<T> selectedEvent;
    private SelectionHighlighter.CopyAction copyAction;
    private double scale;
    private JScrollPane tableScrollPane;
    private static final String EVENT_CONTAINS_CONDITION = "event.contains";
    private static final String MESSAGE_CONTAINS_CONDITION = "message.contains";
    private static final String LOGGER_STARTS_WITH_CONDITION = "logger.startsWith";
    private static final String LOGGER_EQUALS_CONDITION = "logger.equals";
    private static final String LEVEL_CONDITION = "Level>=";
    private static final String CALL_LOCATION_CONDITION = "CallLocation";
    private static final String[] DEFAULT_CONDITIONS = new String[]{"event.contains", "message.contains", "logger.startsWith", "logger.equals", "Level>=", "CallLocation"};

    public EventWrapperViewPanel(MainFrame mainFrame, EventSource<T> eventSource) {
        super(true);
        this.taskManager = mainFrame.getLongWorkManager();
        this.findResultListener = new FindResultListener();
        this.taskManager.addTaskListener((TaskListener)this.findResultListener);
        this.mainFrame = mainFrame;
        this.eventSource = eventSource;
        this.showingFilters = false;
        this.tableModelListener = new StatusTableModelListener();
        this.scale = mainFrame.getApplicationPreferences().getScaleFactor();
        this.initUi();
    }

    private void initUi() {
        Insets borderInsets = new Insets(2, 2, 2, 2);
        this.focusedBorder = new MatteBorder(borderInsets, Color.YELLOW);
        this.unfocusedBorder = new MatteBorder(borderInsets, Color.WHITE);
        SoftReferenceCachingBuffer<EventWrapper<T>> cachedBuffer = this.createCachedBuffer(this.eventSource.getBuffer());
        this.tableModel = this.createTableModel(cachedBuffer);
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.table = this.createTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(new TableRowSelectionListener());
        this.tableScrollPane = new JScrollPane(this.table);
        this.table.addMouseListener(new TableMouseListener());
        this.tableScrollPane.addMouseListener(new ScrollPaneMouseListener());
        this.tableScrollPane.setPreferredSize(new Dimension(400, 400));
        this.verticalLogScrollbar = this.tableScrollPane.getVerticalScrollBar();
        this.messagePane = new ScalableXHTMLPanel();
        this.messagePane.setScale(this.mainFrame.getApplicationPreferences().getScaleFactor());
        SelectionHighlighter messagePaneCaret = new SelectionHighlighter();
        messagePaneCaret.install((XHTMLPanel)this.messagePane);
        this.copyAction = new SelectionHighlighter.CopyAction();
        this.copyAction.install(messagePaneCaret);
        this.messagePane.addMouseListener((MouseListener)new EventViewMouseListener());
        this.messagePane.addFocusListener((FocusListener)new MessageFocusListener());
        this.messagePane.setBorder((Border)this.unfocusedBorder);
        List mouseTrackingList = this.messagePane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.messagePane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
            }
        }
        this.messagePane.addMouseTrackingListener((FSMouseListener)new StackTraceElementLinkListener(this.mainFrame));
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
        FSScrollPane messageScrollPane = new FSScrollPane((JPanel)this.messagePane);
        messageScrollPane.setPreferredSize(new Dimension(400, 400));
        MouseWheelListener[] mwl = messageScrollPane.getMouseWheelListeners();
        if (mwl != null) {
            for (MouseWheelListener current : mwl) {
                messageScrollPane.removeMouseWheelListener(current);
            }
        }
        messageScrollPane.addMouseWheelListener((MouseWheelListener)new WrappingMouseWheelListener(mwl));
        JSplitPane splitPane = new JSplitPane(0, this.tableScrollPane, (Component)messageScrollPane);
        SplitPaneListener splitPaneListener = new SplitPaneListener();
        splitPane.addPropertyChangeListener(splitPaneListener);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        ScrollbarChangeListner scrollBarChangeListener = new ScrollbarChangeListner();
        this.verticalLogScrollbar.getModel().addChangeListener(scrollBarChangeListener);
        this.table.addPropertyChangeListener(new EventWrapperViewChangeListener());
        this.focusTraversalPolicy = new MyFocusTraversalPolicy();
        this.initFindPanel();
        ReplaceFilterAction replaceFilterAction = new ReplaceFilterAction();
        FindTextFieldListener findTextFieldListener = new FindTextFieldListener();
        this.findTextField.addActionListener(findTextFieldListener);
        this.findTextField.getDocument().addDocumentListener(findTextFieldListener);
        this.findTextField.setBackground(Color.WHITE);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel statusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        bottomPanel.add((Component)this.findPanel, "Center");
        bottomPanel.add((Component)statusPanel, "South");
        this.statusLabel = new JLabel();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        statusPanel.add((Component)this.statusLabel, gbc);
        this.add((Component)bottomPanel, "South");
        this.setScrollingToBottom(false);
        this.setPaused(false);
        this.setFocusTraversalPolicy(this.focusTraversalPolicy);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("table.isFocusCycleRoot()={}", this.table.isFocusCycleRoot());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("table.isFocusTraversalPolicyProvider()={}", this.table.isFocusTraversalPolicyProvider());
        }
        this.table.setFocusTraversalPolicy(this.focusTraversalPolicy);
        this.table.setFocusCycleRoot(true);
        this.table.setFocusTraversalKeys(0, this.getFocusTraversalKeys(0));
        this.table.setFocusTraversalKeys(1, this.getFocusTraversalKeys(1));
        this.updateStatusText();
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findNextAction, (String)"FIND_NEXT_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findPrevAction, (String)"FIND_PREV_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.closeFindAction, (String)"CLOSE_FIND_ACTION");
        KeyStrokes.registerCommand((JComponent)this.findTextField, (Action)replaceFilterAction, (String)"REPLACE_FILTER_ACTION");
        splitPane.setDividerLocation(0.5);
        this.setShowingStatusBar(this.mainFrame.getApplicationPreferences().isShowingStatusbar());
    }

    private void initFindPanel() {
        this.findPanel = new JToolBar(0);
        this.findPanel.setFloatable(false);
        this.findPanel.setFocusTraversalPolicy(this.focusTraversalPolicy);
        this.findPanel.setFocusCycleRoot(true);
        this.closeFindAction = new CloseFindAction();
        JButton findViewButton = new JButton(this.closeFindAction);
        findViewButton.setMargin(new Insets(0, 0, 0, 0));
        this.findPanel.add(findViewButton);
        this.findPanel.addSeparator();
        this.findPanel.add(new JLabel("Find: "));
        FindTypeSelectionActionListener findTypeModifiedListener = new FindTypeSelectionActionListener();
        this.findTypeCombo = new JComboBox();
        this.findTypeCombo.addActionListener(findTypeModifiedListener);
        this.findNotButton = new JToggleButton("!");
        this.findNotButton.addActionListener(findTypeModifiedListener);
        this.findNotButton.setToolTipText("Not - inverts condition");
        this.findNotButton.setMargin(new Insets(0, 0, 0, 0));
        this.findTextField = new JTextField();
        this.findTextField.setColumns(15);
        this.findPanel.add(this.findNotButton);
        this.findPanel.add(this.findTypeCombo);
        this.findPanel.add(this.findTextField);
        this.findPrevAction = new FindPreviousAction();
        this.findPrevButton = new JButton(this.findPrevAction);
        this.findPrevButton.setMargin(new Insets(0, 0, 0, 0));
        this.findPanel.add(this.findPrevButton);
        this.findNextAction = new FindNextAction();
        this.findNextButton = new JButton(this.findNextAction);
        this.findNextButton.setMargin(new Insets(0, 0, 0, 0));
        this.findPanel.add(this.findNextButton);
        this.enableFindComponents(true);
    }

    public EventWrapperViewTable<T> getTable() {
        return this.table;
    }

    public LoggingViewState getState() {
        if (!EventQueue.isDispatchThread() && this.logger.isWarnEnabled()) {
            this.logger.warn("!DispatchThread - getState: state=" + (Object)((Object)this.state), new Throwable());
        }
        return this.state;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setState(LoggingViewState state) {
        LoggingViewState oldValue = this.state;
        LoggingViewState newValue = this.state = state;
        this.firePropertyChange(STATE_PROPERTY, (Object)oldValue, (Object)newValue);
    }

    public boolean isShowingFilters() {
        return this.showingFilters;
    }

    public void setShowingFilters(boolean showingFilters) {
        this.showingFilters = showingFilters;
        if (showingFilters) {
            this.initTypeCombo();
            Condition condition = this.getFilterCondition();
            boolean not = false;
            if (condition instanceof Not) {
                Not notCondition = (Not)condition;
                not = true;
                condition = notCondition.getCondition();
            }
            if (condition != null) {
                GroovyCondition groovyCondition;
                String scriptFileName;
                String conditionName = null;
                if (condition instanceof EventContainsCondition) {
                    conditionName = EVENT_CONTAINS_CONDITION;
                } else if (condition instanceof MessageContainsCondition) {
                    conditionName = MESSAGE_CONTAINS_CONDITION;
                } else if (condition instanceof LoggerStartsWithCondition) {
                    conditionName = LOGGER_STARTS_WITH_CONDITION;
                } else if (condition instanceof LoggerEqualsCondition) {
                    conditionName = LOGGER_EQUALS_CONDITION;
                } else if (condition instanceof GroovyCondition && (scriptFileName = (groovyCondition = (GroovyCondition)condition).getScriptFileName()) != null) {
                    File scriptFile = new File(scriptFileName);
                    conditionName = scriptFile.getName();
                }
                if (conditionName != null) {
                    this.findTypeCombo.setSelectedItem(conditionName);
                }
            }
            this.findNotButton.setSelected(not);
        }
        this.findPanel.setVisible(showingFilters);
        if (showingFilters) {
            this.findTextField.requestFocusInWindow();
            this.findTextField.selectAll();
            this.applyFilter();
        }
        this.scrollToEvent();
    }

    public void scrollToEvent() {
        if (this.table.isScrollingToBottom()) {
            SwingUtilities.invokeLater(new ScrollToBottomRunnable());
        } else if (this.table.getSelectedRow() < 0) {
            SwingUtilities.invokeLater(new SelectFirstEventRunnable());
        }
    }

    public void setScaleFactor(double scale) {
        this.scale = scale;
        this.messagePane.setScale(scale);
    }

    public void updateView() {
        EventWrapper<T> selected = this.getSelectedEvent();
        if (selected != null) {
            this.initMessage(selected);
        } else {
            this.resetMessage();
        }
    }

    public void setShowingStatusBar(boolean showingStatusbar) {
        this.statusLabel.setVisible(showingStatusbar);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validate");
        }
    }

    private SoftReferenceCachingBuffer<EventWrapper<T>> createCachedBuffer(Buffer<EventWrapper<T>> buffer) {
        return new SoftReferenceCachingBuffer<EventWrapper<T>>(buffer);
    }

    void setEventSource(EventSource<T> eventSource) {
        EventSource<T> oldValue = this.eventSource;
        this.eventSource = eventSource;
        SoftReferenceCachingBuffer<EventWrapper<T>> cachedBuffer = this.createCachedBuffer(eventSource.getBuffer());
        this.tableModel.setBuffer(cachedBuffer);
        EventSource<T> newValue = this.eventSource;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("EventSource\nOld: {}\nNew: {}", oldValue, newValue);
        }
        this.firePropertyChange(EVENT_SOURCE_PROPERTY, oldValue, newValue);
    }

    public EventSource<T> getEventSource() {
        return this.eventSource;
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        Boolean oldValue = this.table.isScrollingToBottom();
        this.table.setScrollingToBottom(scrollingToBottom);
        Boolean newValue = this.table.isScrollingToBottom();
        this.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
    }

    public boolean isScrollingToBottom() {
        return this.table.isScrollingToBottom();
    }

    public boolean isPaused() {
        return this.tableModel.isPaused();
    }

    public void setPaused(boolean paused) {
        Boolean oldValue = this.tableModel.isPaused();
        this.tableModel.setPaused(paused);
        Boolean newValue = this.tableModel.isPaused();
        this.firePropertyChange(PAUSED_PROPERTY, oldValue, newValue);
    }

    public ViewContainer<T> resolveContainer() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ViewContainer); parent = parent.getParent()) {
        }
        return (ViewContainer)parent;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addNotify - parent: {}", this.getParent());
        }
        this.findPanel.setVisible(this.isShowingFilters());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeNotify");
        }
    }

    protected abstract EventWrapperTableModel<T> createTableModel(Buffer<EventWrapper<T>> var1);

    protected abstract EventWrapperViewTable<T> createTable(EventWrapperTableModel<T> var1);

    private void initTypeCombo() {
        Vector<String> itemsVector = new Vector<String>();
        itemsVector.addAll(Arrays.asList(DEFAULT_CONDITIONS));
        String[] groovyConditions = this.mainFrame.getAllConditionScriptFiles();
        if (groovyConditions != null) {
            itemsVector.addAll(Arrays.asList(groovyConditions));
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(itemsVector);
        this.findTypeCombo.setModel(model);
    }

    public void dispose() {
        this.tableModel.dispose();
        this.taskManager.removeTaskListener((TaskListener)this.findResultListener);
    }

    public boolean isDisposed() {
        return this.tableModel.isDisposed();
    }

    public void resetFind() {
        this.findTextField.setText("");
        this.setFilterCondition(null);
    }

    protected void setSelectedEvent(EventWrapper<T> selectedEvent) {
        EventWrapper<T> oldValue = this.selectedEvent;
        EventWrapper<T> newValue = this.selectedEvent = selectedEvent;
        this.firePropertyChange(SELECTED_EVENT_PROPERTY, oldValue, newValue);
    }

    public EventWrapper<T> getSelectedEvent() {
        return this.selectedEvent;
    }

    public EventWrapperTableModel<T> getTableModel() {
        return this.tableModel;
    }

    protected void initMessage(EventWrapper wrapper) {
        String message = this.mainFrame.createMessage(wrapper);
        URL messageViewRootUrl = this.mainFrame.getApplicationPreferences().getDetailsViewRootUrl();
        try {
            this.messagePane.setDocumentFromString(message, messageViewRootUrl.toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
            this.messagePane.setScale(this.scale);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while setting message " + message + "!", t);
            }
            this.writeErrorMessage(message);
        }
    }

    protected void resetMessage() {
        String message = "<html><body>No event selected.</body></html>";
        URL messageViewRootUrl = this.mainFrame.getApplicationPreferences().getDetailsViewRootUrl();
        try {
            this.messagePane.setDocumentFromString(message, messageViewRootUrl.toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
            this.messagePane.setScale(this.scale);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while setting message!", t);
            }
            this.writeErrorMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorMessage(String message) {
        FileOutputStream fos;
        block5: {
            File appPath = this.mainFrame.getApplicationPreferences().getStartupApplicationPath();
            File errorPath = new File(appPath, "errors");
            if (errorPath.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created errors directory '{}'.", errorPath);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSSZ");
            String filename = format.format(new Date());
            File errorFile = new File(errorPath, filename);
            fos = null;
            try {
                fos = new FileOutputStream(errorFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.append(message);
                osw.flush();
                if (!this.logger.isInfoEnabled()) break block5;
                this.logger.info("Faulty message written to '{}'.", (Object)errorFile.getAbsolutePath());
            }
            catch (Throwable e) {
                block6: {
                    try {
                        if (!this.logger.isWarnEnabled()) break block6;
                        this.logger.warn("Exception while writing faulty message to '" + errorFile.getAbsolutePath() + "'!", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private EventWrapper<T> getEventWrapper(Point p) {
        int row = this.table.rowAtPoint(p);
        if (-1 == row) {
            return null;
        }
        this.table.setScrollingToBottom(false);
        this.table.selectRow(row);
        return (EventWrapper)this.tableModel.getValueAt(row);
    }

    private void applyFilter() {
        LilithCondition condition;
        String text = this.findTextField.getText();
        String errorMessage = null;
        if (text == null) {
            text = "";
        }
        if (text.startsWith(GROOVY_IDENTIFIER)) {
            File resolvedScriptFile;
            String scriptName = text.substring(GROOVY_IDENTIFIER.length());
            int idx = scriptName.indexOf(35);
            if (idx > -1) {
                text = idx + 1 < scriptName.length() ? scriptName.substring(idx + 1) : "";
                scriptName = scriptName.substring(0, idx);
            } else {
                text = "";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GroovyCondition with scriptName '{}' and searchString '{}'", (Object)scriptName, (Object)text);
            }
            if ((resolvedScriptFile = this.mainFrame.resolveConditionScriptFile(scriptName)) != null) {
                condition = new GroovyCondition(resolvedScriptFile.getAbsolutePath(), text);
            } else {
                errorMessage = "Couldn't find groovy script '" + scriptName + "'.";
                condition = null;
            }
        } else if (text.startsWith(SAVED_CONDITION_IDENTIFIER)) {
            String conditionName = text.substring(SAVED_CONDITION_IDENTIFIER.length());
            SavedCondition savedCondition = this.mainFrame.getApplicationPreferences().resolveSavedCondition(conditionName);
            if (savedCondition != null) {
                condition = savedCondition.getCondition();
            } else {
                errorMessage = "Couldn't find saved condition '" + conditionName + "'.";
                condition = null;
            }
        } else {
            File resolvedScriptFile;
            String selectedType = (String)this.findTypeCombo.getSelectedItem();
            condition = EVENT_CONTAINS_CONDITION.equals(selectedType) ? new EventContainsCondition(text) : (MESSAGE_CONTAINS_CONDITION.equals(selectedType) ? new MessageContainsCondition(text) : (LOGGER_STARTS_WITH_CONDITION.equals(selectedType) ? new LoggerStartsWithCondition(text) : (LOGGER_EQUALS_CONDITION.equals(selectedType) ? new LoggerEqualsCondition(text) : (LEVEL_CONDITION.equals(selectedType) ? new LevelCondition(text) : (CALL_LOCATION_CONDITION.equals(selectedType) ? new CallLocationCondition(text) : ((resolvedScriptFile = this.mainFrame.resolveConditionScriptFile(selectedType)) != null ? new GroovyCondition(resolvedScriptFile.getAbsolutePath(), text) : null))))));
        }
        if (errorMessage != null) {
            this.findTextField.setBackground(ERROR_COLOR);
            this.findTextField.setToolTipText(errorMessage);
        } else {
            this.findTextField.setBackground(Color.WHITE);
            this.findTextField.setToolTipText(null);
        }
        if (condition != null && this.findNotButton.isSelected()) {
            condition = new Not((Condition)condition);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting condition: {}", condition);
        }
        this.setFilterCondition(condition);
    }

    public void setFilterCondition(Condition condition) {
        Condition old = this.filterCondition;
        this.filterCondition = condition;
        this.table.setFilterCondition(this.filterCondition);
        this.firePropertyChange(FILTER_CONDITION_PROPERTY, old, condition);
    }

    public Condition getFilterCondition() {
        return this.filterCondition;
    }

    public void clear() {
        this.tableModel.clear();
        this.table.requestFocusInWindow();
    }

    public void findPrevious(int currentRow, Condition condition) {
        if (condition != null) {
            FindPreviousCallable<T> callable = new FindPreviousCallable<T>(this.tableModel, currentRow, condition);
            this.executeFind((Callable<Long>)((Object)callable), "Find previous", currentRow, condition);
        }
    }

    public void findNext(int currentRow, Condition condition) {
        if (condition != null) {
            FindNextCallable<T> callable = new FindNextCallable<T>(this.tableModel, currentRow, condition);
            this.executeFind((Callable<Long>)((Object)callable), "Find next", currentRow, condition);
        }
    }

    public void setSelectedRow(int row) {
        if (row > -1) {
            if (this.isScrollingToBottom()) {
                this.setScrollingToBottom(false);
            }
            this.table.selectRow(row);
        }
    }

    public int getSelectedRow() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        return selectionModel.getLeadSelectionIndex();
    }

    private void updateStatusText() {
        int eventCount = this.tableModel.getRowCount();
        StringBuilder statusText = new StringBuilder();
        if (eventCount < 1) {
            statusText.append("No events.");
        } else {
            if (eventCount == 1) {
                statusText.append("One event.");
            } else {
                statusText.append(this.eventCountFormat.format(eventCount)).append(" events.");
            }
            long size = this.getSizeOnDisk();
            if (size > 0L) {
                statusText.append("   Size on disk: ").append(HumanReadable.getHumanReadableSize((long)size, (boolean)true, (boolean)false)).append("bytes");
                statusText.append("   Average event: ").append(HumanReadable.getHumanReadableSize((long)(size / (long)eventCount), (boolean)true, (boolean)false)).append("bytes");
            }
        }
        this.statusLabel.setText(statusText.toString());
    }

    protected long getSizeOnDisk() {
        Buffer buffer = this.getEventSource().getBuffer();
        if (buffer instanceof CodecFileBuffer) {
            CodecFileBuffer cfb = (CodecFileBuffer)buffer;
            return cfb.getDataFile().length();
        }
        return -1L;
    }

    public Buffer<EventWrapper<T>> getSourceBuffer() {
        Buffer buffer = this.eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            return filteringBuffer.getSourceBuffer();
        }
        return buffer;
    }

    public Condition getBufferCondition() {
        Buffer buffer = this.eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            return filteringBuffer.getCondition();
        }
        return null;
    }

    public void copySelection() {
        this.copyAction.actionPerformed(null);
    }

    public Condition getCombinedCondition() {
        Condition previousCondition = this.getBufferCondition();
        Condition currentFilter = this.table.getFilterCondition();
        if (previousCondition == null) {
            return currentFilter;
        }
        try {
            ArrayList<Condition> conditions;
            And and;
            Condition previousClone = previousCondition.clone();
            if (currentFilter == null) {
                return previousClone;
            }
            if (previousClone instanceof And) {
                and = (And)previousClone;
            } else {
                and = new And();
                conditions = new ArrayList<Condition>();
                conditions.add(previousClone);
                and.setConditions(conditions);
            }
            conditions = and.getConditions();
            if (conditions == null) {
                conditions = new ArrayList();
            }
            if (!conditions.contains(currentFilter)) {
                conditions.add(currentFilter);
            }
            if (conditions.size() > 1) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Setting and-conditions: {}", conditions);
                }
                and.setConditions(conditions);
                return and;
            }
            return currentFilter;
        }
        catch (CloneNotSupportedException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while cloning!", ex);
            }
            return null;
        }
    }

    private void createFilteredView() {
        ViewContainer<T> container = this.resolveContainer();
        if (container != null) {
            container.addFilteredView(this);
        }
    }

    public void showUnfilteredEvent() {
        Buffer buffer;
        ViewContainer<T> container;
        int row = this.getSelectedRow();
        if (row >= 0 && (container = this.resolveContainer()) != null && (buffer = this.eventSource.getBuffer()) instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            long unfilteredRow = filteringBuffer.getSourceIndex(row);
            if (unfilteredRow >= 0L) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Show unfiltered event {} for filtered event {}...", unfilteredRow, (Object)row);
                }
                EventWrapperViewPanel<T> defaultView = container.getDefaultView();
                container.showDefaultView();
                defaultView.setSelectedRow((int)unfilteredRow);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.info("Can't show unfiltered event {} for filtered event {}...", unfilteredRow, (Object)row);
            }
        }
    }

    public void focusTable() {
        this.table.requestFocusInWindow();
    }

    public void focusMessagePane() {
        this.messagePane.requestFocusInWindow();
    }

    private void executeFind(Callable<Long> callable, String name, int currentRow, Condition condition) {
        Map<String, String> metaData = CallableMetaData.createFindMetaData(condition, this.eventSource, currentRow);
        String description = "Executing '" + name + "' for condition " + metaData.get("Condition") + " on " + metaData.get("SourceIdentifier") + " starting at row " + currentRow + ".";
        this.enableFindComponents(false);
        this.findResultListener.setCallable(callable);
        Task task = this.taskManager.startTask(callable, name, description, metaData);
        ViewContainer<T> container = this.resolveContainer();
        if (container != null) {
            container.showSearchPanel((Task<Long>)task);
        }
    }

    void enableFindComponents(boolean enabled) {
        this.closeFindAction.setEnabled(enabled);
        this.findTextField.setEnabled(enabled);
        if (this.table.getFilterCondition() != null) {
            this.findPrevAction.setEnabled(enabled);
            this.findNextAction.setEnabled(enabled);
        } else {
            this.findPrevAction.setEnabled(false);
            this.findNextAction.setEnabled(false);
        }
    }

    protected abstract void closeConnection(SourceIdentifier var1);

    private class WrappingMouseWheelListener
    implements MouseWheelListener {
        private MouseWheelListener[] wrapped;

        private WrappingMouseWheelListener(MouseWheelListener[] wrapped) {
            this.wrapped = wrapped;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            block5: {
                block4: {
                    if (e.getModifiers() != KeyStrokes.COMMAND_KEYMASK) break block4;
                    int rotation = e.getWheelRotation();
                    boolean up = false;
                    if (rotation < 0) {
                        up = true;
                        rotation = -rotation;
                    }
                    for (int i = 0; i < rotation; ++i) {
                        if (up) {
                            EventWrapperViewPanel.this.mainFrame.zoomIn();
                            continue;
                        }
                        EventWrapperViewPanel.this.mainFrame.zoomOut();
                    }
                    break block5;
                }
                if (this.wrapped == null) break block5;
                for (MouseWheelListener current : this.wrapped) {
                    current.mouseWheelMoved(e);
                }
            }
        }
    }

    private class MessageFocusListener
    implements FocusListener {
        private MessageFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            EventWrapperViewPanel.this.messagePane.setBorder((Border)EventWrapperViewPanel.this.focusedBorder);
        }

        public void focusLost(FocusEvent e) {
            EventWrapperViewPanel.this.messagePane.setBorder((Border)EventWrapperViewPanel.this.unfocusedBorder);
        }
    }

    private class SplitPaneListener
    implements PropertyChangeListener {
        private SplitPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName;
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Splitpane change!");
            }
            if ("dividerLocation".equals(propertyName = evt.getPropertyName())) {
                EventWrapperViewPanel.this.scrollToEvent();
            }
        }
    }

    private class FindTypeSelectionActionListener
    implements ActionListener {
        private FindTypeSelectionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewPanel.this.applyFilter();
        }
    }

    private class StatusTableModelListener
    implements TableModelListener {
        private StatusTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("TableModelEvent: {}", e);
            }
            EventWrapperViewPanel.this.updateStatusText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FindResultListener
    implements TaskListener<Long> {
        private Callable<Long> callable;

        FindResultListener() {
        }

        public void taskCreated(Task<Long> longTask) {
        }

        public void executionFailed(Task<Long> task, ExecutionException exception) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionFailed:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution failed!", exception);
                }
                this.finished();
            }
        }

        public void executionFinished(Task<Long> task, Long result) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionFinished:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution finished: {}!", result);
                }
                if (result != null && result >= 0L) {
                    int row = result.intValue();
                    EventWrapperViewPanel.this.setSelectedRow(row);
                }
                this.finished();
            }
        }

        public void executionCanceled(Task<Long> task) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionCanceled:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution canceled.");
                }
                this.finished();
            }
        }

        public void progressUpdated(Task<Long> task, int progress) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in progressUpdated:\task: {}\n   this.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                ViewContainer container;
                if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                    EventWrapperViewPanel.this.logger.debug("Progress update: {}", progress);
                }
                if ((container = EventWrapperViewPanel.this.resolveContainer()) != null) {
                    ProgressGlassPane progressPanel = container.getProgressPanel();
                    progressPanel.setProgress(progress);
                }
            }
        }

        private void finished() {
            ViewContainer container;
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Executing FindResultListener.finished().");
            }
            if ((container = EventWrapperViewPanel.this.resolveContainer()) != null) {
                ProgressGlassPane progressPanel = container.getProgressPanel();
                progressPanel.getFindCancelAction().setTask(null);
                this.setCallable(null);
                container.hideSearchPanel();
            }
            EventWrapperViewPanel.this.enableFindComponents(true);
        }

        public void setCallable(Callable<Long> callable) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Setting task...\n     newCallable: " + callable + "\npreviousCallable: " + this.callable, new Throwable());
            }
            this.callable = callable;
        }
    }

    private class CloseFindAction
    extends AbstractAction {
        private static final long serialVersionUID = -7757686292973276423L;

        public CloseFindAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/emblems/emblem-unreadable.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Close");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container = EventWrapperViewPanel.this.resolveContainer();
            if (container != null) {
                ProgressGlassPane progressPanel = container.getProgressPanel();
                progressPanel.getFindCancelAction().cancelSearch();
                EventWrapperViewPanel.this.setShowingFilters(false);
            }
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = -8192948220602398223L;

        public FindPreviousAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-up.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find previous.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command G");
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewPanel.this.findPrevious(EventWrapperViewPanel.this.getSelectedRow(), EventWrapperViewPanel.this.getFilterCondition());
        }
    }

    private class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = -6469494975854597398L;

        public FindNextAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-down.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find next.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift G");
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewPanel.this.findNext(EventWrapperViewPanel.this.getSelectedRow(), EventWrapperViewPanel.this.getFilterCondition());
        }
    }

    private class FindTextFieldListener
    implements ActionListener,
    DocumentListener {
        private FindTextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewPanel.this.applyFilter();
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("modifiers: " + e.getModifiers());
            }
            EventWrapperViewPanel.this.findTextField.selectAll();
            EventWrapperViewPanel.this.createFilteredView();
        }

        public void insertUpdate(DocumentEvent e) {
            EventWrapperViewPanel.this.applyFilter();
        }

        public void removeUpdate(DocumentEvent e) {
            EventWrapperViewPanel.this.applyFilter();
        }

        public void changedUpdate(DocumentEvent e) {
            EventWrapperViewPanel.this.applyFilter();
        }
    }

    private class ReplaceFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 3876315232050114189L;

        public ReplaceFilterAction() {
            this.putValue("ShortDescription", "Replace filter.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"shift ENTER");
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container;
            if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                EventWrapperViewPanel.this.logger.info("Replace filter.");
            }
            if ((container = EventWrapperViewPanel.this.resolveContainer()) != null) {
                container.replaceFilteredView(EventWrapperViewPanel.this);
            }
        }
    }

    class EventWrapperViewChangeListener
    implements PropertyChangeListener {
        final Logger logger = LoggerFactory.getLogger(EventWrapperViewChangeListener.class);

        EventWrapperViewChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if (EventWrapperViewPanel.SCROLLING_TO_BOTTOM_PROPERTY.equals(propertyName)) {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                EventWrapperViewPanel.this.firePropertyChange(EventWrapperViewPanel.SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
            } else if (EventWrapperViewPanel.FILTER_CONDITION_PROPERTY.equals(propertyName)) {
                if (null == event.getNewValue()) {
                    EventWrapperViewPanel.this.findPrevAction.setEnabled(false);
                    EventWrapperViewPanel.this.findNextAction.setEnabled(false);
                } else {
                    EventWrapperViewPanel.this.findPrevAction.setEnabled(true);
                    EventWrapperViewPanel.this.findNextAction.setEnabled(true);
                }
            }
        }
    }

    private class ScrollbarChangeListner
    implements ChangeListener {
        private final Logger logger = LoggerFactory.getLogger(ScrollbarChangeListner.class);

        private ScrollbarChangeListner() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeEvent: {}", evt);
            }
            if (EventWrapperViewPanel.this.isScrollingToBottom() && EventWrapperViewPanel.this.verticalLogScrollbar.getModel().getValueIsAdjusting()) {
                EventWrapperViewPanel.this.setScrollingToBottom(false);
            }
        }
    }

    private class TableRowSelectionListener
    implements ListSelectionListener {
        private final Logger logger = LoggerFactory.getLogger(TableRowSelectionListener.class);

        private TableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = EventWrapperViewPanel.this.getSelectedRow();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selected row: {}.", row);
            }
            if (row >= 0) {
                EventWrapper event = (EventWrapper)EventWrapperViewPanel.this.tableModel.getValueAt(row);
                EventWrapperViewPanel.this.setSelectedEvent(event);
                EventWrapperViewPanel.this.initMessage(event);
            } else {
                EventWrapperViewPanel.this.setSelectedEvent(null);
                EventWrapperViewPanel.this.resetMessage();
            }
        }
    }

    private class ScrollPaneMouseListener
    implements MouseListener {
        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapperViewPanel.this.mainFrame.showPopup(EventWrapperViewPanel.this.tableScrollPane, p);
        }

        public void mouseClicked(MouseEvent evt) {
            EventWrapperViewPanel.this.tableScrollPane.requestFocusInWindow();
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class EventViewMouseListener
    implements MouseListener {
        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapperViewPanel.this.mainFrame.showPopup((Component)EventWrapperViewPanel.this.messagePane, p);
        }

        public void mouseClicked(MouseEvent evt) {
            EventWrapperViewPanel.this.messagePane.requestFocusInWindow();
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class TableMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            } else if (evt.getClickCount() > 1 && evt.getButton() == 1) {
                if ((evt.getModifiersEx() & 0x40) != 0) {
                    LoggingEvent loggingEvent;
                    ExtendedStackTraceElement[] callStack;
                    Serializable event;
                    Point p = evt.getPoint();
                    EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
                    if (wrapper != null && (event = wrapper.getEvent()) instanceof LoggingEvent && (callStack = (loggingEvent = (LoggingEvent)event).getCallStack()) != null && callStack.length > 0) {
                        EventWrapperViewPanel.this.mainFrame.goToSource(callStack[0].getStackTraceElement());
                    }
                } else {
                    Point p = evt.getPoint();
                    EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
                    if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                        EventWrapperViewPanel.this.logger.debug("Show unfiltered event {}.", wrapper);
                    }
                    EventWrapperViewPanel.this.showUnfilteredEvent();
                }
            }
        }

        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Show popup at {} for event {}.", p, (Object)wrapper);
            }
            EventWrapperViewPanel.this.mainFrame.showPopup(EventWrapperViewPanel.this.table, p);
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        MyFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(EventWrapperViewPanel.this.table)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.messagePane)) {
                if (EventWrapperViewPanel.this.isShowingFilters()) {
                    return EventWrapperViewPanel.this.findNotButton;
                }
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findNotButton)) {
                return EventWrapperViewPanel.this.findTypeCombo;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findTypeCombo)) {
                return EventWrapperViewPanel.this.findTextField;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findTextField)) {
                if (EventWrapperViewPanel.this.findPrevButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findPrevButton;
                }
                if (EventWrapperViewPanel.this.findNextButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findNextButton;
                }
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPrevButton)) {
                if (EventWrapperViewPanel.this.findNextButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findNextButton;
                }
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findNextButton)) {
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPanel)) {
                return EventWrapperViewPanel.this.table;
            }
            if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                EventWrapperViewPanel.this.logger.info("Moving focus forward to messagePane since it was not explicitly handled. (component={})", aComponent);
            }
            return EventWrapperViewPanel.this.messagePane;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(EventWrapperViewPanel.this.messagePane)) {
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findNotButton)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findTypeCombo)) {
                return EventWrapperViewPanel.this.findNotButton;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findTextField)) {
                return EventWrapperViewPanel.this.findTypeCombo;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPrevButton)) {
                return EventWrapperViewPanel.this.findTextField;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findNextButton)) {
                if (EventWrapperViewPanel.this.findPrevButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findPrevButton;
                }
                return EventWrapperViewPanel.this.findTextField;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPanel)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (EventWrapperViewPanel.this.isShowingFilters()) {
                if (EventWrapperViewPanel.this.findNextButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findNextButton;
                }
                if (EventWrapperViewPanel.this.findPrevButton.isEnabled()) {
                    return EventWrapperViewPanel.this.findPrevButton;
                }
                return EventWrapperViewPanel.this.findTextField;
            }
            if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                EventWrapperViewPanel.this.logger.info("Moving focus backward to messagePane since it was not explicitly handled. (component={})", aComponent);
            }
            return EventWrapperViewPanel.this.messagePane;
        }

        public Component getFirstComponent(Container aContainer) {
            return EventWrapperViewPanel.this.table;
        }

        public Component getLastComponent(Container aContainer) {
            return EventWrapperViewPanel.this.messagePane;
        }

        public Component getDefaultComponent(Container aContainer) {
            return EventWrapperViewPanel.this.table;
        }
    }

    private class SelectFirstEventRunnable
    implements Runnable {
        private SelectFirstEventRunnable() {
        }

        public void run() {
            EventWrapperViewPanel.this.table.scrollToFirst();
        }
    }

    private class ScrollToBottomRunnable
    implements Runnable {
        private ScrollToBottomRunnable() {
        }

        public void run() {
            if (EventWrapperViewPanel.this.table.isScrollingToBottom()) {
                EventWrapperViewPanel.this.table.scrollToBottom();
            }
        }
    }
}

