/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.linklistener.OpenUrlLinkListener;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.SelectionHighlighter;

public class CheckForUpdateDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(CheckForUpdateDialog.class);
    private XHTMLPanel helpPane;
    private SelectionHighlighter.CopyAction copyAction;
    private JLabel messageLabel;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private String docRoot;
    private ApplicationPreferences applicationPreferences;
    private JCheckBox checkForUpdateCheckbox;
    private static final int INSET = 10;
    private static final Icon UPDATE_ICON;

    public CheckForUpdateDialog(MainFrame mainFrame) {
        super(mainFrame);
        this.applicationPreferences = mainFrame.getApplicationPreferences();
        this.setTitle("Check for update...");
        this.setModal(false);
        this.setDefaultCloseOperation(1);
        this.helpPane = new XHTMLPanel();
        LinkListener originalLinkListener = null;
        List mouseTrackingList = this.helpPane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.helpPane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
                originalLinkListener = (LinkListener)o;
            }
        }
        this.helpPane.addMouseTrackingListener((FSMouseListener)new OpenUrlLinkListener(mainFrame, originalLinkListener));
        SelectionHighlighter helpPaneCaret = new SelectionHighlighter();
        helpPaneCaret.install(this.helpPane);
        this.copyAction = new SelectionHighlighter.CopyAction();
        this.copyAction.install(helpPaneCaret);
        this.checkForUpdateCheckbox = new JCheckBox("Check for updates on startup.");
        this.checkForUpdateCheckbox.setSelected(this.applicationPreferences.isCheckingForUpdate());
        this.checkForUpdateCheckbox.addItemListener(new CheckboxListener());
        this.checkForUpdateCheckbox.setMnemonic(85);
        FSScrollPane helpScrollPane = new FSScrollPane((JPanel)this.helpPane);
        helpScrollPane.setPreferredSize(new Dimension(600, 300));
        JPanel content = new JPanel(new GridBagLayout());
        this.setLayout(new GridLayout(1, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.top = 10;
        gbc.insets.bottom = 0;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.messageLabel = new JLabel();
        Font labelFont = this.messageLabel.getFont();
        labelFont = labelFont.deriveFont(1.5f * labelFont.getSize2D());
        this.messageLabel.setFont(labelFont);
        content.add((Component)this.messageLabel, gbc);
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        content.add((Component)helpScrollPane, gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 21;
        content.add((Component)this.checkForUpdateCheckbox, gbc);
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        gbc.anchor = 22;
        gbc.gridy = 3;
        OkAction okAction = new OkAction();
        content.add((Component)new JButton(okAction), gbc);
        KeyStrokes.registerCommand((JComponent)content, (Action)okAction, (String)"OK_ACTION");
        KeyStrokes.registerCommand((JComponent)content, (Action)new CancelAction(), (String)"CANCEL_ACTION");
        this.add(content);
        URL docRootUrl = CheckForUpdateDialog.class.getResource("/help");
        if (docRootUrl != null) {
            this.docRoot = docRootUrl.toString() + "/";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Changes docroot: {}", (Object)this.docRoot);
        }
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
    }

    public void setMessage(String message) {
        if (message == null) {
            this.messageLabel.setText("Your version is up to date.");
            this.messageLabel.setIcon(null);
        } else {
            this.messageLabel.setText(message);
            this.messageLabel.setIcon(UPDATE_ICON);
        }
    }

    public void setChanges(String changes) {
        if (changes == null) {
            changes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html\n\tPUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n<head>\n\t<title>Couldn't load changes file!</title>\n\t<link href=\"help.css\" rel=\"stylesheet\" type=\"text/css\"/>\n</head>\n<body>\n<p>Couldn't load changes file!</p>\n</body>\n</html>";
        }
        this.helpPane.setDocumentFromString(changes, this.docRoot, (NamespaceHandler)this.xhtmlNamespaceHandler);
    }

    public void setCheckingForUpdate(boolean checkingForUpdate) {
        this.checkForUpdateCheckbox.setSelected(checkingForUpdate);
    }

    static {
        URL url = ViewActions.class.getResource("/tango/32x32/status/software-update-available.png");
        ImageIcon icon = url != null ? new ImageIcon(url) : null;
        UPDATE_ICON = icon;
    }

    private class CheckboxListener
    implements ItemListener {
        private CheckboxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ItemSelectable source = e.getItemSelectable();
            if (source == CheckForUpdateDialog.this.checkForUpdateCheckbox) {
                CheckForUpdateDialog.this.applicationPreferences.setCheckingForUpdate(CheckForUpdateDialog.this.checkForUpdateCheckbox.isSelected());
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -7356773009949031885L;

        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (CheckForUpdateDialog.this.logger.isDebugEnabled()) {
                CheckForUpdateDialog.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 67);
        }

        public void actionPerformed(ActionEvent e) {
            CheckForUpdateDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7050362653241782872L;

        public OkAction() {
            super("Ok");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ENTER");
            if (CheckForUpdateDialog.this.logger.isDebugEnabled()) {
                CheckForUpdateDialog.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 79);
        }

        public void actionPerformed(ActionEvent e) {
            CheckForUpdateDialog.this.setVisible(false);
        }
    }
}

