/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.gotosrc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoToSourceService {
    private final Logger logger = LoggerFactory.getLogger(GoToSourceService.class);
    private Socket socket;
    private ObjectOutputStream oos;

    public void start() {
        try {
            this.socket = new Socket("localhost", 11111);
            this.oos = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Exception while creating connection with IDE!", e);
            }
            this.stop();
        }
    }

    public void goToSource(StackTraceElement ste) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Go to source of {}.", ste);
        }
        if (ste == null) {
            return;
        }
        if (this.oos == null) {
            this.start();
        }
        boolean error = false;
        if (this.oos != null) {
            try {
                this.oos.writeObject(ste);
                this.oos.flush();
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exception on first try, probably lingering connection.", e);
                }
                this.stop();
                error = true;
            }
        }
        if (error) {
            this.start();
            if (this.oos != null) {
                try {
                    this.oos.writeObject(ste);
                    this.oos.flush();
                }
                catch (IOException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception on second try!", e);
                    }
                    this.stop();
                }
            }
        }
    }

    public void stop() {
        if (this.oos != null) {
            IOUtils.closeQuietly((OutputStream)this.oos);
            this.oos = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

