/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class MessageContainsCondition
implements LilithCondition {
    private static final long serialVersionUID = -5047505055619482146L;
    private String searchString;

    public MessageContainsCondition() {
        this(null);
    }

    public MessageContainsCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isTrue(Object value) {
        if (this.searchString == null) {
            return false;
        }
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            if (this.searchString.length() == 0) {
                return true;
            }
            if (eventObj instanceof LoggingEvent) {
                LoggingEvent event = (LoggingEvent)eventObj;
                String message = null;
                Message messageObj = event.getMessage();
                if (messageObj != null) {
                    message = messageObj.getMessage();
                }
                return message != null && message.contains(this.searchString);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContainsCondition that = (MessageContainsCondition)o;
        return !(this.searchString == null ? that.searchString != null : !this.searchString.equals(that.searchString));
    }

    public int hashCode() {
        int result = this.searchString != null ? this.searchString.hashCode() : 0;
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setSearchString(this.searchString);
    }

    public MessageContainsCondition clone() throws CloneNotSupportedException {
        return (MessageContainsCondition)super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription()).append("(");
        if (this.searchString != null) {
            result.append("\"");
            result.append(this.searchString);
            result.append("\"");
        } else {
            result.append("null");
        }
        result.append(")");
        return result.toString();
    }

    public String getDescription() {
        return "message.contains";
    }
}

