/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class LevelCondition
implements LilithCondition {
    private static final long serialVersionUID = -5498023202272568557L;
    private String searchString;
    private transient LoggingEvent.Level level;

    public LevelCondition() {
        this(null);
    }

    public LevelCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        try {
            this.level = LoggingEvent.Level.valueOf((String)searchString);
        }
        catch (Throwable e) {
            this.level = null;
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public String getDescription() {
        return "Level>=";
    }

    public boolean isTrue(Object value) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.level == null) {
            return false;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            LoggingEvent.Level eventLevel = event.getLevel();
            return eventLevel != null && this.level.compareTo((Enum)eventLevel) <= 0;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LevelCondition that = (LevelCondition)o;
        return this.level == that.level;
    }

    public int hashCode() {
        return this.level != null ? this.level.hashCode() : 0;
    }

    public LevelCondition clone() throws CloneNotSupportedException {
        LevelCondition result = (LevelCondition)super.clone();
        result.setSearchString(this.searchString);
        return result;
    }

    private Object readResolve() throws ObjectStreamException {
        this.setSearchString(this.searchString);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append(this.level);
        return result.toString();
    }
}

