/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.sourcemanager;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventConsumer;
import de.huxhorn.sulky.buffers.CircularBuffer;
import de.huxhorn.sulky.buffers.RemoveOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPoller<T extends Serializable>
implements Runnable {
    final Logger logger = LoggerFactory.getLogger(EventPoller.class);
    private RemoveOperation<EventWrapper<T>> queue;
    private int pollDelay;
    private List<EventConsumer<T>> consumers;

    public EventPoller(RemoveOperation<EventWrapper<T>> queue) {
        this.queue = queue;
        this.pollDelay = 2000;
    }

    public List<EventConsumer<T>> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(List<EventConsumer<T>> consumers) {
        this.consumers = consumers;
    }

    public RemoveOperation<EventWrapper<T>> getQueue() {
        return this.queue;
    }

    public void setQueue(CircularBuffer<EventWrapper<T>> queue) {
        this.queue = queue;
    }

    @Override
    public void run() {
        while (true) {
            long sleepTime;
            int eventCount;
            long pollTime = System.currentTimeMillis();
            List events = this.queue.removeAll();
            if (events != null && (eventCount = events.size()) > 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Consuming {} events.", (Object)eventCount);
                }
                long time = System.currentTimeMillis();
                if (this.consumers != null) {
                    for (EventConsumer<T> consumer : this.consumers) {
                        try {
                            consumer.consume(events);
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("Executed consumer {}.", consumer);
                        }
                        catch (Throwable t) {
                            if (!this.logger.isWarnEnabled()) continue;
                            this.logger.warn("Exception while executing event consumer!", t);
                        }
                    }
                }
                time = System.currentTimeMillis() - time;
                if ((time /= 1000L) == 0L) {
                    time = 1L;
                }
                int eventsPerSecond = (int)((long)eventCount / time);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Finished consuming {} events ({} events/sec).", (Object)eventCount, (Object)eventsPerSecond);
                }
            }
            if ((sleepTime = (long)this.pollDelay - (pollTime = System.currentTimeMillis() - pollTime)) <= 0L) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Sleeping {} milliseconds.", (Object)sleepTime);
            }
            try {
                Thread.sleep(this.pollDelay);
            }
            catch (InterruptedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Interrupted...");
                }
                return;
            }
        }
    }
}

