/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.protobuf.CompressingLoggingEventWrapperProtobufCodec;
import de.huxhorn.lilith.data.logging.protobuf.LoggingEventWrapperProtobufCodec;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFileBufferFactory
extends FileBufferFactory<LoggingEvent> {
    public LoggingFileBufferFactory(LogFileFactory logFileFactory, Map<String, String> metaData) {
        super(logFileFactory, metaData);
    }

    @Override
    public Codec<EventWrapper<LoggingEvent>> resolveCodec(MetaData metaData) {
        Object codec;
        boolean compressed = false;
        String format = null;
        if (metaData != null) {
            Map data = metaData.getData();
            String compressionStr = (String)data.get("compression");
            if ("GZIP".equals(compressionStr)) {
                compressed = true;
            }
            format = (String)data.get("contentFormat");
        }
        if ("protobuf".equals(format)) {
            codec = compressed ? new CompressingLoggingEventWrapperProtobufCodec() : new LoggingEventWrapperProtobufCodec();
        } else {
            throw new IllegalArgumentException("Unknown content format " + format + "!");
        }
        return codec;
    }
}

