/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileBufferFactory<T extends Serializable> {
    private final Logger logger = LoggerFactory.getLogger(FileBufferFactory.class);
    private LogFileFactory logFileFactory;
    private int magicValue;
    private Map<String, String> metaData;

    public FileBufferFactory(LogFileFactory logFileFactory, Map<String, String> metaData) {
        this.logFileFactory = logFileFactory;
        this.magicValue = 190731757;
        metaData = metaData == null ? new HashMap<String, String>() : new HashMap<String, String>(metaData);
        this.metaData = metaData;
    }

    public LogFileFactory getLogFileFactory() {
        return this.logFileFactory;
    }

    public abstract Codec<EventWrapper<T>> resolveCodec(MetaData var1);

    public FileBuffer<EventWrapper<T>> createBuffer(SourceIdentifier si) {
        File dataFile = this.logFileFactory.getDataFile(si);
        File indexFile = this.logFileFactory.getIndexFile(si);
        HashMap<String, String> usedMetaData = new HashMap<String, String>(this.metaData);
        usedMetaData.put("primaryIdentifier", si.getIdentifier());
        if (si.getSecondaryIdentifier() != null) {
            usedMetaData.put("secondaryIdentifier", si.getSecondaryIdentifier());
        }
        return this.createBuffer(dataFile, indexFile, usedMetaData);
    }

    public FileBuffer<EventWrapper<T>> createBuffer(File dataFile, File indexFile, Map<String, String> usedMetaData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating buffer for dataFile '{}'.", (Object)dataFile.getAbsolutePath());
        }
        CodecFileBuffer result = new CodecFileBuffer(this.magicValue, false, usedMetaData, null, dataFile, indexFile);
        FileHeader fileHeader = result.getFileHeader();
        MetaData actualMetaData = fileHeader.getMetaData();
        result.setCodec(this.resolveCodec(actualMetaData));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created file buffer: {}", (Object)result);
        }
        return result;
    }

    public FileBuffer<EventWrapper<T>> createActiveBuffer(SourceIdentifier si) {
        FileBuffer<EventWrapper<T>> result;
        block2: {
            result = this.createBuffer(si);
            File activeFile = this.logFileFactory.getActiveFile(si);
            try {
                activeFile.createNewFile();
                activeFile.deleteOnExit();
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Couldn't create active-file.");
            }
        }
        return result;
    }
}

