/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.appender;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import de.huxhorn.lilith.sender.HeartbeatRunnable;
import de.huxhorn.lilith.sender.MessageWriteByteStrategy;
import de.huxhorn.lilith.sender.MultiplexSendBytesService;
import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import de.huxhorn.sulky.codec.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiplexSocketAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    private static final int DEFAULT_QUEUE_SIZE = 1000;
    private Encoder<E> encoder;
    private int port;
    private final List<String> remoteHostsList;
    private String applicationIdentifier;
    private Thread heartbeatThread;
    private int reconnectionDelay;
    private WriteByteStrategy writeByteStrategy;
    private int queueSize;
    private MultiplexSendBytesService multiplexSendBytes;
    private boolean debug;

    public MultiplexSocketAppenderBase() {
        this((WriteByteStrategy)new MessageWriteByteStrategy());
    }

    public MultiplexSocketAppenderBase(WriteByteStrategy writeByteStrategy) {
        this(writeByteStrategy, 1000);
    }

    public MultiplexSocketAppenderBase(WriteByteStrategy writeByteStrategy, int queueSize) {
        this.writeByteStrategy = writeByteStrategy;
        this.setQueueSize(queueSize);
        this.remoteHostsList = new ArrayList<String>();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public void setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
        this.applicationIdentifierChanged();
    }

    protected abstract void applicationIdentifierChanged();

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setReconnectionDelay(int reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String> getRemoteHostsList() {
        return new ArrayList<String>(this.remoteHostsList);
    }

    public void setRemoteHosts(String remoteHosts) {
        StringTokenizer tok = new StringTokenizer(remoteHosts, ",", false);
        ArrayList<String> hosts = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String current = tok.nextToken();
            if ("".equals(current = current.trim()) || hosts.contains(current)) continue;
            hosts.add(current);
        }
        this.setRemoteHostsList(hosts);
    }

    public void setRemoteHostsList(List<String> remoteHostsList) {
        if (this.debug) {
            System.err.println("RemoteHosts: " + remoteHostsList);
        }
        this.remoteHostsList.clear();
        this.remoteHostsList.addAll(remoteHostsList);
    }

    public void addRemoteHost(String remoteHost) {
        if (!"".equals(remoteHost = remoteHost.trim()) && !this.remoteHostsList.contains(remoteHost)) {
            this.remoteHostsList.add(remoteHost);
        }
    }

    public void start() {
        if (!this.started) {
            int errorCount = 0;
            if (this.port == 0) {
                ++errorCount;
                this.addError("No port was configured for appender" + this.name + ".");
            }
            if (this.remoteHostsList == null || this.remoteHostsList.size() == 0) {
                ++errorCount;
                this.addError("No remote addresses were configured for appender" + this.name + ".");
            }
            if (this.queueSize < 1) {
                ++errorCount;
                this.addError("Invalid queue size configured for appender" + this.name + ". Queue size must be at least 1!");
            }
            if (errorCount == 0) {
                this.initialize();
                this.started = true;
            }
            this.addInfo("Waiting 1s to establish connections.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addInfo("Started " + (Object)((Object)this));
        }
    }

    private void initialize() {
        this.multiplexSendBytes = new MultiplexSendBytesService(this.name, this.remoteHostsList, this.port, this.writeByteStrategy, this.reconnectionDelay, this.queueSize);
        this.multiplexSendBytes.setDebug(this.debug);
        this.multiplexSendBytes.startUp();
        this.heartbeatThread = new Thread((Runnable)new HeartbeatRunnable((SendBytesService)this.multiplexSendBytes), this.name + " Heartbeat");
        this.heartbeatThread.setDaemon(true);
        this.heartbeatThread.start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.started = false;
        this.cleanUp();
    }

    private void cleanUp() {
        this.addInfo("Cleaning up " + (Object)((Object)this) + ".");
        this.heartbeatThread.interrupt();
        this.multiplexSendBytes.shutDown();
    }

    protected void sendBytes(byte[] bytes) {
        this.multiplexSendBytes.sendBytes(bytes);
    }

    protected void append(E e) {
        if (this.encoder != null) {
            this.preProcess(e);
            byte[] serialized = this.encoder.encode(e);
            if (serialized != null) {
                this.sendBytes(serialized);
            }
        }
    }

    protected abstract void preProcess(E var1);

    protected Encoder<E> getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

