/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import org.rrd4j.core.jrrd.RRDFile;

public class CDPStatusBlock {
    long offset;
    long size;
    int unknownDatapoints;
    double value;

    CDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.value = rRDFile.readDouble();
        this.unknownDatapoints = rRDFile.readInt();
        rRDFile.skipBytes(68);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public int getUnknownDatapoints() {
        return this.unknownDatapoints;
    }

    public double getValue() {
        return this.value;
    }

    void toXml(PrintStream printStream) {
        printStream.print("\t\t\t<ds><value> ");
        printStream.print(this.value);
        printStream.print(" </value>  <unknown_datapoints> ");
        printStream.print(this.unknownDatapoints);
        printStream.println(" </unknown_datapoints></ds>");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[CDPStatusBlock: OFFSET=0x");
        stringBuilder.append(Long.toHexString(this.offset));
        stringBuilder.append(", SIZE=0x");
        stringBuilder.append(Long.toHexString(this.size));
        stringBuilder.append(", unknownDatapoints=");
        stringBuilder.append(this.unknownDatapoints);
        stringBuilder.append(", value=");
        stringBuilder.append(this.value);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

