/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource inputSource) throws IOException {
        super(inputSource);
    }

    public RrdDefTemplate(String string) throws IOException {
        super(string);
    }

    public RrdDefTemplate(File file) throws IOException {
        super(file);
    }

    public RrdDef getRrdDef() {
        Enum enum_;
        Node[] nodeArray;
        Node[] nodeArray2;
        if (!this.root.getTagName().equals("rrd_def")) {
            throw new IllegalArgumentException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String string = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(string);
        try {
            String string2 = this.getChildValue(this.root, "start");
            nodeArray2 = Util.getCalendar(string2);
            rrdDef.setStartTime((Calendar)nodeArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            long l = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nodeArray2 = nodeArray = RrdDefTemplate.getChildNodes(this.root, "datasource");
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray2[i];
            this.validateTagsOnlyOnce(node, new String[]{"name", "type", "heartbeat", "min", "max"});
            String object = this.getChildValue(node, "name");
            enum_ = DsType.valueOf(this.getChildValue(node, "type"));
            long l = this.getChildValueAsLong(node, "heartbeat");
            double d = this.getChildValueAsDouble(node, "min");
            double d2 = this.getChildValueAsDouble(node, "max");
            rrdDef.addDatasource(object, (DsType)enum_, l, d, d2);
        }
        for (Node node : nodeArray2 = RrdDefTemplate.getChildNodes(this.root, "archive")) {
            this.validateTagsOnlyOnce(node, new String[]{"cf", "xff", "steps", "rows"});
            enum_ = ConsolFun.valueOf(this.getChildValue(node, "cf"));
            double d = this.getChildValueAsDouble(node, "xff");
            int n2 = this.getChildValueAsInt(node, "steps");
            int n3 = this.getChildValueAsInt(node, "rows");
            rrdDef.addArchive((ConsolFun)enum_, d, n2, n3);
        }
        return rrdDef;
    }
}

