/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.filebuffer.IndexStrategy;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefaultIndexStrategy
implements IndexStrategy {
    public static final long DATA_OFFSET_SIZE = 8L;

    public void setOffset(RandomAccessFile indexFile, long index, long offset) throws IOException {
        long offsetOffset = 8L * index;
        long fileLength = indexFile.length();
        if (fileLength < offsetOffset) {
            long lastIndex = fileLength / 8L;
            indexFile.seek(lastIndex * 8L);
            for (long i = lastIndex; i < index; ++i) {
                indexFile.writeLong(-1L);
            }
        }
        indexFile.seek(offsetOffset);
        indexFile.writeLong(offset);
    }

    public long getOffset(RandomAccessFile indexFile, long index) throws IOException {
        long offsetOffset = 8L * index;
        if (indexFile.length() < offsetOffset + 8L) {
            return -1L;
        }
        indexFile.seek(offsetOffset);
        return indexFile.readLong();
    }

    public long getSize(RandomAccessFile indexFile) throws IOException {
        return indexFile.length() / 8L;
    }
}

