/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggerComparator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerContext
extends ContextBase
implements ILoggerFactory,
LifeCycle {
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private final List<LoggerContextListener> loggerContextListenerList = new ArrayList<LoggerContextListener>();
    private Hashtable<String, Logger> loggerCache;
    private LoggerContextVO loggerContextRemoteView;
    private final TurboFilterList turboFilterList = new TurboFilterList();
    private boolean packagingDataEnabled = true;
    private int maxCallerDataDepth = 8;
    boolean started = false;
    int resetCount = 0;

    public LoggerContext() {
        this.loggerCache = new Hashtable();
        this.loggerContextRemoteView = new LoggerContextVO(this);
        this.root = new Logger("ROOT", null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put("ROOT", this.root);
        this.putObject("EVALUATOR_MAP", new HashMap());
        this.size = 1;
    }

    private void syncRemoteView() {
        this.loggerContextRemoteView = new LoggerContextVO(this);
        for (Logger logger : this.loggerCache.values()) {
            logger.buildRemoteView();
        }
    }

    public void putProperty(String key, String val) {
        super.putProperty(key, val);
        this.syncRemoteView();
    }

    public void setName(String name) {
        super.setName(name);
        this.syncRemoteView();
    }

    public final Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger getLogger(String name) {
        int h;
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if ("ROOT".equalsIgnoreCase(name)) {
            return this.root;
        }
        int i = 0;
        Logger logger = this.root;
        Logger childLogger = this.loggerCache.get(name);
        if (childLogger != null) {
            return childLogger;
        }
        do {
            String childName = (h = name.indexOf(46, i)) == -1 ? name : name.substring(0, h);
            i = h + 1;
            Logger logger2 = logger;
            synchronized (logger2) {
                childLogger = logger.getChildByName(childName);
                if (childLogger == null) {
                    childLogger = logger.createChildByName(childName);
                    this.loggerCache.put(childName, childLogger);
                    this.incSize();
                }
            }
            logger = childLogger;
        } while (h != -1);
        return childLogger;
    }

    private void incSize() {
        ++this.size;
    }

    int size() {
        return this.size;
    }

    public Logger exists(String name) {
        return this.loggerCache.get(name);
    }

    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            this.getStatusManager().add((Status)new WarnStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", (Object)logger));
        }
    }

    public List<Logger> getLoggerList() {
        Collection<Logger> collection = this.loggerCache.values();
        ArrayList<Logger> loggerList = new ArrayList<Logger>(collection);
        Collections.sort(loggerList, new LoggerComparator());
        return loggerList;
    }

    public LoggerContextVO getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }

    public void setPackagingDataEnabled(boolean packagingDataEnabled) {
        this.packagingDataEnabled = packagingDataEnabled;
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    public void reset() {
        ++this.resetCount;
        super.reset();
        this.root.recursiveReset();
        this.resetTurboFilterList();
        this.fireOnReset();
        this.resetListenersExceptResetResistant();
        this.resetStatusListeners();
    }

    private void resetStatusListeners() {
        StatusManager sm = this.getStatusManager();
        for (StatusListener sl : sm.getCopyOfStatusListenerList()) {
            sm.remove(sl);
        }
    }

    public TurboFilterList getTurboFilterList() {
        return this.turboFilterList;
    }

    public void addTurboFilter(TurboFilter newFilter) {
        this.turboFilterList.add(newFilter);
    }

    public void resetTurboFilterList() {
        for (TurboFilter tf : this.turboFilterList) {
            tf.stop();
        }
        this.turboFilterList.clear();
    }

    final FilterReply getTurboFilterChainDecision_0_3OrMore(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, format, params, t);
    }

    final FilterReply getTurboFilterChainDecision_1(Marker marker, Logger logger, Level level, String format, Object param, Throwable t) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, format, new Object[]{param}, t);
    }

    final FilterReply getTurboFilterChainDecision_2(Marker marker, Logger logger, Level level, String format, Object param1, Object param2, Throwable t) {
        if (this.turboFilterList.size() == 0) {
            return FilterReply.NEUTRAL;
        }
        return this.turboFilterList.getTurboFilterChainDecision(marker, logger, level, format, new Object[]{param1, param2}, t);
    }

    public void addListener(LoggerContextListener listener) {
        this.loggerContextListenerList.add(listener);
    }

    public void removeListener(LoggerContextListener listener) {
        this.loggerContextListenerList.remove(listener);
    }

    private void resetListenersExceptResetResistant() {
        ArrayList<LoggerContextListener> toRetain = new ArrayList<LoggerContextListener>();
        for (LoggerContextListener lcl : this.loggerContextListenerList) {
            if (!lcl.isResetResistant()) continue;
            toRetain.add(lcl);
        }
        this.loggerContextListenerList.retainAll(toRetain);
    }

    private void resetAllListeners() {
        this.loggerContextListenerList.clear();
    }

    public List<LoggerContextListener> getCopyOfListenerList() {
        return new ArrayList<LoggerContextListener>(this.loggerContextListenerList);
    }

    private void fireOnReset() {
        for (LoggerContextListener listener : this.loggerContextListenerList) {
            listener.onReset(this);
        }
    }

    private void fireOnStart() {
        for (LoggerContextListener listener : this.loggerContextListenerList) {
            listener.onStart(this);
        }
    }

    private void fireOnStop() {
        for (LoggerContextListener listener : this.loggerContextListenerList) {
            listener.onStop(this);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        this.fireOnStart();
    }

    public void stop() {
        this.reset();
        this.fireOnStop();
        this.resetAllListeners();
        this.started = false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.getName() + "]";
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    public void setMaxCallerDataDepth(int maxCallerDataDepth) {
        this.maxCallerDataDepth = maxCallerDataDepth;
    }
}

