/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.rrd4j.core.jrrd.Constants;

public class RRDFile
implements Constants {
    boolean bigEndian;
    int alignment;
    RandomAccessFile ras;
    byte[] buffer;

    RRDFile(String string) throws IOException {
        this(new File(string));
    }

    RRDFile(File file) throws IOException {
        this.ras = new RandomAccessFile(file, "r");
        this.buffer = new byte[128];
        this.initDataLayout(file);
    }

    private void initDataLayout(File file) throws IOException {
        if (file.exists()) {
            this.ras.read(this.buffer, 0, 24);
            int n = this.indexOf(FLOAT_COOKIE_BIG_ENDIAN, this.buffer);
            if (n != -1) {
                this.bigEndian = true;
            } else {
                n = this.indexOf(FLOAT_COOKIE_LITTLE_ENDIAN, this.buffer);
                if (n != -1) {
                    this.bigEndian = false;
                } else {
                    throw new IOException("Invalid RRD file");
                }
            }
            switch (n) {
                case 12: {
                    this.alignment = 4;
                    break;
                }
                case 16: {
                    this.alignment = 8;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported architecture");
                }
            }
        }
        this.ras.seek(0L);
    }

    private int indexOf(byte[] byArray, byte[] byArray2) {
        return new String(byArray2).indexOf(new String(byArray));
    }

    boolean isBigEndian() {
        return this.bigEndian;
    }

    int getAlignment() {
        return this.alignment;
    }

    double readDouble() throws IOException {
        byte[] byArray = new byte[8];
        this.ras.read(this.buffer, 0, 8);
        if (this.bigEndian) {
            byArray = this.buffer;
        } else {
            for (int i = 0; i < 8; ++i) {
                byArray[7 - i] = this.buffer[i];
            }
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        return dataInputStream.readDouble();
    }

    int readInt() throws IOException {
        return this.readInt(false);
    }

    int readInt(boolean bl) throws IOException {
        this.ras.read(this.buffer, 0, 4);
        int n = this.bigEndian ? 0xFF & this.buffer[3] | (0xFF & this.buffer[2]) << 8 | (0xFF & this.buffer[1]) << 16 | (0xFF & this.buffer[0]) << 24 : 0xFF & this.buffer[0] | (0xFF & this.buffer[1]) << 8 | (0xFF & this.buffer[2]) << 16 | (0xFF & this.buffer[3]) << 24;
        return n;
    }

    String readString(int n) throws IOException {
        this.ras.read(this.buffer, 0, n);
        return new String(this.buffer, 0, n).trim();
    }

    void skipBytes(int n) throws IOException {
        this.ras.skipBytes(n);
    }

    int align(int n) throws IOException {
        int n2 = (int)((long)n - this.ras.getFilePointer() % (long)n) % n;
        if (n2 != 0) {
            this.ras.skipBytes(n2);
        }
        return n2;
    }

    int align() throws IOException {
        return this.align(this.alignment);
    }

    long info() throws IOException {
        return this.ras.getFilePointer();
    }

    long getFilePointer() throws IOException {
        return this.ras.getFilePointer();
    }

    void close() throws IOException {
        this.ras.close();
    }
}

