/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import org.rrd4j.DsType;
import org.rrd4j.core.Util;

public class DsDef {
    static final String FORCE_ZEROS_FOR_NANS_SUFFIX = "!";
    private String dsName;
    private DsType dsType;
    private long heartbeat;
    private double minValue;
    private double maxValue;

    public DsDef(String string, DsType dsType, long l, double d, double d2) {
        if (string == null) {
            throw new IllegalArgumentException("Null datasource name specified");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Datasource name length equal to zero");
        }
        if (string.length() > 20) {
            throw new IllegalArgumentException("Datasource name [" + string + "] to long (" + string.length() + " chars found, only " + 20 + " allowed");
        }
        if (dsType == null) {
            throw new IllegalArgumentException("Null datasource type specified");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid heartbeat, must be positive: " + l);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2) && d >= d2) {
            throw new IllegalArgumentException("Invalid min/max values specified: " + d + "/" + d2);
        }
        this.dsName = string;
        this.dsType = dsType;
        this.heartbeat = l;
        this.minValue = d;
        this.maxValue = d2;
    }

    public String getDsName() {
        return this.dsName;
    }

    public DsType getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + (Object)((Object)this.dsType) + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, "U", false) + ":" + Util.formatDouble(this.maxValue, "U", false);
    }

    public boolean equals(Object object) {
        if (object instanceof DsDef) {
            DsDef dsDef = (DsDef)object;
            return this.dsName.equals(dsDef.dsName);
        }
        return false;
    }

    boolean exactlyEqual(DsDef dsDef) {
        return this.dsName.equals(dsDef.dsName) && this.dsType == dsDef.dsType && this.heartbeat == dsDef.heartbeat && Util.equal(this.minValue, dsDef.minValue) && Util.equal(this.maxValue, dsDef.maxValue);
    }
}

